PROGRAM Mot_1042;
{
  Bidirectional stepping motor control from parallel printer port using
  CLOCK & DIRECTION control logic.
}
USES CRT, My_Tpu, PRINTER;
CONST Clk = 1;   { clock data bit, D0     }
      Dir = 2;   { direction data bit, D1 }
        t = 100; { time delay dependent on your computer's clock speed }
VAR                         E : INTEGER;
    Lpt_Num, Lpt_Port_Address : WORD;

BEGIN
   (* %%%%%%%%%%%%%%%%%%%%%%% -=[ METHOD ONE ]=- %%%%%%%%%%%%%%%%%%%% *)

{
   Advance stepper motor shaft 40 steps in clockwise direction.
   With Dir, bit D1, held low, strobe the clock line, D0, 40 times.
   This method only works with LPT1.
}
WRITE(LST, CHAR(0)); { intitilize to clockwise direction, data = 0 }
FOR E := 1 TO 40 DO
  BEGIN
  WRITE(LST, CHR(CLK)); { 00000001 } DELAY(t);
  WRITE(LST, CHR(0));   { 00000000 } DELAY(t);
  END; { for e }
{
   Advance stepper motor shaft 40 steps in counter-clockwise direction.
   With Dir, bit D1, held high, strobe the clock line, D0, 40 times.
}
FOR E := 1 TO 40 DO
  BEGIN
  WRITE(LST, CHR(CLK + DIR));   { 00000011 }  DELAY(t);
  WRITE(LST, CHR(DIR));         { 00000010 }  DELAY(t);
  END; { for e }

   (* %%%%%%%%%%%%%%%%%%%%%%% -=[ METHOD TWO ]=- %%%%%%%%%%%%%%%%%%%% *)

Select_Printer_Port(Lpt_Num, Lpt_Port_Address);
{
   Advance stepper motor shaft 40 steps in clockwise direction.
   With Dir, bit D1, held low, strobe the clock line, D0, 40 times.
   This method permits selection of LPT1, LPT2 or LPT3.
}

FOR E := 1 TO 40 DO
  BEGIN
  PORT[Lpt_Port_Address] :=  CLK; { 00000001 } DELAY(t);
  PORT[Lpt_Port_Address] :=  0;   { 00000000 } DELAY(t);
  END; { for e }
{
   Advance stepper motor shaft 40 steps in counter-clockwise direction.
   With Dir, bit D1, held high, strobe the clock line, D0, 40 times.
}
FOR E := 1 TO 40 DO
  BEGIN
  PORT[Lpt_Port_Address] :=  CLK + DIR; { 00000011 } DELAY(t);
  PORT[Lpt_Port_Address] :=  DIR;       { 00000010 } DELAY(t);
  END; { for e }
END.
