
PROGRAM MOT_BIN;
{
  Stepping motor control via BINARY code. Written in Turbo Pascal 6.0
 
  Since the printer port latches data sent to it, data sent to a printer
  port will remain on the output pins until  new data replaces it.  That
  means stepping motors, directly driven by printer port logic, will hold
  there position between transmitted instructions.
}
USES CRT, PRINTER, My_Tpu;
CONST t = 300;
VAR                      D, E : INTEGER;
    Lpt_Num, Lpt_Port_Address : WORD;

BEGIN
   (* %%%%%%%%%%%%%%%%%%%%%%%%  -=[ METHOD ONE ]=-  %%%%%%%%%%%%%%%%% *)
 {
   Uses Pascal's WRITE command to transmit data through computer's LPT1
   printer port.  The WRITE command sends data WITHOUT generating printer
   Line Feed, or Carriage Return, instructions.
 }
FOR E := 1 TO 10 DO  { step motor clockwise through 40 steps }
  FOR D := 0 TO 3 DO 
    BEGIN 
    WRITE(LST, CHAR(D));  { transmit binary value }
    DELAY(t); 
    END;

FOR E := 1 TO 10 DO  { step motor counter-clockwise through 40 steps }
  FOR D := 3 DOWNTO 0 DO 
    BEGIN 
    WRITE(LST, CHAR(D));  { transmit binary value }
    DELAY(t);
    END;

   (* %%%%%%%%%%%%%%%%%%%%%%%%  -=[ METHOD TWO ]=-  %%%%%%%%%%%%%%%%% *)
 {
   Stepping Motor control via binary logic is sent to printer port LPT1, LPT2,
   or LPT3.  From users keyboard input of the number 1, 2, or 3, port's
   address is computed, and used to route control code.
 }
Select_Printer_Port(Lpt_Num, Lpt_Port_Address);
FOR E := 1 TO 10 DO    { step motor clockwise through 40 steps }
  FOR D := 0 TO 3 DO 
    BEGIN 
    PORT[Lpt_Port_Address] := D;  { transmit binary value }
    DELAY(t); 
    END;

FOR E := 1 TO 10 DO  { step motor counter-clockwise through 40 steps }
  FOR D := 3 DOWNTO 0 DO 
    BEGIN 
    PORT[Lpt_Port_Address] := D;  { transmit binary value }
    DELAY(t); 
    END;
END.
