PROGRAM Music; { Signetics PCD3311 }
{
FILE: Music.PAS, by Paul Bergsman 11/10/199

Play Dill Pickle Rag via PCD331 Tone Generator
}
USES CRT;

CONST
  T : ARRAY[1..26] OF INTEGER =             { define musical tone values }
      ($30, $31, $32, $33, $34, $35, $36, $37, $38, $39, $3A, $29, $3B,
       $3C, $3D, $0E, $3E, $2C, $3F, $04, $05, $25, $2F, $06, $07, $00);

{ Define music to be played.  Byte[0] continues number of bytes in array  }
{ smallest note is a 16th, so all notes are defined as 16th notes.        }
{ Music was transcribed by listing the ordinal value of T[n] over sheet   }
{ music notes,  then recording values into constant arrays below.         }
{ First number in array = number of active elements in array              }

  Intro : ARRAY[0 .. 6] OF INTEGER = (6,9,9,10,10,11,11);
 Line_1 : ARRAY[0 .. 32] OF INTEGER = (32,12,14,17,12,14,17,12,14,
   17,12,14,17,17,14,12,12,5,7,9,5,7,9,5,7,9,5,7,9,9,7,5,5);
 End_A1 : ARRAY[0 .. 32] OF INTEGER = (32,0,2,4,0,2,4,0,2,4,0,2,4,
   4,2,0,0,5,4,5,2,2,4,5,6,7,6,7,12,12,9,10,11);
 End_A2 : ARRAY[0 .. 32] OF INTEGER = (32,0,2,4,0,2,4,0,2,4,0,2,4,
   4,2,0,0,7,6,7,12,12,9,7,7,5,5,5,5,5,7,3,2);
 Line_2 : ARRAY[0 .. 32] OF INTEGER = (32,0,0,1,1,2,2,4,4,
   5,5,14,12,12,14,12,12,4,4,14,12,12,14,12,12,5,5,14,12,12,14,12,12);
 End_B1 : ARRAY[0 .. 32] OF INTEGER = (32,0,7,2,7,3,7,4,7,
   5,5,14,12,12,14,12,12,7,9,11,7,9,11,11,11,12,12,12,12,12,5,3,2);
 End_B2 : ARRAY[0 .. 32] OF INTEGER = (32,0,7,2,7,3,7,4,7,
   5,5,14,12,12,14,12,12,13,14,16, 12,14,16,16,16,17,17,17,17,17,17,17,17);
 Line_3 : ARRAY[0 .. 32] OF INTEGER = (32,10,7,5,10,7,5,2,3,
   5,2,5,7,7,5,2,2,0,-1,0,5,5,2,0,0, -2,-2,-2,-2,7,7,9,9);
 Line_4 : ARRAY[0 .. 32] OF INTEGER = (32,10,7,5,10,7,5,2,3,
   5,2,5,7,7,5,2,2,7,6,7,12,12,9,7,7,5,5,5,5,7,7,9,9);
 Line_5 : ARRAY[0 .. 32] OF INTEGER = (32,10,7,5,10,7,5,2,3,
   5,2,5,7,7,5,2,2,0,-1,0,5,5,2,0,0,-2,-2,-2,-2,10,10,9,9);
 Line_6 : ARRAY[0 .. 32] OF INTEGER = (32,7,5,7,9,10,9,10,12,
  14,13,14,19,19,17,14,14,12,11,12,17,17,14,12,12,10,10,10,10,10,10,7,9);
 Line_7 : ARRAY[0 .. 32] OF INTEGER = (32,7,5,7,9,10,9,10,12,
  14,13,14,19,19,17,14,14,12,11,12,17,17,14,12,12,10,10,10,10,5,5,5,5);

VAR Printer : TEXT;
    A, C, E : INTEGER;

PROCEDURE Play_Note(Note : INTEGER);
BEGIN
{ all notes transposed up three tones because chip starts at D# not C       }
WRITE(Printer, CHAR(T[Note + 3]));
DELAY(150);
If KEYPRESSED THEN HALT;                     { exit program when keypressed }
END;

PROCEDURE Display_Music;
BEGIN

CLrScr;
GOTOXY(10,2); WRITELN('-=[ DILL PICKEL RAG ]=-  by Charles L. Johnson ');
gotoxy(10,4); writeln('    transcribed by Paul Bergsman, 11/10/1992 ');
GoToXY(1,7);
Writeln
('                                                                           O');
WRITELN
('#');
WRITELN
('                                                              O');
WRITELN
('#');
WRITELN
('                                               O  #O');
WRITELN
('');
WRITELN
('                                   O  #O');
WRITELN
('#');
WRITELN
('                     O #O');
WRITELN
('');
writeln
('           O  #O');
writeln
(' -- #--');
WRITELN;
Writeln
(' -3   -2  -1   1   2  3  4   5   6  7   8   9  10  11  12  13  14  15  16  17');
END; { display music }

BEGIN { main }
{ my third party printer card used for development work is at LPT2 }
ASSIGN(Printer, 'LPT2'); REWRITE (Printer);
Display_Music;

REPEAT
GOTOXY(5,24); WRITE('PLAYING PART A                                        ');
  FOR E := 1 TO Intro[0] do Play_Note(Intro[E]);
  For E := 1 to Line_1[0] do Play_Note(LINE_1[E]);
  For E := 1 to End_A1[0] do Play_Note(End_A1[E]);
  For E := 1 to Line_1[0] do Play_Note(LINE_1[E]);
  For E := 1 to End_A2[0] do Play_Note(End_A2[E]);
GOTOXY(5,24); WRITE('                 PLAYING PART B     ');
  For E := 1 to Line_2[0] do Play_Note(LINE_2[E]);
  For E := 1 to End_B1[0] do Play_Note(End_B1[E]);
  For E := 1 to Line_2[0] do Play_Note(LINE_2[E]);
  For E := 1 to End_B2[0] do Play_Note(End_B2[E]);
GOTOXY(5,24); WRITE('                                    PLAYING PART C');
  For A := 1 to 2 do
    BEGIN
    For E := 1 to Line_3[0] do Play_Note(Line_3[E]);
    For E := 1 to Line_4[0] do Play_Note(Line_4[E]);
    For E := 1 to Line_5[0] do Play_Note(Line_5[E]);
    IF A = 1 THEN For E := 1 to Line_6[0] do Play_Note(Line_6[E])
      ELSE For E := 1 to Line_7[0] do Play_Note(Line_7[E]);
    END; { for a }
  UNTIL KEYPRESSED;                             { just keep playing the song }
END. { main }

