PROGRAM OPTO_IN;
{
  Input 8-bit opto-coupled data via a parallel printer port.
  Output 4 opto-coupled control bits.

  written in Turbo Pascal 6.0
}
USES CRT;
CONST LptPortAddress = 888; { = CGA card's printer port address }
                            { use 956 for MGA card's printer port address }
                            { use 632 for 3rd priinter port address }
VAR E, Data_Bit, Low_Nibble, High_Nibble : BYTE;
                            Power_Of_Two : INTEGER;
                                      Ch : CHAR;
BEGIN
REPEAT
PORT[LptPortAddress + 2] := 4; { set all low nibble output bits high so
                                 open collector inputs can be read }
 { read in data }
Low_Nibble := PORT[LptPortAddress + 2];  { base + 2 address, bits D0 - D3 }
High_Nibble := PORT[LptPortAddress + 1]; { base + 1 address, bits D4 - D7 }
 { process data }
Low_Nibble := Low_Nibble AND $0F;        { 00001111 }
Low_Nibble := Low_Nibble XOR $0B;        { 00001011, reinvert inverted bits }
High_Nibble := High_Nibble AND $F0;      { 11110000 }
High_Nibble := High_Nibble XOR 128;      { 10000000, reinvert inverted bits }
Data_Bit := High_Nibble OR Low_Nibble;
 { display results }
WRITELN (High_Nibble:5, Low_Nibble:5, Data_Bit:5);
UNTIL KEYPRESSED; Ch := ReadKey;
 { send control bits, printer port's base address, bits D0 - D3  }
REPEAT
Power_Of_Two := 1;
  REPEAT
  PORT[LptPortAddress] := Power_Of_Two;
  WRITE(POWER_OF_TWO:5);
  Power_Of_Two := Power_Of_Two * 2;
  IF KEYPRESSED THEN EXIT;
  DELAY(100);
  UNTIL Power_Of_Two > 8;
WRITELN;
UNTIL KEYPRESSED;
END.
