PROGRAM OSC_8253; { Produce a square wave using Intel's 8253                  }
                  { Program developed form information in Intel's data manual }
                  { file = 8253_OSC.PAS                                       }

USES CRT, PRINTER, My_Tpu;
CONST    A0 = 1; { D0, Bit 1, = Strbe at Base-Address + 2                     }
         A1 = 2; { D1, Bit 2, = Auto-Feed at Base-Address + 2                 }
         WR = 4; { D2, Bit 3, = Initialize at Base-Address + 2                }
         CS = 8; { D3, Bit 4, = Select-Input at Base-Address + 2              }
VAR Control_Word, Data, Control_Lines : BYTE;
                      Lptx, Data_Word : WORD;
                               Num, E : INTEGER;
                                   Ch : CHAR;

PROCEDURE Send_Control_Word;
BEGIN   { set up Counter 0 to Mode 3, Square Wave Generator                   }
        {                              D7  D6  D5  D4    D3  D2  D1  D0       }
        {                             Sc1 Sc0 RL1 RL0    M2  M1  M0 BCD       }
        {          select counter       0   0                                 }
        {       Load LSB then MSB               1   1                         }
        {           Select Mode 3                         0   1   1           }
        { No Binary Coded Decimal                                     0       }
        {                           -----------------------------------       }
Control_Word := $36; {                  0   0   1   1     0   1   1   0       }
PORT[Lptx] := Control_Word; { place control word on printer port's data lines }

                      {                INTEL 8253 PINS:  CS   WR   A1   A0    }
                      {                                  __        __   __    }
                      {              PRINTER PORT PINS:  D3   D2   D1   D0    }
PORT[Lptx + 2] := $4; { Set ALL  control lines HIGH;     0    1    0    0     }
PORT[Lptx + 2] := $C; { set CS line to active LOW        1    1    0    0     }
PORT[Lptx + 2] := $8; { set WR line to active LOW        1    0    0    0     }
PORT[Lptx + 2] := $C; { set WR line to inactive HIGH     1    1    0    0     }
PORT[Lptx + 2] := $4; { set CS line to inactive HIGH     0    1    0    0     }
END; { send control word }

PROCEDURE Send_Data(Data : BYTE);
BEGIN
PORT[Lptx] := Data;
                      {                INTEL 8253 PINS:  CS   WR   A1   A0  }
                      {                                  __        __   __  }
                      {              PRINTER PORT PINS:  D3   D2   D1   D0  }
PORT[Lptx + 2] := $4; { turn ALL lines to inactive HIGHs  0    1    0    0  }
PORT[Lptx + 2] := $7; { Set A0 and A1 to LOW              0    1    1    1  }
PORT[Lptx + 2] := $F; { set CS line to active LOW         1    1    1    1  }
PORT[Lptx + 2] := $B; { set WR line to active LOW         1    0    1    1  }
PORT[Lptx + 2] := $F; { set WR line to inactive HIGH      1    1    1    1  }
PORT[Lptx + 2] := $7; { set CS line to inactive HIGH      0    1    1    1  }
END; { send data }

BEGIN { main }
ClrScr; Num := 2;
Lptx := Find_LPTx(Num); { in MY_Tpu }
   { Initilize the control lines }
Port[Lptx + 2] := $04; { 0000 0100 }
Data_Word := $7FFF;     { set initial frequency a about the middle of range }
  REPEAT
    REPEAT
      REPEAT UNTIL KEYPRESSED;
    Ch := ReadKey;
    UNTIL ORD(CH) IN [ 73, 81, 27 ];
    CASE ORD(CH) OF
      73 : IF Data_Word < $E000 THEN Data_Word := Data_Word + $0FFF;
      81 : IF Data_Word > $100F THEN Data_Word := Data_Word - $0FFF;
      27 : EXIT;      { pressing ESC key exits program }
      END;  { case }
  WRITELN(' DATA WORD = ',Data_Word);
  Send_Control_Word;
  Send_Data(Lo(Data_Word));
  Send_Data(Hi(Data_Word));
  UNTIL ORD(Ch) = 27; { pressing ESC key exits program }
END. { main }
