;
;                         Two Second Beep
;
;
;   This example program uses the system event wait function and
;   timer 2 to generate a 5 KHz tone for 2 seconds.  It's real
;   purpose is to contrast how C is used to access interrupts
;   and I/O ports.
;
;   (c) Copyright 1994, 1996  Frank van Gilluwe
;   All Rights Reserved.

include undocpc.inc

        org     100h               ; build as COM program

cseg    segment para public
        assume  cs:cseg, ds:cseg

; first set up Timer 2 for 5 KHz signal

beepa   proc    near
        mov     al, 0B6h        ; timer 2 mode set
        out     43h, al         ; set mode
        mov     ax, 0EEh        ; for 5kHz: 1190/5 = 0EEh
        IODELAY
        out     42h, al         ; set LSB of counter
        mov     al, ah
        IODELAY
        out     42h, al         ; set MSB of counter

; Activate Speaker

        in      al, 61h
        or      al, 3           ; connect speaker to timer 2
        IODELAY
        out     61h, al

; Wait for 2 seconds

        mov     ah, 86h         ; system wait function
        mov     cx, 1Eh         ; cx:dx = 1E8480h for 2 seconds
        mov     dx, 8480h	;   (1E8480h = 2,000,000 uS)
        int     15h             ; wait for 2 seconds

; Turn off speaker

        in      al, 61h
        and     al, 0FCh        ; turn off speaker
        IODELAY
        out     61h, al

; Exit to DOS

        mov     ah, 4Ch
        int     21h
beepa   endp

cseg    ends

        end
