/*
                    Two Second Beep - Microsoft C
  

   This example program uses the system event wait function and
   timer 2 to generate a 5 KHz tone for 2 seconds.  It's real
   purpose is to contrast how assembly code is used to access
   interrupts and I/O ports.

   (c) Copyright 1993, 1996  Frank van Gilluwe
   All Rights Reserved.                                          */

#include "dos.h"

int main(void)
{
        static union _REGS ourregs;

        // first set up Timer 2 for 5 KHz signal

        _outp(0x43, 0xB6);      // timer 2 mode set
                                // for 5kHz: 1190/5 = 0xEE
        _outp(0x42, 0xEE);      // set LSB of counter
        _outp(0x42, 0);         // set MSB of counter


        // Activate Speaker and connect timer to speaker by
        //   only setting bits 0 and 1 of port 0x61.  Other
        //   bits are left unchanged by reading bits first.

        _outp(0x61, (_inp(0x61) | 0x03));


        // Wait for 2 seconds, using interrupt 15, function 86

        ourregs.h.ah = 0x86;
        ourregs.x.cx = 0x1E;		// 0x1E8480 = 2,000,000 uS
        ourregs.x.dx = 0x8480;
        _int86(0x15, &ourregs, &ourregs); // issue interrupt 15


        // turn off speaker

        _outp(0x61, (_inp(0x61) & 0xFC));

}

