;
;                          MAX_XMIT
;
;
;   This routine works with a companion routine MAX_RECV to find
;   the maximum sustained serial transfer rate between two
;   systems, connected by a null modem cable.  Serial port 1 is
;   assumed unless command line indicates otherwise.  From the
;   command specify port number x from 1 to 4:   MAX_XMIT  x
;
;   (c) Copyright 1994, 1996  Frank van Gilluwe
;   All Rights Reserved.

include undocpc.inc

cseg    segment para public
        assume  cs:cseg, ds:cseg, ss:tsrstk

max_xmit        proc    far

msg1    db      CR, LF
        db      'MAX_XMIT - Finds Maximum speed on serial link'
        db      CR, LF, '$'

msg2    db      CR, LF, '  Transmitter Loaded and ready.'
        db      '  Waiting for receiver MAX_RECV connection.'
        db      CR, LF
        db      '  (Press Ctrl-Break to exit)', CR, LF, '$'

msg3    db      'Testing at baud rate: $'
msgok   db      '  Test OK', CR, LF, '$'
msgfail db      '  Test failed', CR, LF, '$'
msgerr  db      '  Serial port not present', CR, LF, '$'


divisor db      30h, '2,400  $'  ; Table of divisors and baud
div2nd  db      18h, '4,800  $'  ;  rates to test
        db      0Ch, '9,600  $'
        db      8,   '14,400 $'
        db      6,   '19,200 $'
        db      3,   '38,400 $'
        db      2,   '57,600 $'
        db      1,   '115,200$'
divisor_end     label  byte

buffer  db      512 dup (31h)      ; buffer of bytes to send

start:
        mov     bx, 0              ; assume port 1
        cmp     byte ptr ds:[80h], 0  ; command line options ?
        je      max_skp1           ; jump if none
        mov     al, ds:[82h]       ; get command line value
        sub     al, 31h            ; convert to digit 0-3
        cmp     al, 3
        ja      max_skp1           ; skip if out of range
        mov     bl, al             ; save port number
max_skp1:
        push    cs
        pop     ds
        mov     ax, 40h            ; BIOS data area segment
        mov     es, ax
        mov     byte ptr es:[71h], 0  ; force break flag off
        OUTMSG  msg1               ; output initial message

; get the serial base I/O port address and set up pointer

        shl     bx, 1              ; setup to get I/O port
        mov     dx, es:[bx]        ; base I/O port address
        cmp     dx, 0
        jne     valid_port
        jmp     no_serial_port     ; exit if zero

valid_port:
        mov     bp, dx             ; save base port address
        mov     di, offset divisor ; pointer to divisor table

; inform the remote system that we are ready

        add     dx, 4              ; modem control register
        mov     al, 3              ;  set Request To Send &
        out     dx, al             ;  Data Terminal Ready

        OUTMSG  msg2               ; output "waiting message"

; Now check if the remote system is ready.  Data Set Ready and
;   Clear To Send lines must both be high.

next_block:
        mov     dx, bp

; Set up the modem with 8-bit, 1 stop bit, odd parity, and
;   set the current test baud rate divisor

        add     dx, 3              ; line control register
        mov     al, 10001011b      ;  8-bit, 1 stop, odd parity
        out     dx, al             ;  and DLAB=1 to load baud
        IODELAY
        mov     dx, bp             ; divisor latch LSB
        mov     al, [di]           ;  get divisor LSB
        out     dx, al             ;  set divisor LSB
        IODELAY
        inc     dx
        mov     al, 0              ;  divisor MSB is 0
        out     dx, al             ;  set divisor MSB
        IODELAY
        add     dx, 2              ; line control register
        mov     al, 00001011b      ;  turn DLAB off
        out     dx, al
        IODELAY

        add     dx, 3              ; modem status register

max_loop1:
        in      al, dx
        IODELAY
        not     al
        test    al, 0A0h           ; is remote system ready ?
        jz      ready_to_send      ; jump if so (DSR & DCD = 1)
        test    byte ptr es:[71h], 80h  ; did break occur ?
        jz      max_loop1          ; jump if not
        jmp     max_xmit_end       ; exit, ctrl-break

ready_to_send:
        OUTMSG  msg3               ; output Testing ...
        mov     dx, di
        inc     dx                 ; point to baud rate text
        mov     ah, 9
        int     21h                ; output baud rate number

        mov     si, offset buffer  ; buffer of bytes to send
        mov     cx, 512            ; send 512 bytes
        call    send_block         ; transmit 512 bytes

; now wait until receiver indicates it has finished receiving the block

max_xmit_wait:
        test    byte ptr es:[71h], 80h  ; did break occur ?
        jnz     max_xmit_end       ; exit if so
        mov     dx, bp
        add     dx, 6              ; modem status register
        in      al, dx
        test    al, 80h            ; is remote system done, DCD=0
        jnz     max_xmit_wait      ; loop until done
        test    al, 20h            ; remote error ? DSR=0
        jz      max_xmit_fail      ; jump if so

; receiver happy, so output OK message and do next test

        OUTMSG  msgok
        add     di, offset div2nd - offset divisor
        cmp     di, offset divisor_end
        jb      next_blocka
        jmp     max_xmit_end
next_blocka:
        jmp     next_block

max_xmit_fail:
        OUTMSG  msgfail            ; baud rate failed

max_xmit_end:
        mov     dx, bp
        add     dx, 4              ; modem control register
        mov     al, 0              ;  set DTR off
        out     dx, al             ;  we're done!
        jmp     max_xmit_done

no_serial_port:
        OUTMSG  msgerr             ; output error message

max_xmit_done:
        mov     ah, 4Ch
        int     21h                ; exit to DOS
max_xmit endp

;
;    SEND_BLOCK
;       Sends a block of data as fast as possible over the
;       serial link.  Exit if Control-break detected or receive
;       Clear To Send no longer active.
;
;       Called with:    cx = number of bytes to transmit
;                       bp = base port I/O address
;                       ds:si = source of data
;
;       Returns:        bytes sent on serial link, unless
;                         control-break occurred
;
;       Regs used:      al, cx, dx, si

send_block proc near
        mov     dx, bp
        cld                        ; clear direction flag send_next:

send_next:
        add     dx, 5
wait_loop1:
        test    byte ptr es:[71h], 80h  ; did break occur ?
        jnz     send_exit          ; exit if so
        inc     dx                 ; modem status register
        in      al, dx
        IODELAY
        test    al, 80h            ; remote problem ?, DCD=0
        jz      send_exit          ; jump if so 
        dec     dx                 ; line status register
        in      al, dx
        IODELAY
        test    al, 20h            ; xmit holding reg ready? 
        jz      wait_loop1         ; jump if not

        mov     dx, bp             ; transmit holding register
        lodsb                      ; get byte into al from [si]
        out     dx, al             ; send byte
        IODELAY
        loop    send_next

send_exit:
        ret
send_block endp

cseg    ends

;===================================================== stack ====

tsrstk  segment para stack
        db      150 dup (0)
tsrstk  ends

        end     start

