
;
;                            PRNSWAP
;
;
;    Swap the parallel ports for printers 1 and 2. (Not a TSR)
;
;    (c) Copyright 1994, 1996  Frank van Gilluwe
;    All Rights Reserved.
;
;    v2.00 - Fixed bug, timeout 1 address was wrong

include undocpc.inc

cseg    segment para public
        assume  cs:cseg, ds:cseg

        org     100h               ; Assemble into a COM file.


prnswap proc    near

start:
        push    cs
        pop     ds

        mov     ax, 40h
        mov     es, ax             ; ES used for BIOS segment
        mov     dx, offset msg2    ; message if only 1 port

        mov     ax, es:[0Ah]       ; get parallel port 2 address
        cmp     ax, 0              ; is parallel port 2 active ?
        je      exit               ; jump if not

        xchg    ax, es:[8]         ; swap with port 1
        mov     es:[0Ah], ax       ; put old port 1 in port 2

        mov     al, es:[79h]       ; get printer timeout 2
        xchg    al, es:[78]        ; swap with timeout 1
        mov     es:[78h], al       ; put old timeout 1 in 2
        mov     dx, offset msg1    ; ports swapped message
exit:
        mov     ah, 9
        int     21h                ; display message
        mov     ah, 4Ch
        int     21h                ; exit

msg1    db      CR, LF, 'Printers 1 & 2 swapped.', CR, LF, '$'
msg2    db      CR, LF, 'Less than 2 active ports.', CR, LF, '$'

prnswap endp
cseg    ends
        end     start


