
; Include file for Undocumented PC programs and Undocumented
;  instruction macros.

;  EQUATES 

TAB     equ     9
LF      equ     0Ah
CR      equ     0Dh
LINE    equ     ''
OLDASM  equ     0         ; set to 1 if using an old
													; assembler that does not
													; support 486/Pentium instuctions

;  UNDOCUMENTED INSTRUCTION MACROS 
;
; See book for details on each instruction. A few instructions
;  are documented like CPUID, but most older assemblers do not
;  allow these instructions.  They are included here for those
;  users of older assemblers. (Set OLDASM=1)
;
; WARNING:  Many of these instructions are limited to a
;  specific processor and/or vendor.  Using a macro/instruction
;  on the wrong processor will likely hang or cause a bad
;  opcode fault. Be real sure the instruction is allowed
;  for the active processor!

POPCS   macro                      ; Pop word from stack into CS
        db      0Fh                ;   (8088/8086 only)
        endm


; LOADALL Note: not all assemblers allow conditions based
;  on the current cpu type.  Both MASM 6.0 and later, and
;  TASM 3.0 and later support the cpu type condition.  If
;  yours does not support @Cpu, you may need to build two
;  different named macros, like LOADALL2 and LOADALL3 for
;  each CPU case.

LOADALL macro                      ; Load all registers into CPU
    IF @Cpu AND 8                  ;  test for 386 or higher
        db      0Fh, 07h           ; loadall for 386+
    ELSE
        db      0Fh, 05h           ; loadall for 286
    ENDIF
        endm

; The following instructions are not supported on older assembers
; and may create warnings from the newest assemblers.

IF OLDASM
    WRMSR   macro                  ; Write Model Specific Reg
        db      0Fh, 30h           ;  ecx from edx:eax
        endm


    RDMSR   macro                  ; Read Model Specific Reg
        db      0Fh, 32h           ;  ecx to edx:eax
        endm


    RDPMC   macro                  ; Read Performace Register
        db      0Fh, 33h           ;  ecx to edx:eax
        endm


    CPUID   macro                  ; get the CPUID information
        db      0Fh, 0A2h          ;  into eax, ebx, ecx, edx
        endm
ENDIF


RDTSC   macro                      ; Read Time Stamp Counter
        db      0Fh, 31h           ;  TSC into edx:eax
        endm


RSM     macro                      ; Resume from system management
        db      0Fh, 0AAh          ;   mode
        endm


SETALC  macro                      ; Set AL with carry
        db      0D6h
        endm


ICEBP   macro                      ; In-Circuit-Emulator Breakpoint
        db      0F1h               ;   single byte interrupt 1
        endm


;  COMMON MACROS 

OUTMSG  macro   location           ; output text to screen
        mov     dx, offset location
        mov     ah, 9
        int     21h
        endm


MSGNO   macro   loc_for_no         ; insert "No " at loc_for_no
        mov     loc_for_no, "N"
        mov     loc_for_no+1, "o"
        mov     loc_for_no+2, " "
        endm


MSGYES  macro   loc_for_yes        ; insert "Yes " at loc_for_yes
        mov     loc_for_yes, "Y"
        mov     loc_for_yes+1, "e"
        mov     loc_for_yes+2, "s"
        endm

IODELAY macro
        jmp     short $+2          ; short delay between I/O
        jmp     short $+2          ;  to same device
        endm
