{Scans a path and builds a TinyMenu .ini file, asking user for descriptions.
Intended usage is to quickly populate a menu for a bootable floppy.

}

program buildini;

uses
  Dos;

var
  oldpath,inipath:pathstr;
  DirInfo:SearchRec;
  inifile:text;
  desc:string;

procedure catalog(fspec:string);
begin
  FindFirst(fspec, AnyFile, DirInfo);
  while DosError = 0 do begin
    Write('Enter description for ',DirInfo.Name,': ');
    readln(desc);
    writeln(inifile,desc,'^',DirInfo.Name);
    FindNext(DirInfo);
  end;
end;

begin
  if paramcount<2 then begin
    writeln('Usage:    buildini [scanpath] [inipath]');
    writeln('Example:  buildini a:\ a:\tinymenu.ini');
    halt(1);
  end;
  getdir(0,oldpath);
  chdir(paramstr(1));
  assign(inifile,paramstr(2)); rewrite(inifile);
  catalog('*.com');
  catalog('*.exe');
  close(inifile);
  chdir(oldpath);
end.




