*#######################################################################
*       PROGRAM BASIC...CP/M 68k Utility for Running BASIC-80
*                by chaining to Jim Cathey's COM.68K
*
*                         Dr. David C. Wilcox
*                         DCW Industries, Inc.
*                5354 Palm Drive, La Canada, CA  91011
*                            818/790-3844
*
*                          February 1, 1986
*#######################################################################
boot	equ	00		*warm boot
print	equ	09		*print string
chain	equ	47		*chain to program
lf	equ	10		*line feed
cr	equ	13		*carriage return
space	equ	32		*ascii space
extral	equ	12		*bytes in command leadin
bdos	equ	$0002		*BDOS entry point
*#######################################################################
*
*  Special registers:
*
*	a4 = address of 1st parsed FCB
*	a5 = address of DMA buffer
*	d5 = number of characters in input file name
*	d6 = total characters in chain command (d5+extral)
*
*#######################################################################
*
*  Locate FCB and DMA (for portability)
*
	link	a6,#0		*mark stack frame
	move.l	8(a6),a0	*get base page address
	lea	$5c(a0),a4	*get address of 1st parsed file name
	lea	$80(a0),a5	*get address of DMA buffer
	clr.l	d2		*make sure d2 is empty
*
*  Check for no file specified
*
	cmpi.b	#space,$1(a4)
	bne	start
	move.b	#extral-1,d6	*no name specified so just
	move.b	d6,d2		*chain the command name
	bra	command
*
*  Determine number of characters in file name and add
*  'extral' for chain command string count
*
start:	movea.l	a5,a1		*point to DMA
	move.b	(a1)+,d6	*put total characters in d6
	move.b	d6,d2		*transfer to d2 which will be counter
	addi	#extral,d6	*adjust for command leadin
*
*  Save file name at 'source'
*
	clr.l	d5		*make sure d5 is empty
	movea.l	#source,a0	*get the source file name
sfile:	move.b	(a1)+,(a0)+
	addq	#1,d5
	subq	#1,d2		*make sure we're not out of characters
	blt	error		*before we find the null
	cmpi.b	#0,(a1)
	bne	sfile
*
*  Copy command string count and command leadin to DMA
*
command:
	movea.l	a5,a0		*point to the DMA
	move.b	d6,(a0)+	*put character count in first byte
	move.b	#extral,d2	*prepare to move 'extral' bytes
	movea.l	#leadin,a1	*point to command leadin
	jsr	movmem		*and copy to DMA
	cmpi.b	#extral-1,d6	*see if we're all done
	beq	null		*skip to null if we are
*
*  Copy source file name to DMA
*
filspec:
	move.b	d5,d2		*retrieve number of chars in file name
	movea.l	#source,a1	*point to source file name
	jsr	movmem		*and copy to DMA
*
*  Copy concluding null to DMA
*
null:
	move.b	#0,(a0)		*conclude with a null
*
*  Invoke the chain command
*
	move.w	#chain,d0	*now let COM do the rest
	trap	#bdos
*#######################################################################
*			   Subroutines
*#######################################################################
*
*  Quit to CP/M
*
quit:	move.w	#boot,d0
	trap	#bdos
*
*  Report file error
*
error:	move.l	#errmsg,d1
	move.w	#print,d0
	trap	#bdos
	bra	quit
*
*  Move d2 bytes from a1 to a0
*
movmem:	move.b	(a1)+,(a0)+
	subq	#1,d2
	bne	movmem
	rts
*#######################################################################
*                     Messages and storage area
*#######################################################################
source:	ds.b	32
errmsg:	dc.b	'File name error...BASIC aborted',cr,lf,'$'
leadin:	dc.b	'COM A:BASIC '
*#######################################################################
	end
