*#######################################################################
*              Program LQ...Epson LQ-1500 Setup Utility
*        ==================================================
*                 Configured for an EPSON LQ-1500:
*           This program chains to either DFONT or LFONT
*           to implement a user defined font in draft or
*               letter quality mode, respectively.
*        ==================================================
*
*                       Dr. David C. Wilcox
*                       DCW Industries, Inc.
*               5354 Palm Drive, La Canada, CA  91011
*                          818/790-3844
*
*                         March 26, 1986
*#######################################################################
boot	equ	00		*warm boot
conin	equ	01		*console input
list	equ	05		*output to LST: device
pstring	equ	09		*display string on console
chain	equ	47		*chain to program
bell	equ	07		*ascii bel
tab	equ	09		*horizontal tab
lf	equ	10		*line feed
cr	equ	13		*carriage return
si	equ	15		*ascii shift in
dc2	equ	18		*ascii dc2
esc	equ	27		*ascii escape
space	equ	32		*space
upmask	equ	$5f		*upper case mask
bdos	equ	$0002		*BDOS entry point
*#######################################################################
* Special registers:
*
*	a5 = address of dma buffer
*	a6 = address of 1st parsed file name
*	d5 = font flag
*	d6 = command string character count
*	d7 = cancel flag
*#######################################################################
*
* Locate FCB and DMA (for portability)
*
	link	a6,#0		*mark stack frame
	move.l	8(a6),a0	*get base page address
	lea	$80(a0),a5	*get address of DMA buffer
	lea	$5c(a0),a6	*get address of 1st parsed fcb
	clr.l	d0		*make sure d0 is clear
	clr.l	d1		*make sure d1 is clear
	clr.l	d5		*make sure d5 is clear
	clr.l	d7		*make sure d7 is clear
*
* See if any options have been specified
*
	movea.l	a5,a4		*make a4 the working buffer
	move.b	(a4)+,d6	*parse the dma...d6 is character count
	cmpi.b	#0,d6
	beq	options		*no options...display options available
strip:	move.b	(a4)+,d0	*strip all leading spaces
	subq	#1,d6
	blt	options
	cmpi.b	#space,d0
	beq	strip
	cmpi.b	#'-',d0		*is it a cancel?
	bne	opta		*if not...check option specified
	move.b	#1,d7		*otherwise set d7 as on/off flag
	move.b	(a4)+,d0	*get next character
	subq	#1,d6
	blt	options
*
* Options specified...process them
*
opta:	cmpi.b	#'A',d0		*is it alternate pitch?
	bne	optb
	cmpi.b	#1,d7		*yes...get on/off flag
	beq	optaoff
	move.l	#aon,a1		*point to option A on
	bra	send
optaoff:move.l	#aoff,a1	*point to option A off
	bra	send
optb:	cmpi.b	#'B',d0		*is it boldface?
	bne	optc
	cmpi.b	#1,d7		*yes...get on/off flag
	beq	optboff
	move.l	#bon,a1		*point to option B on
	bra	send
optboff:move.l	#boff,a1	*point to option B off
	bra	send
optc:	cmpi.b	#'C',d0		*is it 80-column print?
	bne	optd
	cmpi.b	#1,d7		*yes...get on/off flag
	beq	optcoff
	move.l	#con,a1		*point to option C on
	bra	send
optcoff:move.l	#coff,a1	*point to option C off
	bra	send
optd:	cmpi.b	#'D',d0		*is it disable paper-out indicator?
	bne	opte
	cmpi.b	#1,d7		*yes...get on/off flag
	beq	optdoff
	move.l	#don,a1		*point to option D on
	bra	send
optdoff:move.l	#doff,a1	*point to option D off
	bra	send
opte:	cmpi.b	#'E',d0		*is it expanded width characters?
	bne	optf
	cmpi.b	#1,d7		*yes...get on/off flag
	beq	opteoff
	move.l	#eon,a1		*point to option E on
	bra	send
opteoff:move.l	#eoff,a1	*point to option E off
	bra	send
optf:	cmpi.b	#'F',d0		*is it select user defined font?
	bne	opti
	move.b	#1,d5		*if so, save it for last
	move.b	(a4)+,d0	*get next option
	subq	#1,d6
	blt	quit		*if no more options, load font
	bra	opta		*otherwise exhaust options first
opti:	cmpi.b	#'I',d0		*is it italic print?
	bne	optl
	cmpi.b	#1,d7		*yes...get on/off flag
	beq	optioff
	move.l	#ion,a1		*point to option I on
	bra	send
optioff:move.l	#ioff,a1	*point to option I off
	bra	send
optl:	cmpi.b	#'L',d0		*is it letter quality mode?
	bne	optp
	cmpi.b	#1,d7		*yes...get on/off flag
	beq	optloff
	move.l	#lon,a1		*point to option L on
	bra	send
optloff:move.l	#loff,a1	*point to option L off
	bra	send
optp:	cmpi.b	#'P',d0		*is it proportional characters?
	bne	optr
	cmpi.b	#1,d7		*yes...get on/off flag
	beq	optpoff
	move.l	#pon,a1		*point to option P on
	bra	send
optpoff:move.l	#poff,a1	*point to option P off
	bra	send
optr:	cmpi.b	#'R',d0		*is it reset all but font?
	bne	opts
	move.l	#reset,a1	*point to reset option
	bra	send
opts:	cmpi.b	#'S',d0		*is it small (condensed) characters?
	bne	optu
	cmpi.b	#1,d7		*yes...get on/off flag
	beq	optsoff
	move.l	#son,a1		*point to option S on
	bra	send
optsoff:move.l	#soff,a1	*point to option S off
	bra	send
optu:	cmpi.b	#'U',d0		*is it underline mode?
	bne	optv
	cmpi.b	#1,d7		*yes...get on/off flag
	beq	optuoff
	move.l	#uon,a1		*point to option U on
	bra	send
optuoff:move.l	#uoff,a1	*point to option U off
	bra	send
optv:	cmpi.b	#'V',d0		*is it 1/8" vertical spacing?
	bne	optz
	cmpi.b	#1,d7		*yes...get on/off flag
	beq	optvoff
	move.l	#von,a1		*point to option V on
	bra	send
optvoff:move.l	#voff,a1	*point to option V off
	bra	send
optz:	cmpi.b	#'Z',d0		*is it reset to original state?
	bne	error
	move.l	#zap,a1		*point to zap option
*
* Send appropriate strings to printer and console
*
send:
	jsr	lpsend
	move.w	#pstring,d0
	trap	#bdos		*display message on console
	move.b	(a4)+,d0	*get next character
	subq	#1,d6
	blt	quit		*all done if no more characters
	bra	opta		*otherwise, loop for additional options
*
* Send string terminated by a '$' to LST:
*
lpsend:
	move.b	(a1)+,d1
	cmpi.b	#'$',d1
	bne	sendit
	move.l	a1,d1
	rts
sendit:	move.w	#list,d0
	trap	#bdos
	bra	lpsend
*
* Display error message, usage menu, and return to CP/M
*
error:
	move.l	#errmsg,d1
	move.w	#pstring,d0
	trap	#bdos
	move.l	#menu,d1
	move.w	#pstring,d0
	trap	#bdos
	bra	quit1
*
* Display user font menu and chain to appropriate font utility
*
font:
	move.l	#fontmsg,d1	*display font menu
	move.w	#pstring,d0	*and prompt for font desired
	trap	#bdos
	move.w	#conin,d0	*get response from keyboard
	trap	#bdos
	move.b	d0,d4		*save response in d4
	move.l	#crlf,d1	*send a cr, lf to console
	move.w	#pstring,d0
	trap	#bdos
	cmpi.b	#3,d4		*is it a ^C?
	beq	quit1		*yes...so return to CP/M
	andi.b	#upmask,d4	*make it upper case
	cmpi.b	#'E',d4		*is it an exit request?
	beq	quit1		*yes...so return to CP/M
	cmpi.b	#'L',d4		*is it letter quality font?
	beq	lqmode		*yes...prepare to run lfont
	cmpi.b	#'D',d4		*is it draft mode font?
	beq	dmode		*yes...prepare to run dfont
	move.l	#errmsg,d1	*none of the above
	move.w	#pstring,d0	*so...print error message
	trap	#bdos		*repeat the menu
	bra	font		*and prompt for another response
lqmode:	movea.l	#slctlq,a1	*point to lfont command string
	bra	go
dmode:	movea.l	#slctd,a1	*point to dfont command string
go:	move.l	#9,d2
	movea.l	a5,a0		*point to dma
	jsr	movmem		*copy command string to dma
	move.w	#chain,d0	*and chain to the selected
	trap	#bdos		*font program
*
* Move d2 bytes from a1 to a0
*
movmem:
	move.b	(a1)+,(a0)+
	subq	#1,d2
	bne	movmem
	rts
*
* Display options available
*
options:
	move.l	#menu,d1
	move.w	#pstring,d0
	trap	#bdos
*
* return to cp/m via the bdos
*
quit:
	cmpi.b	#1,d5		*check the font flag
	beq	font		*set => process request
quit1:	move.w	#boot,d0	*otherwise, return to CP/M
	trap	#bdos
*#######################################################################
crlf:	dc.b	cr,lf,'$'
slctlq:	dc.b	7,'A:LFONT',0
slctd:	dc.b	7,'A:DFONT',0
errmsg:	dc.b	cr,lf
	dc.b	' Invalid option specified ',cr,lf,lf,'$'
menu:	dc.b	'Correct usage:     LQ {-} {option list}',cr,lf,lf
	dc.b	'Including "-" turns the option list off',cr,lf,lf
	dc.b	'Options available for Epson LQ-1500:',cr,lf
	dc.b	'----------------------------------'
	dc.b	'---------------------------------------',cr,lf
	dc.b	'A...Alternate pitch (elite)       '
	dc.b	'L...Letter quality mode',cr,lf
	dc.b	'B...Boldface print mode           '
	dc.b	'P...Proportional characters',cr,lf
	dc.b	'C...80-Column print mode          '
	dc.b	'R...Reset all options except user font',cr,lf
	dc.b	'D...Disable paper-out indicator   '
	dc.b	'S...Small width characters',cr,lf
	dc.b	'E...Expanded width characters     '
	dc.b	'U...Underline mode',cr,lf
	dc.b	'F...Font load/user definition     '
	dc.b	'V...1/8" Vertical spacing',cr,lf
	dc.b	'I...Italic print mode             '
	dc.b	'Z...Zap all options including user font',cr,lf
	dc.b	'----------------------------------'
	dc.b	'---------------------------------------'
	dc.b	cr,lf,lf,'$'
fontmsg:dc.b	'User defined fonts/options available:',cr,lf,lf
	dc.b	tab
	dc.b	'E...Exit without loading user defined font',cr,lf
	dc.b	tab
	dc.b	'D...Draft mode scientific font',cr,lf
	dc.b	tab
	dc.b	'L...Letter quality scientific font',cr,lf,lf
	dc.b	'Specify option desired...$'
aon:	dc.b	esc,'M',bell,'$'
	dc.b	'Pitch selected is now ELITE',cr,lf,'$'
aoff:	dc.b	esc,'P',bell,'$'
	dc.b	'Pitch selected is now PICA',cr,lf,'$'
bon:	dc.b	esc,'E',bell,'$'
	dc.b	'Boldface print is now ON',cr,lf,'$'
boff:	dc.b	esc,'F',bell,'$'
	dc.b	'Boldface print is now OFF',cr,lf,'$'
con:	dc.b	esc,'Q',80,bell,'$'
	dc.b	'Page width is now 80 columns',cr,lf,'$'
coff:	dc.b	esc,'Q',132,bell,'$'
	dc.b	'Page width is now 132 columns',cr,lf,'$'
don:	dc.b	esc,'8',bell,'$'
	dc.b	'Paper-out indicator is now DISABLED',cr,lf,'$'
doff:	dc.b	esc,'9',bell,'$'
	dc.b	'Paper-out indicator is now ENABLED',cr,lf,'$'
eon:	dc.b	esc,'W',1,bell,'$'
	dc.b	'Expanded width character mode is now ON',cr,lf,'$'
eoff:	dc.b	esc,'W',0,bell,'$'
	dc.b	'Expanded width character mode is now OFF',cr,lf,'$'
ion:	dc.b	esc,'4',bell,'$'
	dc.b	'Italics mode is now ON',cr,lf,'$'
ioff:	dc.b	esc,'5',bell,'$'
	dc.b	'Italics mode is now OFF',cr,lf,'$'
lon:	dc.b	esc,'x',1,bell,'$'
	dc.b	'Print mode selected is now LETTER QUALITY',cr,lf,'$'
loff:	dc.b	esc,'x',0,bell,'$'
	dc.b	'Print mode selected is now DRAFT QUALITY',cr,lf,'$'
pon:	dc.b	esc,'p',1,bell,'$'
	dc.b	'Proportional character mode is now ON',cr,lf,'$'
poff:	dc.b	esc,'p',0,bell,'$'
	dc.b	'Proportional character mode is now OFF',cr,lf,'$'
reset:	dc.b	esc,'P',esc,'F',esc,'Q',132,esc,'9',esc,'W',0,esc,'5'
	dc.b	esc,'x',0,esc,'p',0,dc2,esc,'-',0,esc,'2',bell,'$'
	dc.b	'Printer is now RESET...User font unaffected',cr,lf,'$'
son:	dc.b	si,bell,'$'
	dc.b	'Small width character mode is now ON',cr,lf,'$'
soff:	dc.b	dc2,bell,'$'
	dc.b	'Small width character mode is now OFF',cr,lf,'$'
uon:	dc.b	esc,'-',1,bell,'$'
	dc.b	'Underline mode is now ON',cr,lf,'$'
uoff:	dc.b	esc,'-',0,bell,'$'
	dc.b	'Underline mode is now OFF',cr,lf,'$'
von:	dc.b	esc,'0',bell,'$'
	dc.b	'Vertical line spacing is now 1/8"',cr,lf,'$'
voff:	dc.b	esc,'2',bell,'$'
	dc.b	'Vertical line spacing is now 1/6"',cr,lf,'$'
zap:	dc.b	esc,'@',bell,'$'
	dc.b	'Printer is now RESET...User font erased',cr,lf,'$'
*#######################################################################
	end
