*#######################################################################
*		   PROGRAM RENAME...Rename Utility
*
*			Dr. David C. Wilcox
*			DCW Industries, Inc.
*		 5354 Palm Dr., La Canada, CA  91011
*			   818/790-3844
*
*			 January 26, 1986
*#######################################################################
*  Special registers:
*
*	a6 = address of first parsed FCB
*	d3 = drive designation
*	d7 = number of file matches counter
*#######################################################################
boot	equ	00		*warm boot
outchar	equ	02		*print character
print	equ	09		*print string
sfirst	equ	17		*search for first
snext	equ	18		*Search for Next
setdma	equ	26		*Set DMA Address
rename	equ	23		*rename file
current	equ	25		*return current disk
lf	equ	10		*line feed
cr	equ	13		*carriage return
space	equ	32		*ascii space
bdos	equ	$0002		*BDOS entry point
*#######################################################################
*
*  Locate FCB (for portability)
*
	link	a6,#0		*mark stack frame
	move.l	8(a6),a0	*get base page address
	lea	$5c(a0),a6	*get address of FCB and save it in a6
*
*  Clear data registers and determine drive designation
*
	jsr	clear
	jsr	getdrv
*
*  Check for no file specified
*
	cmpi.b	#space,1(a6)	*is 1st char in filespec a space?
	bne	start
	move.l	#usage,d1	*if no parameters...
	jsr	pstring		*display instructions
	jsr	quit		*and exit to CP/M
*
*  Copy source file to FCB
*
start:	movea.l	a6,a1
	movea.l	#fcb,a0
	move.w	#12,d2
	jsr	movmem
*
*  Copy destination file to FCB
*
	movea.l	a6,a1		*make sure the drive specified
	movea.l	#named-1,a0	*matches...will need it to
	move.b	(a1)+,(a0)+	*prevent renaming to existing name
	movea.l	a6,a1		*point to 1st parsed FCB
	suba.w	#35,a1		*adjust to point to 2nd parsed FCB
	move.w	#11,d2
	jsr	movmem
*
*  Check for wildcards
*
	jsr	examin		*check for wildcards...
	cmpi.b	#1,d7		*return d7=1 for no, d7=0 for yes
	bne	begin		*wildcards found...must search directory
	movea.l	a6,a0		*put original fcb in a0 since no search
	jmp	prelim		*no wildcards...skip directory search
*
*  Begin search for file name matches
*
begin:	move.l	#mydma,d1	*===================
	move.w	#setdma,d0	*Set the DMA Address
	trap	#bdos		*===================
	move.l	a6,d1		*Load the FCB
	move.w	#sfirst,d0	*and search for the first match
	trap	#bdos
	cmpi.b	#$ff,d0		*Is there no match?
	bne	search
	move.l	#nofile,d1	*No match if it's zero so QUIT
	jsr	pstring
	bra	quit
*
*  Search for file name matches
*
search:	mulu	#32,d0		*Adjust for offset in DMA of matching entry
	move.l	#mydma,a1	*Point to mydma
	adda.w	d0,a1		*and add the offset
	movea.l	#bufadr,a4	*Point to buffer
	move.l	(a4),a0
	move.w	#32,d2		*Initialize the counter
	jsr	movmem		*Copy a1 to a0
	move.l	a0,bufadr	*Save buffer address
	addq	#1,d7		*Increment file match counter
	move.l	a6,d1		*=========================
	move.w	#snext,d0	*Search for next occurance
	trap	#bdos		*=========================
	cmpi.b	#$ff,d0		*Is there no match?
	bne	search		*Keep searching until all are found
	movea.l	#buffer,a0	*Point to the original buffer
	move.l	a0,bufadr	*Save buffer address
*
*  Rename Files
*
prep:	jsr	setup		*fill in wildcard bytes
prelim:	movea.l	#named-1,a1	*check for existing file
	movea.l	#xfcb,a0	*with same name as the
	move.w	#12,d2		*proposed destination name
	jsr	movmem
	move.l	#xfcb,d1
	move.w	#sfirst,d0
	trap	#bdos
	cmpi.b	#$ff,d0		*does it exist?
	beq	name
	move.l	#exists,d1	*say so if it does...
	jsr	pstring
	jsr	quit		*and exit to CP/M
*
name:	move.l	#fcb,d1		*do the rename
	move.w	#rename,d0
	trap	#bdos
	cmpi.b	#$ff,d0		*rename successful?
	bne	okay
	move.l	#nofile,d1	*file not found...say so
	jsr	pstring
	jsr	quit		*and return to CP/M
*
okay:	jsr	drivepr		*display drive identifier
	movea.l	#names,a0	*echo the source name
	jsr	filnam
	jsr	filtyp
	move.l	#arrow,d1	*then display an arrow
	jsr	pstring
	jsr	drivepr		*the drive identifier
	movea.l	#named,a0	*and the destination name
	jsr	filnam
	jsr	filtyp
	move.l	#crlf,d1	*conclude with a cr/lf
	jsr	pstring
*
*  Prepare for next file
*
nexfile:
	subq	#1,d7		*Decrement the file match counter
	beq	quit		*If last file...QUIT
	movea.l	#bufadr,a4	*Point to buffer
	move.l	(a4),a0
	adda.l	#32,a0		*Add 32 bytes to point to next match
	move.l	a0,bufadr	*Save buffer address
	jmp	prep		*Loop back for the next file
*#######################################################################
*                           Subroutines
*#######################################################################
*
*  Clear all data registers
*
clear:	
	clr.l	d0
	clr.l	d1
	clr.l	d2
	clr.l	d3
	clr.l	d4
	clr.l	d5
	clr.l	d6
	clr.l	d7
	rts
*
*  Send a character to the console
*
conout:
	move.w	#outchar,d0
	trap	#bdos
	rts
*
*  Display drive identifier
*
drivepr:
	move.b	d3,d1
	jsr	conout
	move.b	#':',d1
	jsr	conout
	rts
*
*  Examine input file names for wildcards
*
examin:	
	move.w	#1,d7		*d7 (file count) will be 1
	movea.l	#named,a3	*if no wildcards
	movea.l	#names,a4
	movea.l	#flags,a5
	move.w	#11,d2
ckwild:	cmpi.b	#'?',(a3)+	*check destination byte for wildcard
	bne	skip
	cmpi.b	#'?',(a4)	*make sure source has matching wildcard
	beq	setflg
	move.l	#illegal,d1	*wildcard mismatch...say so
	jsr	pstring		*and return to CP/M
	jmp	quit
setflg:	move.b	#1,(a5)		*flag the byte
	clr.w	d7		*wildcards => reset d7 to indicate
skip:	adda	#1,a5		*we must search the directory
	adda	#1,a4
	subq	#1,d2
	bne	ckwild
	rts
*
*  Display file name and filetype on the console
*
filnam:	
	move.w	#8,d2		*display file name
more:	move.b	(a0)+,d1
	move.w	#outchar,d0
	trap	#bdos
	subq	#1,d2
	bne	more
	rts
filtyp:	move.b	#'.',d1		*display filetype
	move.w	#outchar,d0
	trap	#bdos
	move.w	#3,d2
	jsr	more		*use code above to avoid redundancy
	rts
*
*  Determine drive number and make it ascii
*
getdrv:
	move.b	(a6),d1		*Get drive number from FCB
	cmpi.b	#0,d1		*Is it the default drive?
	bne	ascii
	jsr	logged		*If so, get physical drive number
ascii:	addi.b	#64,d1		*Make it ascii
	move.b	d1,d3		*and save it in d3
	rts
*
*  Determine which is the logged drive
*
logged:
	move.w	#current,d0	*Get current drive number
	trap	#bdos
	addq.b	#1,d0		*Increment for consistency with getdrv
	move.w	d0,d1		*and save it in d1 for getdrv
	rts
*
*  Copy d2 bytes from a1 to a0
*
movmem:	
	move.b	(a1)+,(a0)+
	subq	#1,d2
	bne	movmem
	rts
*
*  Send a String to the Console
*
pstring:
	move.w	#print,d0
	trap	#bdos
	rts
*
*  Quit to CP/M
*
quit:	
	move.w	#boot,d0
	trap	#bdos
*
*  Setup FCB for rename operation
*
setup:	
	movea.l	#named,a3
	movea.l	#names,a4
	movea.l	#flags,a5
	adda	#1,a0
	move.w	#11,d2
fill:	cmpi.b	#0,(a5)+	*check for wildcard byte
	beq	notset
	move.b	(a0)+,d3	*this is a wildcard byte
	move.b	d3,(a4)+	*fill the source byte
	move.b	d3,(a3)+	*fill the destination byte
	jmp	there
notset:	move.b	(a0)+,(a4)+	*fill the source byte
	adda	#1,a3		*skip the destination byte
there:	subq	#1,d2
	bne	fill
	rts
*#######################################################################
*			     Console Messages
*#######################################################################
	even
fcb:	dc.b	0			*drive specification
names:	dc.b	0,0,0,0,0,0,0,0		*source file name
	dc.b	0,0,0			*source filetype
	dc.b	0,0,0,0			*filler bytes
	dc.b	0			*drive specification
named:	dc.b	0,0,0,0,0,0,0,0		*destination file name
	dc.b	0,0,0			*destination filetype
	dc.b	0,0,0,0,0		*filler bytes
	even
xfcb:   dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.b	0,0,0,0
exists:	dc.b	lf,cr
	dc.b	'Destination file already exists...RENAME aborted',lf,cr,'$'
	even
illegal:dc.b	lf,cr
	dc.b	'Illegal wildcard specification...RENAME aborted',lf,cr,'$'
	even
arrow:	dc.b	'  -->  $'
crlf:	dc.b	lf,cr,'$'
	even
nofile:	dc.b	lf,cr
	dc.b	'No matching files on this disk',lf,cr,'$'
usage:	dc.b	lf,cr,'Correct usage:    RENAME <d:>oldname newname'
	dc.b	lf,cr
	dc.b	lf,cr,'       ** Wildcards are supported **'
	dc.b	lf,cr,'$'
flags:	dc.b	0,0,0,0,0,0,0,0,0,0,0
*#######################################################################
*                            Storage area
*#######################################################################
	even
bufadr  dc.l	buffer
mydma   dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.b	0,0,0,0,0,0,0,0
buffer  dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
*#######################################################################
	end
