BREAK <Device table and SRH definition>

; The device table list has the form:
SYSDEV  STRUC
SDEVNEXT        DD      ?       ;Pointer to next device header
SDEVATT         DW      ?       ;Attributes of the device
SDEVSTRAT       DW      ?       ;Strategy entry point
SDEVINT         DW      ?       ;Interrupt entry point
SDEVNAME        DB      8 DUP (?) ;Name of device (only first byte used for block)
SYSDEV  ENDS

;Attribute bit masks
DEVTYP  EQU     8000H           ;Bit 15 - 1  if Char, 0 if block
DEVIOCTL EQU    4000H           ;Bit 14 - CONTROL mode bit
ISFATBYDEV EQU  2000H           ;Bit 13 - Device uses FAT ID bytes, comp media.
ISCIN   EQU     0001H           ;Bit 0 - This device is the console input.
ISCOUT  EQU     0002H           ;Bit 1 - This device is the console output.
ISNULL  EQU     0004H           ;Bit 2 - This device is the null device.
ISCLOCK EQU     0008H           ;Bit 3 - This device is the clock device.
ISSPEC  EQU     0010H           ;Bit 4 - This device is special

;Static Reguest Header
SRHEAD  STRUC
REQLEN  DB      ?               ;Length in bytes of request block
REQUNIT DB      ?               ;Device unit number
REQFUNC DB      ?               ;Type of request
REQSTAT DW      ?               ;Status Word
        DB      8 DUP(?)        ;Reserved for queue links
SRHEAD  ENDS

;Status word masks
STERR   EQU     8000H           ;Bit 15 - Error
STBUI   EQU     0200H           ;Bit 9 - Buisy
STDON   EQU     0100H           ;Bit 8 - Done
STECODE EQU     00FFH           ;Error code
WRECODE EQU     0

;Function codes
DEVINIT EQU     0               ;Initialization
DINITHL EQU     26              ;Size of init header
DEVMDCH EQU     1               ;Media check
DMEDHL  EQU     15              ;Size of media check header
DEVBPB  EQU     2               ;Get BPB
DEVRDIOCTL EQU  3               ;IOCTL read
DBPBHL  EQU     22              ;Size of Get BPB header
DEVRD   EQU     4               ;Read
DRDWRHL EQU     22              ;Size of RD/WR header
DEVRDND EQU     5               ;Non destructive read no wait (character devs)
DRDNDHL EQU     14              ;Size of non destructive read header
DEVIST  EQU     6               ;Input status
DSTATHL EQU     13              ;Size of status header
DEVIFL  EQU     7               ;Input flush
DFLSHL  EQU     15              ;Size of flush header
DEVWRT  EQU     8               ;Write
DEVWRTV EQU     9               ;Write with verify
DEVOST  EQU     10              ;Output status
DEVOFL  EQU     11              ;Output flush
DEVWRIOCTL EQU  12              ;IOCTL write

SUBTTL
