	PAGE	58,132
	TITLE	'RE_INIT'
;	MAR/23/84	LINK "CONOUT"
;****************************************
;*	EQUATE TABLE			*
;****************************************
CRT_FNC_TTY	EQU	14		; CRT	WRITE TELETYPE
CRT_ROM		EQU	19H
;
CR		EQU	0DH
LF		EQU	0AH
		PAGE
CODE	SEGMENT	WORD PUBLIC 'CODES'
;************************************************
;*						*
;*	EXTERNAL SYMBOL AND LABEL		*
;*						*
;************************************************
	EXTRN	CONOUT:NEAR		; OUTPUT ONE CHARACTER TO CRT

	ASSUME	CS:CODE,DS:CODE,ES:CODE
;************************************************
;*						*
;*	PUBLIC SYMBOL AND LABEL			*
;*						*
;************************************************

	PUBLIC	RE_INIT			; initialize after MD-DOS initalized
	PUBLIC	INT_TRAP		; entry routine of invalid interrupt
	PUBLIC	MSGL			; display character strings.
		PAGE
;********************************************************
;*							*
;*	SUBROUTINES					*
;*							*
;********************************************************
;************************************************
;*						*
;*	MODULE NAME	MSGL			*
;*						*
;*	FUNCTION	MESSAGE DISPLAY TO CRT	*
;*						*
;*	INPUT		BX = MESSAGE ADDRESS	*
;*			(END CODE=00H)		*
;*						*
;*	OUTPUT		NONE			*
;*						*
;************************************************
MSGL		PROC	NEAR
	MOV	AL,[BX]
	TEST	AL,AL			;END OF DATA?
	JZ	RETURN			;JUMP IF SO
	PUSH	BX
	CALL	CONOUT			; DISPLAY ONE CHARACTER
	POP	BX
	INC	BX
	JMP	MSGL
RETURN:
	RET
MSGL		ENDP
		PAGE
;************************************************
;*						*
;*	MODULE NAME	INT_TRAP		*
;*						*
;*	FUNCTION	DISPLAY ERROR MESSAGE	*
;*			CPU HALT		*
;*	INPUT/OUTPUT	NONE			*
;*						*
;************************************************
INT_TRAP	PROC	NEAR
	CLI
	MOV	AX,CS
	MOV	DS,AX
	MOV	BX,OFFSET INT_TRP
	CALL	MSGL
	STI
INT_HLT:
	JMP	SHORT	INT_HLT

INT_TRP	DB	CR,LF,'Interrup Trap Halt',CR,LF,0
INT_TRAP	ENDP
	PAGE
RE_INIT_PROC	PROC	FAR
;************************************************
;*						*
;*	MODULE NAME	RE_INIT			*
;*						*
;*	FUNCTION	RE-INITIARIZE ANY	*
;*			DRIVER			*
;*						*
;*	INPUT/OUTPUT	NONE			*
;*						*
;*	CALLING SEQUENCE	CALLED FROM	*
;*				"SYSINIT"	*
;*						*
;************************************************
RE_INIT		LABEL	FAR
	RET
RE_INIT_PROC	ENDP
;
CODE	ENDS

;************************************************
;*	PROGRAM END				*
;************************************************
	END

