	TITLE	KBROM
	PAGE	58,132
;-------------------------------------------------------------------
;  HISTORY :
;	11-21-1983	(1) CTL+FNC+BREAK PROC. ADDED
;			(2) SOUND BEEP WHEN FIFO IS FULL. -- ADDED.
;			(3) RELATIVE JMP TO KI25 OVER, INTER-
;			    CONNECTION IS MADE.
;	12-06-1983	(1) KB CHARACTER CODE CHANGE 
;			    (SCAN CODE = 06H,1DH)
;			(2) FIFO CLEAR WHEN CTL+C,CTL+S,BREAK STOP KEY
;			    IS PUSHED.
;	04-23-1984	(1) REWRITE RESET_VECTOR (FOR WARM BOOT)
;	04-26-1984	(1) CTL+SHIFT+PRINT PROC. (GRAPHICS DUMP)
;			(2) ADJUST ERROR BEEP INTERVAL
;			(3) SET AL = 0, WHEN SHIFT+PRINT (TEXT DUMP)
;	05-07-1984	(1) KEY CLICK SOUND SUPPORT
;			(2) SAVE KEY CODE TO KB_CODE FOR CTRL+F PROCESS
;--------------------------------------------------------------------
	public	keyboard_io
	public	kb_int
;------------------------
; ROM BIOS DATA AREA
;------------------------
INCLUDE		B:SYSCOM.LIB
EOI       EQU       20H
KB_STA    EQU	    43H
KB_DATA   EQU	    41H
KB_CMD    EQU	    43H
INTTM_02  EQU       00H
;-----------------------------
; KEYBOARD DATA AREA
;-----------------------------
;KB_FLAG       DB
;-------  SHIFT FLAG EQUATES WITHIN KB_FLAG
INS_STATE      EQU  80H       ; INSERT STATE IS ACTIVE
CAPS_STATE     EQU  40H       ; CAPS LOCK STATE HAS BEEN TOGGLED
GR1_STATE      EQU  20H       ; GRAPHIC 1 STATE HAS BEEN TOGGLED
GR2_STATE      EQU  10H       ; GRAPHIC 2 STATE HAS BEEN TOGGLED
ALT_SHIFT      EQU  08H       ; ALTERNATE SHIFT KEY DEPRESSED
CTL_SHIFT      EQU  04H       ; CONTROL SHIFT KEY DEPRESSED
SHIFT_SHIFT    EQU  02H       ; SHIFT KEY DEPRESSED
FNC_SHIFT      EQU  01H       ; FUNCTION SHIFT KEY DEPRESSED
;
;
INS_SHIFT      EQU  80H       ; INSERT KEY DEPRESSED
CAPS_SHIFT     EQU  40H       ; CAPS LOCK KEY DEPRESSED
GR1_SHIFT      EQU  20H       ; GRAPHIC 1 LOCK KEY DEPRESSED
GR2_SHIFT      EQU  10H       ; GRAPHIC 2 LOCK KEY DEPRESSED
;
;ALT_INPUT     DB             ; STORE FOR ALTERNATE KEYPAD ENTRY
;BUFFER_HEAD   DW             ; POINTER TO HEAD OF KEYBOARD BUFFER
;BUFFER_TAIL   DW             ; POINTER TO TAIL OF KEYBOARD BUFFER
;KB_BUFFER     DW 16DUP(?)    ; ROOM FOR 15 ENTRIES
;KB_BUFFER_END  LABEL WORD
;KB_RETRY
;-------  HEAD = TAIL INDICATES THAT THE BUFFER IS EMPTY
GR1_KEY        EQU  72H       ; SCAN CODE FOR GRAPH 1 KEY
GR2_KEY        EQU  73H       ; SCAN CODE FOR GRAPH 2 KEY
CTL_KEY        EQU  74H       ; SCAN CODE FOR CONTROL SHIFT KEY
CAPS_KEY       EQU  71H       ; SCAN CODE FOR CAPS SHIFT KEY
SHIFT_KEY      EQU  70H       ; SCAN CODE FOR SHIFT KEY
ALT_KEY        EQU  6EH       ; SCAN CODE FOR ALTERNATE SHIFT KEY
FNC_KEY        EQU  75H       ; SCAN CODE FOR FUNCTION SHIFT KEY
INS_KEY        EQU  37H       ; SCAN CODE FOR INSERT KEY
BREAK_KEY      EQU  60H       ; SCAN CODE FOR BREAK KEY
;
;--------------------- 11-21-1983 (A) ------------------------------
;
;* EXTRN FOR BEEP
;
	EXTRN	MDPSD:NEAR	; SOUND BEEP ROUTINE IN ITFROM
;
;* RESET VECTOR DEFINITION
;
;------------------------------------- 04-23-1984 (CHANGED) ------
RESET	SEGMENT	AT 0F800H
	ORG	3	; 0-2 IS COLD BOOT ENTRY
RESET_VECTOR	LABEL	FAR	; WARM BOOT ENTRY IN ROM
;------------------------------------ 04-23-1984 ---------
RESET	ENDS
;
;--------------------- 11-21-1983 (A) -------------------------------
;
ROM 		SEGMENT		WORD   PUBLIC
;----------------------------------------------------------------------
; KEYBOARD I/O
;       THESE ROUTINE PROVIDE KEYBOARD SUPPORT
;
; INPUT
;       (AH)=0 READ THE NEXT ASCII CHARACTER STRUCK FROM THE KEYBOARD
;              RETURN THE RESULT IN (AL),SCAN CODE IN (AH)
;
;       (AH)=1 SET THE Z FLAG TO INDICATE IF AN ASCII CHARACTER IS
;              AVAILABLE TO BE READ.
;              (ZF)=1 -- NO CODE AVAILABLE
;              (ZF)=0 -- CODE IS AVAILABLE
;              IF ZF =0,THE NEXT CHARACTER IN THE BUFFER TO BE READ IS
;              IN AX, AND THE ENTRY REMAINS IN THE BUFFER
;
;       (AH)=2 RETURN THE CURRENT SHIFT STATUS IN AL REGISTER
;              THE BIT SETTINGS FOR THIS CODE ARE INDICATED IN THE
;              EQUATES FOR KB_FLAG
;
;
; OUTPUT
;       AS NOTED ABOVE, ONLY AX AND FLAGS CHANGED
;       ALL REGISTERS RETAINED
;
;
;----------------------------------------------------------------------
          ASSUME CS:ROM ,DS:SYSCOM,ES:SYSCOM,SS:SYSCOM
;
KEYBOARD_IO    PROC  FAR
          STI                      ; INTERRUPTS BACK ON
          PUSH      DS             ; SAVE CURRENT DS
          PUSH      BX             ; SAVE BX TEMPORARILY
          MOV       BX,SYSCOM      ;
          MOV       DS,BX          ; ESTABLISH POINTER TO DATA REGION
          OR        AH,AH          ; AH=0
          JZ        KBDATAIN       ; ASCII_READ
          DEC       AH             ; AH=1
          JZ        KBFIFOST       ; ASCII_STATUS
          DEC       AH             ; AH=2
          JZ        KBSHIFTST      ; SHIFT_STATUS
          POP       BX             ; RECOVER REGISTER
          POP       DS             ;
               IRET                ; INVALID COMMAND
;
;-------  READ THE KEY TO FIGURE OUT WHAT TO DO
;
KBDATAIN:                          ; ASCII READ
          STI                      ; INTERRUPT BACK ON DURING LOOP
          NOP                      ; ALLOW AN INTERRUPT TO OCCUR
          CLI                      ; INTERRUPTS BACK OFF
;
          MOV       BX,BUFFER_HEAD ; GET POINTER TO HEAD OF BUFFER
          CMP       BX,BUFFER_TAIL ; TEST END OF BUFFER
          JZ        KBDATAIN       ; LOOP UNTIL SOMETHING IN BUFFER
          MOV       AX,[BX]        ; GET SCAN CODE AND ASCII CODE
          CALL      KBPUP          ; MOVE POINTER TO NEXT
          MOV       BUFFER_HEAD,BX ; STORE VALUE IN VARIABLE
          POP       BX             ; RECOVER REGISTER
          POP       DS             ; RECOVER SEGMENT
          IRET                     ; RETURN TO CALLER
;
;-------  ASCII STATUS
;
KBFIFOST:
          CLI                      ; INTERRUPTS OFF
          MOV       BX,BUFFER_HEAD ; GET HEAD POINTER
          CMP       BX,BUFFER_TAIL ; IF EQUAL (Z=1) THEN NOTHING THERE
          MOV       AX,[BX]        ;
          STI                      ; INTERRUPTS BACK ON
          POP       BX             ; RECOVER REGISTER
          POP       DS             ; RECOVER SEGMENT
          RET       2              ; THROW AWAY FLAGS
;
;-------  SHIFT STATUS
;
KBSHIFTST:
          MOV       AL,KB_FLAG     ; GET THE SHIFT STATUS FLAGS
          POP       BX             ; RECOVER REGISTER
          POP       DS             ; RECOVER SEGMENT
          IRET
KEYBOARD_IO         ENDP
;
;-------  INCREMENT A BUFFER POINTER
;
KBPUP     PROC      NEAR
          ADD       BX,2                     ; MOVE TO NEXT WORD IN LAST
          CMP       BX,OFFSET KB_BUFFER_END  ; AT END OF BUFFER ?
          JNE       KBPUPE                   ; NO,CONTINUE
          MOV       BX,OFFSET KB_BUFFER      ; YES,RESET TO BUFFER BEGIN
KBPUPE:
          RET
KBPUP	  ENDP
;
;-------  TABLE OF SHIFT KEYS AND MASK VALUES
;
KSFTTBL   LABEL     BYTE
          DB        INS_KEY	; INSERT KEY
          DB        CAPS_KEY	; CAPS LOCK KEY
	  DB	    GR1_KEY	; GRAPH1 SHIFT KEY
	  DB	    GR2_KEY	; GRAPH2 SHIFT KEY
	  DB	    ALT_KEY	; ALT SHIFT KEY
	  DB	    CTL_KEY	; CONTROL SHIFT KEY
          DB        SHIFT_KEY	; SHIFT KEY
	  DB	    FNC_KEY	; FNC SHIFT KEY
KSFTTBLL  EQU       $-KSFTTBL
;
;-------  SHIFT_MASK_TABLE
;
KSFMTBL   LABEL     BYTE
          DB        INS_SHIFT	; INSERT MODE SHIFT
          DB        CAPS_SHIFT	; CAPS LOCK MODE
	  DB	    GR1_SHIFT	; GRAPH1 MODE SHIFT
	  DB	    GR2_SHIFT	; GRAPH2 MODE SHIFT
	  DB	    ALT_SHIFT	; ALT MODE SHIFT
	  DB	    CTL_SHIFT	; CONTROL MODE SHIFT
          DB        SHIFT_SHIFT	; SHIFT MODE SHIFT
	  DB	    FNC_SHIFT	; FNC MODE SHIFT
;
;-------  ALT_INPUT_TABLE
;
KALTTBL   LABEL     BYTE
          DB        4CH,48H,49H,4AH,44H
          DB        45H,46H,40H,41H,42H      ; 10 NUMBERS ON KEYPAD
;-------  SUPER SHIFT TABLE
          DB        10H,11H,12H,13H,14H      ; A-Z TYPEWRITER CHARS
          DB        15H,16H,17H,18H,19H
          DB        1EH,1FH,20H,21H,22H
          DB        23H,24H,25H,26H,2AH
          DB        2BH,2CH,2DH,2EH,2FH
          DB        30H
;-------  SPECIAL KEY TABLE
KSPCTBL	  LABEL     BYTE
          DB        35H,36H,37H,38H,39H
          DB        3AH,3BH,3CH,3DH,60H
          DB        61H,6FH
;
;-------  SCAN CODE TABLE
;
KSCATBL   LABEL     BYTE
          DB        1BH, -1,  0, -1, -1, -1, -1, -1, -1
          DB         -1, -1,1FH, -1, -1,7FH, -1,11H,17H
          DB        05H,12H,14H,19H,15H,09H,0FH,10H,1BH
          DB        1DH,1CH,1EH,01H,13H,04H,06H,07H,08H
          DB        0AH,0BH,0CH, -1, -1,0AH,1AH,18H,03H
          DB        16H,02H,0EH,0DH, -1, -1, -1,20H
;
;
;-------  UC TABLE SCAN
;
KUCSTBL   LABEL     BYTE
          DB        0FH,35H,36H,37H,38H
          DB        39H,3AH,3BH,3CH,3DH
;
;-------  UC TABLE
;
KUCDTBL   LABEL     BYTE
          DB        1BH,'!@#$%','^','&*()',5FH,2BH,7EH,08H,-1
          DB        'QWERTYUIOP',7BH,7DH,7CH,5EH,'ASDFGHJKL:"',0DH
          DB        'ZXCVBNM<>? ',-1,-1,-1,-1,-1,-1,-1,-1,-1,2FH
          DB        '*789-','456+','123',0DH,'0.'
;
;-------  LC SCAN TABLE
;
KLCSTBL   LABEL     BYTE
          DB        6FH,75H,35H,36H,37H,38H,39H,3AH
          DB        3BH,3CH,3DH,61H,60H
;
;-------  LC TABLE
;
KLCDTBL   LABEL     BYTE
          DB        1BH,'1234567890-=',60H,08H,09H
          DB        'qwertyuiop',5BH,5DH,5CH,-1,'asdfghjkl;',27H,0DH
          DB        'zxcvbnm,./ ',-1,-1,-1,-1,-1,-1,-1,-1,-1,2FH
          DB        '*789-','456+','123',0DH,'0.'
;
;-------  KEYBOARD INTERRUPT ROUTINE
;
KB_INT    PROC      FAR
          STI                      ; ALLOW FURTHER INTERRUPTS
          PUSH      AX
          PUSH      BX
          PUSH      CX
          PUSH      DX
          PUSH      SI
          PUSH      DI
          PUSH      DS
          PUSH      ES
          CLD                      ; FORWARD DIRECTION
          MOV       AX,SYSCOM      ;
          MOV       DS,AX          ; SET UP ADDRESSING
	  IN	    AL,KB_STA	   ; READ STATUS FROM 8251A
	  TEST	    AL,38H	   ; 
	  JZ	    KI1		   ; JUMP IF NO ERROR
;
	  CMP	    KB_RETRY,3	   ; CHECK RETRY COUNT
	  JE	    KI1		   ; JUMP IF KB_RETRY = 3
	  INC	    KB_RETRY	   ; RETRY ONCE MORE
	  MOV	    AL,14H	   ;
	  OUT	    KB_CMD,AL 	   ; SEND RETRY_COMMAND
	  NOP			   ;
	  IN	    AL,KB_DATA	   ; THROW AWAY ERROR_DATA
	  JMP	    KI11	   ;
;
KI1:
	  MOV	    KB_RETRY,0	   ;
	  MOV	    AL,16H    	   ; SEND NON_RETRY_COMMAND TO 8251A
	  OUT	    KB_CMD,AL	   ;
	  NOP			   ;
	  IN	    AL,KB_DATA	   ; GET SCAN_CODE FROM IO-PORT
;
          MOV       AH,AL          ; SAVE SCAN CODE IN AH ALSO
;
;--------------------- 05-07-1984 (A) -------------------------------------
;
;	CHECK FOR KEY CLICK SOUND
;
	TEST	AL,80H		; SEE IF BREAK INTERRUPT
	JNZ	KI_NO_CLICK	; NO CLICK ON BREAK, GO ONLY WHEN
				; MAKE INTERRUPT OCCURS.
;
	MOV	BX,0A3FEH	; CMOS SEGMENT
	MOV	ES,BX		; ESTABLISH ADDRESSING
	MOV	AL,ES:[0AH]	; SEE SWITCH FOR KEY CLICK
	TEST	AL,80H		; CLICK SOUND ON ?
	JZ	KI_NO_CLICK	; NO CLICK
;
	MOV	CX,2000H	; ABOUT 0.01 SEC
	CALL	ERROR_BEEP	; SUOND BUZZER
KI_NO_CLICK:
	MOV	AL,AH		; RECOVER SCAN CODE
;
;-------------------- 05-07-1984 (A) --------------------------------------
;
;
;-------  TEST FOR SHIFT KEYS
;
KI2:                               	; TEST SHIFT
          AND       AL,7FH         	; TURN OFF THE BREAK BIT
          PUSH      CS			;
          POP       ES             	; ESTABLISH ADDRESS OF SHIFT TABLE
          MOV       DI,OFFSET KSFTTBL  	; SHIFT KEY TABLE
          MOV       CX,KSFTTBLL    	; LENGTH
          REPNE     SCASB          	; LOOK THROUGH THE TABLE FOR A MATCH
          MOV       AL,AH          	; RECOVER SCAN CODE
          JE        KI3            	; JUMP IF MATCH FOUND
          JMP       KI10           	; IF NO MATCH, THEN SHIFT NOT FOUND
;
;-------  SHIFT KEY FOUND
;
KI3:      SUB       DI,OFFSET KSFTTBL+1 ; ADJUST PTR TO SCAN CODE MATCH
          MOV       AH,CS:KSFMTBL[DI]   ; GET MASK INTO AH
          TEST      AL,80H         	; TEST FOR BREAK KEY
          JNZ       KI8            	; BREAK SHIFT FOUND
;
;-------  SHIFT MAKE FOUND, INSERT SHIFT SHIFT CHECK
;
          CMP       AH,INS_SHIFT   ; IF INS SHIFT KEY
          JE        KI4            ;
;
;-------  PLAIN SHIFT KEY,SET SHIFT ON
;
          OR        KB_FLAG,AH     ; TURN ON SHIFT BIT
          JMP       KI11           ; INTERRUPT RETURN
;-------  INSERT KEY IN  AND FUNCTION SHIFT KEY IN
KI4:
          OR        KB_FLAG,AH     ; INSERT SHIFT BIT SET
	  MOV	    AX,3737H	   ; SCAN CODE SET
          JMP       KI10           ; CONVERT 
;
;-------  BREAK SHIFT FOUND
;
KI8:
          NOT       AH             ; INVERS MASK
          AND       KB_FLAG,AH     ; TURN OFF SHIFT BIT
          CMP       AL,ALT_KEY+80H ; CHECK  ALTERNATE SHIFT RELEASE
          JNE       KI11           ; INTERRUPT RETURN
;
;-------  ALTERNATE SHIFT KEY RELEASED, GET THE VALUE INTO BUFFER
;
          MOV       AL,ALT_INPUT   ;
          MOV       AH,0           ; SCAN CODE OF 0
          MOV       ALT_INPUT,AH   ; ZERO OUT THE FIELD
          CMP       AL,0           ; CHECK INPUT = 0
          JE        KI11           ; INTERRUPT RETURN
          JMP       KI46           ; PUT DATA IN FIFO BUFFER
;
;--------- BREAK KEY CHECK
;
KI10:
          CMP       AL,80H         ; TEST FOR BREAK KEY
          JAE       KI11           ; NOTHING FOR BREAK CHARS FROM HERE ON
          JMP       SHORT KI13     ;
;
KI11:                              ; INTERRLPT RETURN
          CLI                      ; TURN OFF INTERRUPTS
          MOV       AL,EOI         ; END OF INTERRUPT COMMAND
          OUT       INTTM_02,AL    ;
KI12:                              ; INTERRUPT-RETURN-NO-EOI
          POP       ES
          POP       DS
          POP       DI
          POP       SI
          POP       DX
          POP       CX
          POP       BX
          POP       AX             ; RESTORE STATE
          IRET                     ; RETURN,INTERRUPTS BACK ON WITH FLAG CHANGE
;
;-------  TEST FOR SPECIAL CHARS
;
KI13:
          TEST      KB_FLAG,ALT_SHIFT   ; CHECK  ALTERNATE SHIFT
          JZ        KI19                ; JUMP IF NOT ALTERNATE
;
;-------  IN ALTERNATE SHIFT
;
          CMP       AL,34H         ; TEST FOR SPACE KEY
          JNE       KI14           ; NOT THERE
          MOV       AL,' '         ; SET SPACE CHAR
          JMP       KI45           ; BUFFER FILL
;
;-------  LOOK FOR KEY PAD ENTRY
;
KI14:                              	; ALT-KEY-PAD
          MOV       DI,OFFSET KALTTBL  	; ALT-INPUT-TABLE
          MOV       CX,10          	; LOOK FOR ENTRY USING KEYPAD
          REPNE     SCASB          	; LOOK FOR MATCH
          JNE       KI15           	; NO_ALT_KEYPAD
          SUB       DI,OFFSET KALTTBL+1 ; SET ENTRY VALUE TO DI
          MOV       AL,ALT_INPUT   ; GET THE CURRENT BYTE
          MOV       AH,10          ; MULTIPLY BY 10
          MUL       AH             ;
          ADD       AX,DI          ; ADD IN THE LATEST ENTRY
          MOV       ALT_INPUT,AL   ; STORE IT AWAY
          JMP       KI11           ; THROW AWAY THAT KEYSTROKE
;
;-------  LOOK FOR ALT+ALPHABET ENTRY
;
KI15:                              ; NO_ALT_KEYPAD
          MOV       ALT_INPUT,0    ; ZERO ANY PREVIOUS ENTRY INTO INPUT
          MOV       CX,26          ; DI,ES ALREADY POINTING
          REPNE     SCASB          ; LOOK FOR MATCH IN ALPHABET
          JNE       KI16           ; NOT FOUND,FUNCTION KEY OR OTHER
          MOV       AL,0           ; ASCII CODE OF ZERO
          JMP       KI45           ; PUT IT IN THE BUFFER
;
;-------  LOOK FOR TOP ROW OF ALTERNATE SHIFT
;
KI16:                              ; ALT_TOP_ROW
          CMP       AL,1           ; KEY WITH '1' ON IT
          JB        KI17           ; NO ONE OF INTERESTING KEYS
          CMP       AL,13          ; IS IT IN THE REGION
          JAE       KI17           ; ALT_FUNCTION
          ADD       AH,4FH         ; CONVERT PSEUDO SCAN CODE TO RANGE
          MOV       AL,0           ; ASCII CODE OF ZERO
          JMP       KI45           ; BUFFER_FILL
;
;-------  LOOK FOR FUNCTION KEY ENTRY IN ALTERNAT SHIFT
;
KI17:                              ; ALT_FUNCTION
          CMP       AL,62H         ; TEST FOR FUNCTION KEY
          JB        KI18           ;
          CMP       AL,6DH         ;
          JA        KI18           ;
          ADD       AH,42H         ; CONVERT PSEUDO SCAN CODE TO RANGE
          MOV       AL,0           ; INDICATE AS SUCH
          JMP       KI45           ; BUFFER_FILL
;
;-------  LOOK FOR SPECIAL KEY ENTRY IN ALTERNATE SHIFT
;
KI18:                              	; ALT_SPECIAL KEY
          MOV       CX,12          	;
	  MOV	    DI,OFFSET KSPCTBL 	;
          REPNE     SCASB          	; LOOK FOR MATCH IN SPECIAL
          JNE       KI25_INTER     	; IGNORE THE KEY ---- 11-21-1983 (C)
          SUB       DI,OFFSET KSPCTBL+1 ; SET ENTRY VALUE TO DI
          MOV       AX,DI          ;
	  MOV	    AH,AL	   ;
          ADD       AH,0C0H        ; CONVERT PSEUDO SCAN CODE TO RANGE
          MOV       AL,0           ; INDICATE AS SUCH
          JMP       KI45           ; BUFFER_FILL
;
;--------------------- 11-21-1983 (A) FOR RELATIVE JMP ------
;
KI25_INTER:
	JMP	KI25		; GO TO REAL KI25
;
;--------------------- 11-21-1983 (A) -----------------------
;


;
;-------  NOT IN ALTERNATE SHIFT
;
KI19:                                   ; NOT_ALT_SHIFT
          TEST      KB_FLAG,CTL_SHIFT   ; CHECK CONTROL SHIFT ON
          JZ        KI26_INTER                ; NOT_CTL_SHIFT
;
;------------------------ 04-26-1984 (A) ----------------------
;
;	CHECK CTL+SHIFT+PRINT (GRAPHICS DUMP)
;
	TEST	KB_FLAG,SHIFT_SHIFT	; SEE IF SHIFT KEY DEPRESSED
	JZ	KI191			; NOT IN SHIFT, GOTO CHECK FNC.
	CMP	AL,61H			; PRINT KEY ?
	JNZ	KI191			; NO, GOTO CHECK FNC+BREAK
;
;------- CTL + SHIFT + PRINT, CALL CRTDUMP VIA INT 5H
;
	MOV	AL,EOI			; END CURRENT INTERRUPT
	OUT	INTTM_02,AL		; OUTPUT EOI
	MOV	AL,1			; INDICATE GRAPHICS DUMP
	INT	5H			; ISSUE PRINT SCREEN INTERRUPT
	JMP	KI12			; GO BACK WITHOUT EOI OCCURING
;
;	INTERMEDIATE JMP POINT FOR KI26
;
KI26_INTER:
	JMP	KI26		; GO TO ACTUAL KI26
;------------------------------- 04-26-1984 (A) END ------------------------
;
;-------  CONTROL SHIFT, TEST SPECIAL CHARACTERS
;-------  TEST FOR RESET KEY SEQUENCE (FNC CTL BREAK)
;
KI191:		;-------------------------------- 04-26-1984 (A) -------
          TEST      KB_FLAG,FNC_SHIFT   ; CTL + FNC SHIFT ON
          JZ        KI20                ; NO_RESET
          CMP       AL,60H              ; TEST FOR BREAK KEY
          JNE       KI20                ; NO_RESET
;
;-------  CTL+FNC+BREAK HAS BEEN FOUND, DO I/O CLEANUP
;
	  JMP	    RESET_VECTOR	; GO TO RESET PROC.
					;---- 11-21-1983 (A) ---
;
;-------  CTL+BREAK HAS BEEN FOUND
;
KI20:
	  CMP	    AL,60H	   	;
	  JNE	    KI21 	   	;
	  MOV	    BX,OFFSET KB_BUFFER	;
	  MOV	    BUFFER_HEAD,BX ; BUFFER CLEAR
	  MOV	    BUFFER_TAIL,BX ;
	  MOV	    BIOS_BREAK,80H ; TURN ON THE BIOS_BREAK 
	  INT	    6H		   ; BREAK INTERRUPT VECTOR
	  MOV	    AX,0	   ; PUT OUT DUMMY CHARACTER
	  JMP	    KI45	   ; BUFFER_FILL
;
;-------  SET UP TO TRANSLATE CONTROL SHIFT
;
KI21: 
          CMP       AL,34H         	;
          JA        KI22           	;
          MOV       BX,OFFSET KSCATBL   ; SET UP TO TRANSLATE CTL
	  CMP	    AL,1FH	   ; CTRL + S CHECK
	  JE	    KI210	   ; YES
	  CMP	    AL,2CH	   ; CTRL + C CHECK
	  JNE	    KI212	   ; NO
KI210:
	  CALL 	    FLUSH	   ; KB FIFO CLEAR
KI212:
          JMP       KI44           ; GO TRANSLATE CHAR
KI22:     CMP       AL,4BH         ; TEST FOR C/R KEY
          JNE       KI23           ; SKIP IF NOT
          MOV       AL,0AH         ; SET L/F CODE INTO AL
          JMP       KI45           ; BUFFER_FILL
KI23:
          MOV       DI,OFFSET KSPCTBL  	; CTL TABLE SCAN
          MOV	    CX,12	   	;
	  REPNE	    SCASB	    	; LOOK FOR MATCH SPECIAL
	  JNE	    KI24	    	; NOT JUMP
	  SUB	    DI,OFFSET KSPCTBL+1 ; SET ENTRY VALUE TO DI
	  MOV	    AX,DI	    	; 
	  MOV	    AH,AL	    	;
	  ADD	    AH,0B0H	    	; CONVERT PSEUDO SCAN CODE TO RAMGE
	  MOV	    AL,0	    	; SET ZERO INTO AL
	  JMP	    KI45	    	;
KI24:     CMP       AL,62H         	; FUNCTION KEY CHECK
          JB        KI25           	;
          CMP       AL,6DH         	;
          JA        KI25           	;
          ADD       AH,36H         	; CONVERT PSEUDO SCAN CODE TO RANGE
          MOV       AL,0           	; INDICATE AS SUCH
          JMP       KI45           	; BUFFER_FILL
KI25:     JMP       KI11           	; INTERRUPT RETURN
;
;-------  NOT IN CONTROL SHIFT
;
KI26:
          TEST      KB_FLAG,GR1_SHIFT   ; CHECK GRAPH1 LOCK KEY ON
          JZ        KI29                ; SKIP IF NOT
;
;-------  GRAPH 1 SWITCH ON
;
          CMP       AL,10H              ; TEST FOR ASCII KEY REGION
          JB        KI32                ; INTERRUPT RETURN
          CMP       AL,30H              ;
          JA        KI32                ; INTERRUPT RETURN
          CMP       AL,29H              ; C/R KEY CHECK
          JE        KI32                ; INTERRUPT RETURN
;
          ADD       AL,70H              ; SET CONVERT DATA INTO AL
          CMP       AL,9AH              ;
          JB        KI27                ;
          DEC       AL                  ;
KI27:
          TEST      KB_FLAG,SHIFT_SHIFT ; TEST FOR SHIFT STATE
          JZ        KI28                ; SKIP IF NOT SHIFT
          ADD       AL,20H              ; SET UPPER CASE DATA
KI28:     JMP       KI45                ; PUT INTO PUTPUT BUFFER
;
;
;-------  GRAPH 2 SWITCH ON
;
KI29:
          TEST      KB_FLAG,GR2_SHIFT   ; CHECK GRAPH2 LOCK KEY ON
          JZ        KI35                ; SKIP IF NOT
;
          CMP       AL,10H              ; TEST FOR KEYPAD REGION
          JB        KI32                ; INTERRUPT RETURN
          CMP       AL,30H              ;
          JA        KI32                ; INTERRUPT RETURN
          CMP       AL,29H              ; C/R KEY CHECK
          JE        KI32                ; INTERRUPT RETURN
;
          ADD       AL,0B0H             ; SET CONVERT DATA INTO AL
          CMP       AL,0DAH             ;
          JB        KI30                ;
          DEC       AL                  ;
KI30:
          TEST      KB_FLAG,SHIFT_SHIFT ; TEST FOR SHIFT STATE
          JZ        KI31                ; SKIP IF NOT SHIFT
          ADD       AL,20H              ; SET UPPER CASE DATA
KI31:     JMP       KI49                ; PUT INTO OUTPUT BUFFER
KI32:	  JMP	    KI11		; INTERRUPT RETURN
;
;-------  NOT IN GRAPH 1,2 SWITCH ON
;
KI35:                                   ; NOT-GR2-SHIFT
          TEST      KB_FLAG,SHIFT_SHIFT ; CHECK SHIFT KEY ON
          JZ        KI40                ; JMP IF NOT
          CMP       AL,61H              ; TEST FOR PRINT KEY
          JNE       KI36                ; JMP IF NOT
;
;-------  PRINT SCREEN FUNCTION
;
          MOV       AL,EOI              ; END OF CURRENT INTERRUPT
          OUT       INTTM_02,AL         ; EOI OUTPUT
	MOV	AL,0			; ---- 04-26-1984 (A) --- INDICATE TEXT.
          INT       5H                  ; ISSUE PRINT SCREEN INTERRUPT
          JMP       KI12                ; GO BACK WITHOUT EOI OCCURING
;
;-------  UPPER CASE,HANDLE SPECIAL CASES
;
KI36:
          MOV       CX,10          	; LOOK FOR ENTRY UC KEY
          MOV       DI,OFFSET KUCSTBL  	; UC SCAN TABLE
          REPNE     SCASB          ; LOOK FOR MATCH
          JNE       KI37           ; NOT FOUND
          MOV       AL,0           ; SET ZERO INTO AL
          JMP       KI45           ; PUT IT IN THE BUFFER
;
;-------  UPPER CASE,HANDLE FUNCTION KEY
;
KI37:
          CMP       AL,62H         ; FUNCTION KEY CHECK
          JB        KI38           ;
          CMP       AL,6DH         ;
          JA        KI38           ;
          ADD       AH,2AH         ; CONVERT PSEUDO SCAN CODE TO RANGE
          MOV       AL,0           ; SET ZERO INTO AL
          JMP       KI45           ; PUT IT IN THE BUFFER
;
;-------  UPPER CASE,NOT FUNCTION  ;
;
KI38:
          CMP       AL,4DH         	;
          JA        KI39           	; INTERRUPT RETURN
          MOV       BX,OFFSET KUCDTBL   ; POINT TO UPPER CASE TABLE
          JMP       KI44           	; TRANSLATE THE CHAR
KI39:
	  JMP	    KI11	   	; INTERRUPT RETURN
;
;-------  FUNCTION KEY
;
KI40:
          TEST      KB_FLAG,FNC_SHIFT
          JZ        KI41
	  MOV	    CX,12	   	;
	  MOV	    DI,OFFSET KSPCTBL 	;
	  REPNE	    SCASB	   	; LOOK FOR MATCH SPECIAL
	  JNE	    KI401	   	;
	  SUB	    DI,OFFSET KSPCTBL+1 ;
	  MOV	    AX,DI	   ;
	  ADD	    AL,0D0H	   ; CONVERT PSEUDO SCAN CODE TO RANGE
	  MOV	    AH,AL	   ;
	  MOV	    AL,0	   ; SET ZERO INTO AL
	  JMP	    KI45	   ;
;
KI401:
          CMP       AL,62H         ; FUNCTION KEY CHECK
          JB        KI402          ; INTERRUPT RETURN
          CMP       AL,6DH         ;
          JA        KI402          ; INTERRUPT RETURN
          ADD       AH,1EH         ; CONVERT PSEUDO SCAN CODE TO RANGE
          MOV       AL,0           ; SET ZERO INTO AL
          JMP       KI45           ; PUT IT IN THE BUFFER
KI402:
	  JMP	    KI11	   ; INTERRUPT RETURN
;
;-------  LOWER CASE
;
KI41:
;
;-------  LOWER CASE,HANDLE SPECIAL CASES
;
          MOV       CX,13          	; LOOK FOR ENTRY LC KEY
          MOV       DI,OFFSET KLCSTBL 	; LC SCAN TABLE
          REPNE     SCASB          ; LOOK FOR MATCH
          JNE       KI42           ; NOT FOUND
	  CMP	    AL,60H	   ; BREAK STOP KEY CHECK
	  JNE	    KI410	   ; NO
	  CALL	    FLUSH	   ; KB FIFO CLEAR
KI410:
          MOV       AL,0           ; SET ZERO INTO AL
          JMP       KI45           ; PUT IT INTO THE BUFFER
;
;-------  LOWER CASE,HANDLE FUNCTION KEY
;
KI42:
          CMP       AL,62H         ; FUNCTION KEY CHECK
          JB        KI43           ;
          CMP       AL,6DH         ;
          JA        KI43           ;
          MOV       AL,0           ; SET ZERO INTO AL
          JMP       KI45           ; PUT IT IN THE BUFFER
;
;-------  LOWER CASE,NOT FUNCTION
;
KI43:
          CMP       AL,4DH         	;
          JA        KI47           	; INTERRUPT RETURN
          MOV       BX,OFFSET KLCDTBL   ; POINT TO LOWER CASE TABLE
;
;-------  TRANSLATE THE CHARACTER
;
KI44:
          XLAT      CS:KUCDTBL     ; CONVERT THE SCAN CODE TO ASCII
;
;-------  PUT CHARACTER INTO BUFFER
;
KI45:                              ; BUFFER-FILL
          CMP       AL,-1          ; CHECK IGNORE CHAR
          JE        KI47           ; NEAR INTERRUPT RETURN
          CMP       AH,-1          ; LOOK FOR -1 PSEUDO SCAN
          JE        KI47           ; NEAR INTERRUPT RETURN
;
;-------  HANDLE THE CAPS LOCK PROBLEM
;
KI46:                                   ; BUFFER-FILL-NOTEST
          TEST      KB_FLAG,CAPS_STATE  ; CHECK CAPS LOCK STATE
          JZ        KI49                ; SKIP IF NOT
;
;-------  IN CAPS LOCK STATE
;
          TEST      KB_FLAG,SHIFT_SHIFT ; TEST FOR SHIFT STATE
          JZ        KI48                ; IF NOT SHIFT,CONVERT LOWER TO UP
;
;-------  CONVERT ANY UPPER CASE TO LOWER CASE
;
          CMP       AL,'A'         ; CHECK A -- Z KEY ON
          JB        KI49           ; NOT_CAPS_STATE
          CMP       AL,'Z'         ;
          JA        KI49           ; NOT_CAPS_STATE
          ADD       AL,'a'-'A'     ; CONVERT TO LOWER CASE
          JMP       SHORT KI49     ; NOT_CAPS_STATE
KI47:                              ; NEAR INTERRUPT RETURN
          JMP       KI11           ; INTERRUPT RETURN
;
;-------  CONVERT ANY LOWER CASE TO UPPER CASE
;
KI48:                              ; LOWER TO UPPER
          CMP       AL,'a'         ; CHECK a -- z KEY ON
          JB        KI49           ; NOT_CAPS_STATE
          CMP       AL,'z'         ;
          JA        KI49           ; NOT_CAPS_STATE
          SUB       AL,'a'-'A'     ; CONVERT TO UPPER CASE
KI49:                              ; NOT_CAPS_STATE
;
;----------------------------- 05-07-1984 (A) ---------------
;
	MOV	KB_CODE,AX	; SAVE CONVERTED CODE
;
;----------------------------- 05-07-1984 (A) ---------------
;
          MOV       BX,BUFFER_TAIL ; GET THE END POINTER TO THE BUFFER
          MOV       SI,BX          ; SAVE THE VALUE
          CALL      KBPUP          ; ADVANCE THE TAIL
          CMP       BX,BUFFER_HEAD ; CHECK THE BUFFER AROUND
          JE        KI50           ; BUFFER_FULL_BEEP
          MOV       [SI],AX        ; STORE THE VALUE
          MOV       BUFFER_TAIL,BX ; MOVE THE POINTER UP
          JMP       KI11           ; INTERRUPT RETURN
;
;-------  BUFFER IS FULL,SOUND THE BEEPER
;
KI50:                              ; BUFFER-FULL-BEEP
;------------- 04-26-1984 (A) ---------------------------------------------
	XOR	CX,CX		; FULL INTERVAL FOR BUZZER
;--------------------------------------------------------------------------
          CALL      ERROR_BEEP
          JMP       KI11           ; INTERRUPT_RETURN
;
KB_INT	  ENDP
ERROR_BEEP	PROC	NEAR
;
;---------------- 04-26-1984 (A) BEGIN ------------------------
;
SYS_PORT_C	EQU	37H	; SYSTEM PORT C (TO CONTROL BUZZER)
;
	MOV	AL,06H		; BUZZER ON
	OUT	SYS_PORT_C,AL
	LOOP	$		; WAIT
	MOV	AL,07H		; BUZZER OFF
	OUT	SYS_PORT_C,AL
	RET
ERROR_BEEP	ENDP
;------- 12-06-1983 (A) --------------------------------------
FLUSH		PROC	NEAR
		PUSH	BX			;
		MOV	BX,OFFSET KB_BUFFER	; 
		MOV	BUFFER_HEAD,BX		; BUFFER CLEAR
		MOV	BUFFER_TAIL,BX		; 
		POP	BX			;
		RET				;
FLUSH		ENDP
;------- 12-06-1983 (A) --------------------------------------
ROM 	  	ENDS
		END
