	PAGE	60,132
	TITLE	PRINTER_ROM
;NOV./16/1983		; USING SYSCOM
;
;	NOV/16/83
;	NOV/18/83
;	NOV/21/83
;	NOV/26/83
;	NOV/30/83
;	MAR/13/84
;****************************************
;*					*
;*	EQUATE AREA			*
;*					*
;****************************************
;*
;**	CENTRO TYPE
;*
;...	COMMAND CODE OF UPD8255
PRCEN_MOD	EQU	0A2H		; 8255 PORTC MODE
PRCEN_STBON	EQU	0FH		; P_STROB HIGH
PRCEN_STBOFF	EQU	0EH		; P_STROB LOW
PRCEN_INTON	EQU	00H		; PRINTER INITIALIZE (SET) NOV/18/83
PRCEN_INTOFF	EQU	01H		; PRINTER INITIALIZE (RESET) NOV/18/83
PR_MSK_ON	EQU	0DH		; MASK ON

PR_MSK_OFF	EQU	0CH		; MASK OFF
;...	IO PORT ADDRESS
PR_MODE		EQU	46H
PR_WSIG		EQU	46H
PR_DATA		EQU	40H
PR_RSIG		EQU	42H
SYS_PORT	EQU	37H
;*
;**	ODA TYPE
;*
;....	COMMAND CODE OF UPD8255
PRODA_MOD	EQU	0A2H		; 8255A INITIALIZE
PRODA_INTE	EQU	0DH		; INTERRUPT ENABLE
PRODA_INTON	EQU	00H		; PRINTER INITIALIZE (SET)
PRODA_INTOFF	EQU	01H		; PRINTER INITIALIZE (RESET)
PRODA_RMS	EQU	0AH		; RMS SIGNAL
;...	I/O PORT ADDRESS
PODA_MOD	EQU	0C6H		; ODA PRINTER IO PORT (8255 CONTROL)
PODA_WSG	EQU	0C6H		
PODA_DAT	EQU	0C0H
PODA_RSG	EQU	0C2H
;*
;**	INTERRUPT PIC (UPD8259)
;*
INTM_O1		EQU	02H
INTM_O2		EQU	00H
EOI		EQU	20H
;*
;**	CONTROL CHARACTER
;*
PRODA_SI	EQU	0FH		; SI CODE
PRODA_SO	EQU	8EH		; SO CODE
CR		EQU	0DH
LF		EQU	0AH
		PAGE
;************************************************
;*						*
;*		OTHOR SEGMENT			*
;*						*
;************************************************

;****************************************
;*	INTERRUPT VECTOR		*
;****************************************
INT_VEC		SEGMENT	AT 0000H
PRN_ROM		EQU	1BH
INT_VEC		ENDS
;****************************************
;*	USER PARAMETER SEGMENT		*
;*		This is dummy segment	*
;*		for assemble		*
;****************************************
USER		SEGMENT	AT 0060H
USER		ENDS
;****************************************
;*	C-MOS SEGMENT			*
;****************************************
CMOS		SEGMENT	AT 0A3FEH
		ORG	2*4+2
PR_TYPE		LABEL	BYTE
CMOS		ENDS
;****************************************
;*	V-RAM SEGMENT			*
;****************************************
VRAM		SEGMENT	AT 0A000H
		ORG	0
PAGE00		LABEL	BYTE
VRAM		ENDS
;
INCLUDE		B:SYSCOM.LIB
;
	.LFCOND		;------------------------------NOV/16/83----
		PAGE
ROM 	SEGMENT	WORD PUBLIC
	ASSUME	CS:ROM ,DS:SYSCOM,ES:USER,SS:USER
;
	PUBLIC	PRINTER_IO		; ROM ENTRY
	PUBLIC	HARD_COPY		; HARD COPY ENTRY
	PAGE
;****************************************************************
;*								*
;*  << INT IBH >>						*
;*								*
;*	THIS ROUTINE PROVIDES COMMUNICATION WITH PRINTER	*
;*								*
;*	    THE INTERFACE REGISTER IS (AH) REGISTER		*
;*		(AH)=0X : ASSIGNATION PRINTER BIO ROUTINE	*
;*		(AH)=03 : ASSIGNATION PRINTER LIO ROUTINE	*
;*								*
;*	    SYSTEM COMMON AREA(BIOS_FLAG)			*
;*		B7(ON) : 8MHZ MODE (0.125/CLOCK)		*
;*		  (OFF): 5MHZ MODE (0.2/CLOCK)			*
;*								*
;****************************************************************
PRINTER_IO	LABEL	NEAR
;
		STI
		PUSH	DS
		PUSH	DX
CMTPRN10:
;------------------------------------------------CHG NOV/16/83------
		MOV	DX,SEG CMOS
		MOV	DS,DX
	ASSUME	DS:CMOS,ES:USER
		TEST	[PR_TYPE],20H
		MOV	DX,SEG SYSCOM
		MOV	DS,DX
	ASSUME	DS:SYSCOM,ES:USER
		JNZ	CMTPRN20
;------------------------------------------------------------------
		CALL	PRN_CENTRO
		JMP	SHORT CMTPRN30
CMTPRN20:
		CALL	PRN_ODA
CMTPRN30:
		POP	DX
		POP	DS
		IRET
	PAGE
PRN_CENTRO:
;*********************************************
;*					     *
;*	<< CENTRO PRINTER PROCESS >>	     *
;*					     *
;*********************************************
	CMP	AH,03H		; ASSIGNATION PRINTER LIO ?  1983/11/7
	JNZ	PRB_CENTRO	; NO,	-------------NOV/30/83----
PRL_CENTRO:
;*********************************************************
;*							 *
;*							 *
;*	    << CENTRO PRINTER LIO ROUTINE >>		 *
;*							 *
;*	SUPPORT	PRINTER	IS CENTRO PRINTER		 *
;*	WRITE DATA WITH	"N" BYTE CHARACTER TO PRINT	 *
;*							 *
;*     ENTRY :>	PRINTER	LIO FROM BASIC INTERREPTER	 *
;*							 *
;*	       (CX) : PRINT DATA LENGTH			 *
;*	       (BX) : DATA BUFFER ADDRESS		 *
;*	       (ES) : DATA BUFFER SEGMENT ADDRESS	 *
;*							 *
;*     EXIT :> BASIC INTERREPTER FROM PRINTER LIO	 *
;*	      RETURN WITH (AH) SET WITH	END STSTUS	 *
;*							 *
;*	       (AH)=02 : TIME OUT ERROR			 *
;*		   =03 : OFFLINE ERROR			 *
;*		   =00 : NORMAL END			 *
;*							 *
;*     ABNORMAL EXIT :> RETURN STATUS NOT = 00H		 *
;*							 *
;*		   (BX)	: OUTPUT LAST ADDRESS		 *
;*		   (CX)	: REMAINING DATA LENGTH		 *
;*							 *
;*********************************************************
	XOR	AH,AH		; SET NORMAL STATUS
	JCXZ	PRL_CEN_END
PRL_CEN_WR:
	MOV	AH,00H		; SET DATA OUTPUT FUNCTION  1983/11/7
	MOV	AL,ES:[BX]	; SET WRITE CHARACTER
	CALL	PRB_CENTRO	; CALL PRINTER BIO ROUTINE
	CMP	AH,02H		; ERROR ?
	JNB	PRL_CEN_END	; YES,
	INC	BX		; SET NEXT DATA	ADDRESS
	LOOP	PRL_CEN_WR
PRL_CEN_END:
	RET
;
	PAGE
PRB_CENTRO:
;*********************************************************
;*							 *
;*	    << CENTRO PRINTER BIO ROUTINE >>		 *
;*							 *
;*	 THIS ROUTINE PROVIDES COMMUNICATION WITH	 *
;*	CENTRO PRINTER					 *
;*							 *
;*    ENTRY :>						 *
;*		(AH)=01H : PRINTER INITIALIZE		 * 1983/11/7
;*							 *
;*		(AH)=00H : WRITE DATA TO PRINTER	 * 1983/11/7
;*		    (AL) : PRINT THE CHARACTER		 *
;*							 *
;*		(AH)=02H : READ	THE PRINTER STATUS	 * 1983/11/7
;*							 *
;*    EXIT  :> SET PRINTER STATUS IS AH	REGISTER	 *
;*							 *
;*		=0	NORMAL END			 *
;*		=1	BUSY (NOT READY)		 *
;*		=2	TIME OUT 			 *
;*		=3	OFFLINE (POWER OFF, NOT SELECT)	 *
;*							 *
;*							 *
;*    USE REGISTER EXPLAN				 *
;*     DS: SYSTEM COMMON AREA BASE			 *
;*     CX: WORK COUNTER					 *
;*     DX: WORK COUNTER					 *
;*							 *
;*********************************************************
	PUSH	CX		; SAVE REGISTER
	MOV	DX,SYSCOM		;--------------NOV/18/83----
	MOV	DS,DX		; SET SYSTEM BASE TO DS REGISTER
	AND	AH,AH 		; CHECK INPUT PARAMATER     1983/11/7
	JZ	PRB_CEN_OUT	; JUMP WRITE DATA (AH=00H)  1983/11/7
	DEC	AH
	JZ	PRB_CEN_INIT	; JUMP PRINTER INITIALIZE (AH=01H) 1983/11/7
	DEC	AH
	JNZ	PRB_CEN_NOP
	CALL	PRB_CEN_STS	; CALL READ STATUS (AH=02H) 1983/11/7
;
PRB_CEN_END:
	POP	CX		; RECOVER REGISTER
	RET
PRB_CEN_NOP:
	XOR	AH,AH		; SET NO OPERATION STATUS
	JMP     PRB_CEN_END
	PAGE
PRB_CEN_INIT:
	;---------------------------------------;
	;					;
	;	PRINTER	INITIALIZE		;
	;	      (AH)=01H	       		;	1983/11/7
	;	INPUT	NONE			;
	;					;
	;	OUTPUT	AH	=0,NORMAL END	;
	;			=1,BUSY		;
	;					;
	;			=3,OFFLINE	;
	;	BREAK	AL,CX			;
	;					;
	;					;
	;---------------------------------------;

	MOV	AL,PR_MSK_ON	; PORT_C6 MASK ON !
	OUT	SYS_PORT,AL	; 
	MOV	AL,PRCEN_MOD	; SET 8255A INITIALIZE SIGNAL
	OUT	PR_MODE,AL	; 8255A	PORTC MODE SET
;-----------------------------------------------------INS NOV/18/83-
	MOV	CX,3
	LOOP	$
	MOV	AL,PRCEN_INTON
	OUT	PR_WSIG,AL
	MOV	CX,16000
	TEST	BYTE PTR [BIOS_FLAG],80H
	JNZ	PRB_CEN_DELAY
	MOV	CX,10000
PRB_CEN_DELAY:
	LOOP	$
	MOV	AL,PRCEN_INTOFF
	OUT	PR_WSIG,AL
	MOV	CX,3
	LOOP	$
;---------------------------------------------------------------------
	MOV	AL,PRCEN_STBON
	OUT	PR_WSIG,AL
	MOV	AL,PR_MSK_OFF	; PORT-C6 MASK OFF !
	OUT	SYS_PORT,AL
	CALL	PRB_CEN_STS
	JMP     PRB_CEN_END
	PAGE
PRB_CEN_OUT:
	;---------------------------------------;
	;					;
	;	WRITE DATA FROM	PRINTER		;
	;	      (AH)=00H	       		;	1983/11/7
	;    RETRY COUNT IS 4 SEC		;
	;					;
	;	INPUT	AL=OUTPUT CHARACTER	;
	;					;
	;	OUT                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
	JNZ	PRB_CEN_RTRY
	MOV	AH,02H		; SET TIME OUT STATUE	1983/11/7
	JMP     PRB_CEN_END
PRB_CEN_PUT:
	OUT	PR_DATA,AL	; PRINT	THE CHARACTER
	MOV	AL,PRCEN_STBOFF	; SET STROB LOW
	OUT	PR_WSIG,AL	; WRITE	STROB (LOW)
	MOV	AL,PRCEN_STBON	; SET STROB HIGH
	OUT	PR_WSIG,AL	; WRITE	STROB (HIGH)
	JMP     PRB_CEN_END
	PAGE
PRB_CEN_STS:
	;---------------------------------------;
	;					;
	;       READ THE	PRINTER	STATUS	;
	;	     (AH)=02H			;	1983/11/7
	;					;
	;---------------------------------------;
	XCHG	AH,AL		; SAVE AL REGISTER
	IN	AL,PR_RSIG	; READ PRINTER STATUS
	TEST	AL,80H
	JNZ	PRB_CEN_STS90
	TEST	AL,04H
	JZ	PRB_CEN_STS70
	MOV	AL,0		;---------------------NOV/18/83----
PRB_CEN_STS40:
	XCHG	AH,AL		; RECOVER AL REGISTER
	RET
				; SET PRINTER STATUS (AH)
PRB_CEN_STS70:
	MOV	AL,1
	JMP	PRB_CEN_STS40
PRB_CEN_STS90:
	MOV	AL,3
	JMP	PRB_CEN_STS40
	PAGE
PRN_ODA:
;*********************************************
;*					     *
;*	   << ODA PRINTER PROCESS >>	     *
;*					     *
;*********************************************
	CMP	AH,03H		; ASSIGNATION PRINTER LIO ?  1983/11/7
	JE	PRL_ODA		; YES,
	JMP	PRB_ODA		; JUMP ODA BIO ROUTINE
PRL_ODA:
;*********************************************************
;*							 *
;*							 *
;*	      << ODA PRINTER LIO ROUTINE >>		 *
;*							 *
;*	SUPPORT	PRINTER	IS ODA PRINTER			 *
;*	WRITE DATA WITH	"N" BYTE CHARACTER TO PRINT	 *
;*							 *
;*     ENTRY :>	PRINTER	LIO FROM BASIC INTERREPTER	 *
;*							 *
;*	       (CX) : PRINT DATA LENGTH			 *
;*	       (BX) : DATA BUFFER ADDRESS		 *
;*	       (ES) : DATA BUFFER SEGMENT ADDRESS	 *
;*							 *
;*     EXIT :> BASIC INTERREPTER FROM PRINTER LIO	 *
;*	      RETURN WITH (AH) SET WITH	END STATUS	 *
;*							 *
;*	       (AH)=02 : TIME OUT ERROR			 *
;*		   =03 : MEDIA LOW STATE		 *
;*		   =62 : PRINTER POWER OFF		 *
;*		   =63 : PRINTER NOT READY		 *
;*		   =64 : PRINTER HARD ERROR		 *
;*		   =00 : NORMAL END                      *
;*							 *
;*							 *
;*     ABNORMAL EXIT :> RETURN STATUS NOT = 00H		 *
;*							 *
;*		   (BX)	: OUTPUT LAST ADDRESS		 *
;*		   (CX)	: REMAINING DATA LENGTH		 *
;*							 *
;*********************************************************
	XOR	AH,AH		; SET NORMAL STATUS
	JCXZ	PRL_ODA_END
PRL_ODA_WR:
	MOV	AH,00H		; SET DATA OUTPUT FUNCTION  1983/11/7
	MOV	AL,ES: [BX]	; SET WRITE CHARACTER
	CALL	PRB_ODA		; CALL PRINTER BIO ROUTINE
	TEST	AH,10H		; POWER	ON <AH(4) ON ?>
	JZ	PRL_ODA_DCN	; NO,
	TEST	AH,40H		; HARD ERROR <AH(6) ON ?>
	JNZ	PRL_ODA_ALM	; YES,
	TEST	AH,80H		; SELECT STATE <AH(7) ON ?>
	JZ	PRL_ODA_NR	; NO,
	TEST	AH,20H		; MEDIA	LOW STATE <AH(5) ON?>
	JNZ	PRL_ODA_MDL	; YES,
	TEST	AH,02H		; TIME OUT <AH(1) ON ?>
	JNZ	PRL_ODA_TIME	; YES,
	INC	BX		; SET NEXT DATA	ADDRESS
	LOOP	PRL_ODA_WR
	XOR	AH,AH		; SET NORMAL STATUS
PRL_ODA_END:
	RET
;
;
PRL_ODA_TIME:
	MOV	AH,02H		; SET TIME OUT ERROR STATUS
	RET
;
PRL_ODA_MDL:
	TEST	AH,01H		; DATA PUT ?
	JZ	PRL_ODA_MDL1	; NO,
	XOR	AH,AH		; SET NORMAL STATUS
	INC	BX
	DEC	CX
	JZ	PRL_ODA_END	; REMAINING LENGTH NOT = 0  (JUMP)
PRL_ODA_MDL1:
	MOV	AH,03H		; SET MEDIA LOW	STATUS
	RET
;
PRL_ODA_DCN:
	MOV	AH,62H		; SET POWER OFF	STATUS
	RET
;
PRL_ODA_NR:
	MOV	AH,63H		; SET NOT READY	STATUS
	RET
;
PRL_ODA_ALM:
	MOV	AH,64H		; SET HARD ERROR STATUS
	RET
	PAGE
PRB_ODA:
;*********************************************************
;*							 *
;*	       << ODA PRINTER BIO ROUTINE >>		 *
;*							 *
;*	  THIS ROUTINE PROVIDES	COMMUNICATION WITH	 *
;*	 ODA PRINTER					 *
;*							 *
;*    ENTRY :>						 *
;*		(AH)=01	 : PRINTER INITIALIZE		 *  1983/11/7
;*							 *
;*		(AH)=00	 : WRITE DATA TO PRINTER	 *  1983/11/7
;*		    (AL) : PRINT THE CHARACTER		 *
;*							 *
;*		(AH)=02	 : READ	THE PRINTER STATUS	 *  1983/11/7
;*							 *
;*    EXIT :> SET PRINTER STATUS IS AH REGISTER		 *
;*							 *
;*	    7	6   5	4   3 -	2   1	0		 *
;*							 *
;*	    I	I   I	I     I	    I	I		 *
;*	    I	I   I	I     I	    I	I		 *
;*	    I	I   I	I     I	    I	- 1: RDA	 *
;*	    I	I   I	I     I	    I			 *
;*	    I	I   I	I     I	    - 1: TIME OUT	 *
;*	    I	I   I	I     I				 *
;*	    I	I   I	I     -	UNUSED			 *
;*	    I	I   I	I				 *
;*	    I	I   I	- 1: PRINTER READY		 *
;*	    I	I   I					 *
;*	    I	I   - 1: MEDIA LOW (PAGE END)		 *
;*	    I	I					 *
;*	    I	- 1: PRINTER HARD ERROR			 *
;*	    I						 *
;*	    - 1: ON LINE				 *
;*							 *
;*           USE REGISTER EXPLAN			 *
;*            DS: SYSTEM COMMON AREA BASE ADDRESS	 *
;*	      ES: MEMORY SW BASE ADDRESS		 *
;*	      CX: WORK COUNTER				 *
;*	      DX: WORK COUNTER				 *
;*							 *
;*********************************************************
	ASSUME	DS:SYSCOM,ES:CMOS
	PUSH	ES		; SAVE REGISTER
	PUSH	CX
	PUSH	BX
	MOV	CX,SEG SYSCOM	;---------------------------NOV/16/83--
	MOV	DS,CX		; SET SYSTEM BASE TO DS	REGISTER
	MOV	CX,SEG CMOS	;----------------------------NOV/16/83-
	MOV	ES,CX		; SET MEMORY SW	BASE TO	ES REGISTER
	AND	AH,AH		; CHECK INPUT PARAMATER	   1983/11/7
	JZ	PRB_ODA_OUT	; JUMP WRITE DATA (AH=00H)   1983/11/7
	DEC	AH
	JZ	PRB_ODA_INIT	; JUMP PRINTER INITIALIZE (AH=01H)  1983/11/7
	DEC	AH
	JNZ	PRB_ODA_NOP
	CALL	PRB_ODA_STS	; CALL READ STATUS (AH=02H)  1983/11/7
	JMP     SHORT	PRB_ODA_END
PRB_ODA_NOP:
	XOR	AH,AH		; SET NO OPERATION STATUS
;
PRB_ODA_END:
	POP	BX		; RECOVER REGISTER
	POP	CX
	POP	ES
	RET
	PAGE
PRB_ODA_INIT:
	;---------------------------------------;
	;					;
	;	PRINTER	INITIALIZE		;
	;	      (AH)=01H			;	1983/11/7
	;	INPUT	NONE			;
	;					;
	;	OUTPUT	AH	=0,NORMAL END	;
	;			=1,BUSY		;
	;					;
	;	BREAK	AL,CX			;
	;					;
	;					;
	;---------------------------------------;
	MOV	AL,PRODA_MOD	; SET 8255A INITIALIZE SIGNAL
	OUT	PODA_MOD,AL	; PORT INITIALIZE
	NOP 
	CLI			; DISABLE INTERRUPTION
	IN	AL,INTM_O1	; READ MASK INTERRUPT
	AND	AL,0BFH		; PRINTER MASK RESET
	OUT	INTM_O1,AL	; WRITE	MASK INTERRUPT
	MOV	AL,PRODA_INTE
	OUT	PODA_WSG,AL	; WRITE	INTERRUPTION ENABLE
	STI
	MOV	AL,PRODA_INTON	; SET PRINTER INITIALIZE SIGNAL
	OUT	PODA_WSG,AL	; WRITE	IRT
	MOV	CX,10000	; SET 5MHZ COUNT	
	TEST	BYTE PTR [BIOS_FLAG+1],80H  ; Q. SYSTEM IS 5MHZ
	JZ	PRB_ODA_WAIT	     ; YES,
	MOV	CX,16000	; SET 8MHZ COUNT
;
PRB_ODA_WAIT:
	NOP
	LOOP	PRB_ODA_WAIT	; WAIT TIME IS 40 MSEC
;
	MOV	AL,PRODA_INTOFF	; SET IRT RESET	SIGNAL
	OUT	PODA_WSG,AL	; RESET	IRT
	MOV	AL,PRODA_RMS	; SET RMS SIGNAL
	OUT	PODA_WSG,AL	; OUTPUT RMS
	AND	RS_SIFT,0FEH	; SET SI STATE
	CALL	PRB_ODA_STS
	JMP     SHORT	PRB_ODA_END
	PAGE
PRB_ODA_OUT:
	;---------------------------------------;
	;					;
	;	WRITE DATA TO PRINTER		;
	;	      (AH)=00H	        	;	1983/11/7
	;					;
	;      (AL) : PRINT THE CHARACTER	;
	;					;
	;      RS_SIFT (0) BIT			;
	;	"OFF" :	PRINTER	IS SIFT	IN	;
	;	"ON"  :	PRINTER	IS SIFT	OUT	;
	;					;
	;      RS_SIFT (1) BIT			;
	;	"OFF" :	SI/SO UNESTABLISHED	;
	;	"ON"  :	SI/SO ESTABLISHED	;
	;					;
	;					;
	;	INPUT	AL=OUTPUT CHARACTER	;
	;					;
	;	OUTPUT	AL	=0,NORMAL END	;
	;			=1,NOT READY	;
	;			=2,TIME OUT	;
	;					;
	;	BREAK	AX,BX,CX,DL		;
	;					;
	;					;
	;---------------------------------------;
	MOV	BX,AX		; SAVE WRITE CHARACTER
	TEST	ES: [PR_TYPE],10H    ; USE JIS 8 CODE ?
	JZ	PRB_ODA_PUTS		     ; YES,
	;
;******	JIS 7 CODE PROCESS ******
	;
	TEST	BL,80H		; SIFT OUT DATA
	JNZ	PRB_ODA_SOCHK	; YES,
	;
	;---- SIFT IN PROCESS ----
	;
PRB_ODA_SICHK:
	TEST	RS_SIFT,02H	; SI/SO	CODE ESTABLISHED ? <(1)	ON?>
	JZ	PRB_ODA_SIDATA	; NO,
	TEST	RS_SIFT,01H	; PRINTER IS SI	STATE
	JZ	PRB_ODA_PRTY	; YES,
PRB_ODA_SIDATA:
	MOV	AL,PRODA_SI	; SET SIFT IN CODE
	AND	RS_SIFT,0FEH	; SET SIFT IN STATE
	OR	RS_SIFT,02H	; SET SIFT STATE ESTABLISHED FLAG
	JMP     SHORT	PRB_ODA_SIO
	;
	;---- SIFT OUT PROCESS ----
	;
PRB_ODA_SOCHK:
	TEST	RS_SIFT,02H	; SI/SO	CODE ESTABLISHED ? <(1)	ON?>
	JZ	PRB_ODA_SODATA	; NO,
	TEST	RS_SIFT,01H	; PRINTER IS SO	STATE
	JNZ	PRB_ODA_PRTY	; YES,
PRB_ODA_SODATA:
	MOV	AL,PRODA_SO	; SET SIFT OUT CODE
	OR	RS_SIFT,03H	; SET SIFT OUT STATE
				; SET SIFT STATE ESTABLISHED FLAG
	;
	;---- OUTPUT SI/SO CODE	----
	;
PRB_ODA_SIO:
	CALL	PRB_ODA_SENSE	; CALL DATA PUT	SENSE ROUTINE
	TEST	AH,01H		; RDA ON ?  <AH(0) ON ?>
	JNZ     PRB_ODA_EXT11	; YES, ERROR RETURN  1983/11/8
	OUT	PODA_DAT,AL	; WRITE	SI/SO CODE
;
PRB_ODA_PRTY:
	AND	BL,7FH		; CHECK	EVEN BIT ?
	JP	PRB_ODA_PUTS	; YES,
	OR	BL,80H		; SET EVEN PARITY BIT
	;
;******** PRINT	THE CHARACTER ******
	;
PRB_ODA_PUTS:
	MOV	AX,BX		; RECOVER WRITE	CHARACTER
	CALL	PRB_ODA_SENSE	; CALL DATA PUT	SENSE ROUTINE
	TEST	AH,01H		; RDA ON ?  <AH(0) ON ?>
	JNZ 	PRB_ODA_EXT11	; YES, ERROR RETURN  1983/11/8
	OUT	PODA_DAT,AL	; PRINT	THE CHARACTER
	;					;
	;	OUTPUT				;
	;		AH=0	READY		;
	;		AH=1	BUSY		;
	;					;
PRB_ODA_EXT11:
	JMP	PRB_ODA_END
	PAGE
PRB_ODA_SENSE:
	;---------------------------------------;
	;					;
	;	PRINTER	OUTPUT SENSE ROUTINE	;
	;					;
	;	 RETRY COUNT IS 6 SEC		;
	;					;
	;	INPUT	NONE			;
	;					;
	;	OUTPUT				;
	;		AH=0	READY		;
	;		AH=1	BUSY		;
	;		AH=3	TIME OUT	;
	;					;
	;	BREAK	CX,DL			;
	;					;
	;					;
	;---------------------------------------;
	XOR	CX,CX
	MOV	DL,6		; SET 8MHZ COUNT
	TEST	BYTE PTR [BIOS_FLAG+1],80H  ; Q. SYSTEM IS 8MHZ
	JNZ	PRB_SENS_RTRY	     ; YES,
	MOV	DL,4		; SET 5MHZ COUNT
PRB_SENS_RTRY:
	CALL	PRB_ODA_STS
	TEST	AH,01H		; RDA OFF ?  <AH(0) OFF ?>  1983/11/8
	JZ 	PRB_SENS_EXIT	; YES,			    1983/11/8
	LOOP	PRB_SENS_RTRY
	DEC	DL		; DECREMENT DOUBLE COUNTER
	JNZ	PRB_SENS_RTRY
	OR	AH,03H		; SET TIME OUT STATUS
	RET
;
PRB_SENS_DESEL:
	AND	RS_SIFT,NOT 02H	; SET SI/SO UNESTABLISHED <(1) OFF>
PRB_SENS_EXIT:
	CLI
	AND	RS_SIFT,NOT 04H	; RESET	INTERRUPT FLAG
	STI
	RET
	PAGE
PRB_ODA_STS:
	;---------------------------------------;
	;					;
	;	READ THE PRINTER STATUS		;
	;	      (AH)=02H          	;	1983/11/7
	;					;
	;	OUTPUT				;
	;		AH=0	READY		;
	;		AH=1	BUSY		;
	;					;
	;---------------------------------------;
	XCHG	AH,AL		; SAVE AL REGISTER
	IN	AL,PODA_RSG	; READ PRINTER STATUS
	NOT	AL		; INVERT STATUS	BIT
	XCHG	AH,AL		; RECOVER AL REGISTER
	AND	AH,0F0H		; RESET	UNUSED BIT
	TEST	AH,80H		; DESELECT ?  <AH(7) OFF ?>
	JZ	PRB_ODA_STS1	; YES,
	TEST	RS_SIFT,04H	; INTERRUPT CHECK
	JZ	PRB_ODA_STS1
	MOV     AH,00H		; RESET RDA BIT   1983/11/8
	RET					; 1983/11/8
;						  1983/11/8
PRB_ODA_STS1:
	MOV	AH,01H				; 1983/11/8
	RET
	PAGE
;****************************************
;*					*
;*     ODA PRINTER INTERRUPT RUTINE	*
;*					*
;*	  INTERRUPT FLAG = RS_SIFT(2)	*
;*					*
;****************************************
	ASSUME	DS:SYSCOM,ES:USER
PR_INTR:
	PUSH	AX
	PUSH	DS
	MOV	AX,SEG SYSCOM	; SET SYSTEM AREA BASE
	MOV	DS,AX
	OR	RS_SIFT,04H	; SET INTERRUPT	FLAG
	MOV	AL,EOI
	OUT	INTM_O2,AL
	POP	DS
	POP	AX
	IRET
	PAGE
;****************************************************************
;*   COPY INTERRUPT PROC					*
;*			( INT 05H )				:
;*								*
;****************************************************************
HARD_COPY	PROC	NEAR
;-----------------------------------------------INS NOV/26/83-----
	IF	CR EQ 0AH

	MOV	CS:CPY_SAVAX,AX		; SAVE AX
	MOV	CS:CPY_SAVSS,SS		; SAVE SS
	MOV	CS:CPY_SAVSP,SP		; SAVE SP
	MOV	AX,CS
	MOV	SS,AX
	MOV	SP,OFFSET COPY_STACK	; SET LOCAL STACK ADDR
	ELSE
	PUSH	AX
	ENDIF
;-----------------------------------------------------------------
	STI				; ENABLE INTERRUPT
	PUSH	DS
	PUSH	ES
	PUSH	BX
	PUSH	CX
	PUSH	DX
	CMP	AL,0			; CHARACTER DUMP ?---MAR/13/84--
	JNZ	COPY_RET		; N	--------------MAR/13/84--
	MOV	BX,SYSCOM		;------------------NOV/21/83-
	MOV	DS,BX
	TEST	[COPY_FLAG],01H		; COPY MODE ?
	JNE	COPY_RET		; IF ALREADY COPY MODE
	OR	[COPY_FLAG],01H		; ENTER COPY MODE
	CALL	HARD_COPY_PROC		; HARD COPY START
;-----------------------------------------------INC NOV/26/83------
	AND	[COPY_FLAG],NOT 01H	; EXIT COPY MODE
;-----------------------------------------------------------------

COPY_RET:
	POP	DX
	POP	CX
	POP	BX
	POP	ES
	POP	DS
;---------------------------------------------------INS NOV/16/83-
	IF	CR EQ 0AH
	CLI				; DISABLE INTERRUPT
	MOV	AX,CS:CPY_SAVAX
	MOV	SS,CS:CPY_SAVSS
	MOV	SP,CS:CPY_SAVSP
	ELSE
	POP	AX
	ENDIF
;--------------------------------------------------------------------
	IRET
HARD_COPY	ENDP
	PAGE
;****************************************
;*					*
;*   HARD COPY SUBROUTINE		*
;*					*
;*	INPUT	NONE			*
;*					*
;*	OUTPUT	NONE			*
;*					*
;*	BREAK	AX,BX,CX,DX,ES		*
;*					*
;****************************************
HARD_COPY_PROC	PROC	NEAR
;
;
	MOV	AL,CR			; CONTROL CODE (CR)
	MOV	AH,00H
	INT	PRN_ROM			; CARRIAGE RETURN
	MOV	AL,LF			; CONTROL CODE (LF)
	MOV	AH,00H
	INT	PRN_ROM			; CARRIAGE RETURN

	ASSUME	DS:SYSCOM,ES:VRAM
;----------------------------------------------------INC JAN/18/84---
;	MOV	BH,0
	MOV	BL,[ACTIVE_PAGE]
	MOV	CL,12		; PAGE NO * 1000H
	SHL	BX,CL
;	ADD	BX,OFFSET PAGE00
;--------------------------------------------------------------------
	MOV	AX,SEG VRAM
	MOV	ES,AX			; SOURCE SEG.
	MOV	CH,25			; SET STOPPER (25 LINE PRINT)
HCOPY_01:
	CALL	HCOPY_SUB		; PRINT 1 LINE OF TEXT IMAGE
	DEC	CH			; PRINT 25 LINES ? NOV/16/83
	JNZ	HCOPY_01		; NO,
	STI				; ENABLE INTERRUPT
	RET
HARD_COPY_PROC	ENDP
		PAGE
;************************************************
;*						*
;*  PRINT TEXT VRAM IMAGE			*
;*	(1LINE + CR + LF)			*
;*						*
;*	INPUT	ES:BX	VRAM ADDRESS		*
;*						*
;*	OUTPUT	ES:BX	VRAM ADDRESS OF NEXT	*
;*			LINE			*
;*						*
;*	BREAK	CL,DX,AX			*
;*						*
;************************************************
HCOPY_SUB:
	MOV	CL,[CRT_COLS]
;-------------------------------------------------NOV/21/83------
	MOV	DX,2
	CMP	CL,80
	JZ	HCOPY_S1
	MOV	DX,4
;-----------------------------------------------------------------
HCOPY_S1:
	MOV	AL,ES:[BX]		; GET SCREEN DATA
	ADD	BX,DX			; POINTER INCREMENT

	CMP	AL,' '			; CONTROL DATA ?
	JNB	HCOPY_S6		; NO,
	MOV	AL,' '			; CONTROLE CODE --> SET SPACE
HCOPY_S6:
	MOV 	AH,00H
	INT 	PRN_ROM			; 1 CHARACTER OUTPUT
	DEC	CL	;----------------------------NOV/21/83---
	JNZ	HCOPY_S1		; NEXT COLUMN
;
	MOV	AL,CR			; CONTROL CODE (CR)
	MOV	AH,00H
	INT	PRN_ROM			; CARRIAGE RETURN
	MOV	AL,LF			; CONTROL CODE (LF)
	MOV	AH,00H
	INT	PRN_ROM			; LINE FEED
HCOPY_SRET:
	RET
	PAGE
;************************************************
;*	HARD COPY WORK AREA			*
;************************************************
;--------------------------------------------CHG NOV/16/83-------
	IF	CR EQ 0AH
CPY_SAVAX	DW	?		; AX SAVE
CPY_SAVSS	DW	?		; SS SAVE
CPY_SAVSP	DW	?		; SP SAVE
;
		DW	32 DUP(0)	; LOCAL STACK
COPY_STACK	EQU	$
	ENDIF
;-----------------------------------------------------------------
ROM 	ENDS
	END
;

