	PAGE	60,132
	TITLE	'A1BIOS'
;************************************************************************
;*									*
;*	MS-DOS 2.0 INTERFACE PROGRAM					*
;*									*
;*		THIS PROGRAM IS CALLED FROM MS-DOS PROGRAM WHEN NEED 	*
;*		HANDLE A DRIVE.						*
;*		AT FIRST CALLED STRATEGY.				*
;*		NEXT CALLED INTERRUPT.					*
;*									*
;*	PARAMETER							*
;*									*
;*		ES:BX	PACKET ADDRESS					*
;*									*
;************************************************************************
;	MAR/16/84
;	MAR/27/84
;	APR/17/84
;	JUN/02/84	; EXCHANGE STACK TO LOCAL AREA IN PROGRAM
;	JLY/27/84	DELETE AUX2

;************************************************
;*	EXTERNAL SYMBOL AND LABEL		*
;************************************************
	EXTRN	CON_INT:NEAR		; CONSOLE DRIVE ENTRY POINT
	EXTRN	AUX_INT:NEAR		; AUX     DRIVE ENTRY POINT
	EXTRN	PRN_INT:NEAR		; PRINTER DRIVE ENTRY POINT
	EXTRN	CLK_INT:NEAR		; CLOCK   DRIVE ENTRY POINT
	EXTRN	FD_DSK_INT:NEAR		; FLOPPY DISK DRIVE ENTRY POINT
	EXTRN	HD_DSK_INT:NEAR		; HARD   DISK DRIVE ENTRY POINT
	EXTRN	RAM_DSK_INT:NEAR	; RAM    DISK DRIVE ENTRY POINT

	EXTRN	INIT:NEAR		; DRIVERS INITIALIZE PROGRAM

	EXTRN	FD_DCB_TBL:NEAR		; DEVICE CONTROL BLOCK FOR FD
	EXTRN	CON_DCT:WORD
	EXTRN	AUX_DCT:WORD
	EXTRN	PRN_DCT:WORD
	EXTRN	CLK_DCT:WORD
		PAGE
CODE	SEGMENT	WORD PUBLIC 'CODES'
	ASSUME	CS:CODE

;****************************************
;*	GLOBAL SYMBOL AND LABEL		*
;****************************************
	PUBLIC	ENTRY
	PUBLIC	COMMON_EXIT
	PUBLIC	NORMAL_EXIT
	PUBLIC	CMDERR_EXIT
	PUBLIC	BUSY_EXIT
	PUBLIC	ERROR_EXIT

	PUBLIC	PTRSAV
	PUBLIC	DEV_TBL
	PUBLIC	FD_DSK_DEV
	PUBLIC	HD_DSK_DEV
	PUBLIC	RAM_DSK_DEV
	PUBLIC	AUX_WORK

	PUBLIC	MEM_SW1
	PUBLIC	MEM_SW2
	PUBLIC	MEM_SW3
	PUBLIC	MEM_SW4
	PUBLIC	MEM_SW5
	PUBLIC	MEM_SW6
	PUBLIC	MEM_SW7
		PAGE
;****************************************
;*	EQUATE TABLE			*
;****************************************

BIOSSEG	EQU	0060H				;BIOS SEGMENT

;****************************************
;*	STRUCTURE TABLE			*
;****************************************
IODAT	STRUC
CMDLEN	DB	?				;LENGTH OF COMMAND
UNIT	DB	?				;SUB UNIT SPECIFIER
CMD	DB	?				;COMMAND CODE
STATUS	DW	?				;STATUS
	DB	8 DUP(?)
MEDIA	DB	?				;MEDIA DESCRIPTOR
TRANS	DD	?				;TRANSFER ADDRESS
COUNT	DW	?				;COUNT OF BLOCKS OR CHARACTERS
START	DW	?				;FIRST BLOCK TO TRANSFER
IODAT	ENDS
	PAGE
	ORG	0
START_ORIGIN	LABEL	NEAR
;************************************************
;*	PROGRAM INITIALIZE JUMP POINT		*
;************************************************
	JMP	INIT			;INITIALIZE
;************************************************
;*	MS-DOS COMMON AREA			*
;************************************************
MSDOS_VER	DB	"2"		; IO.SYS OF MS-DOS VERSION APR/17/84

		ORG	START_ORIGIN + ( ($-START_ORIGIN+7) AND 0FFF8H)

;
;	MEMORY SWITCH 1-8
;
MEM_SW1		DB	0		; MODE INSTRUCTION XON/XOFF ENABLE OF AUX
MEM_SW2		DB	0		; BAUD RATE OF AUX AND AUX2
MEM_SW3		DB	0		; MEMORY,8087,PRINTER BITS,DEFAULT COLOR OF CRT
MEM_SW4		DB	0		; MODE INSTRUCTION, XON/XOFF ENABLE OF AUX2
MEM_SW5		DB	0		; PRINTER INTERFACE,RAM DISK,BOOT DISK
MEM_SW6		DB	0		; PRINTER TYPE AND PARITY
MEM_SW7		DB	0		; RESEARVE
MEM_SW8		DB	0		; YEAR

;
;	DRIVER WORK AREA ADDRESS
;
CON_WORK 	DD	CON_DCT
AUX_WORK 	DD	AUX_DCT
PRN_WORK 	DD	PRN_DCT
CLK_WORK 	DD	CLK_DCT
FD_DSK_WORK 	DD	FD_DCB_TBL
		DD	-1		; FUTURE USE
		DD	-1
CONF_PNT	DD	CONF_TBL
;

	ORG	START_ORIGIN + ( ($-START_ORIGIN+0FH) AND 0FFF0H )
		PAGE
;
;	DEVICE	TABLE
;
DEV_TBL	LABEL	WORD
CON_DEV:					;HEADER 'CON'
	DD	AUX_DEV				;LINK TO NEXT DEVICE
	DW	8013H				;ATTRIBUTE (CHR.I/O)
		; +----------------------------- INT 29H SUPPORT
	DW	STRATEGY			;STRATEGY ENTRY POINT
	DW	CON_INT				;INTERRUPT ENTRY POINT
	DB	'CON     '			;DEVICE NAME

AUX_DEV:					;HEADER 'AUX'
	DD	PRN_DEV				;---CHG JLY/27/84
	DW	8000H				;	(CHR.)
	DW	STRATEGY
	DW	AUX_INT
	DB	'AUX     '

AUX2_DEV:					;HEADER 'AUX2'
	DD	PRN_DEV
	DW	8000H				;	(CHR.)
	DW	STRATEGY
	DW	AUX_INT
	DB	'AUX2    '

PRN_DEV:					;HEADER 'PRN'
	DD	CLK_DEV
	DW	8000H				;	(CHR.)
	DW	STRATEGY
	DW	PRN_INT
	DB	'PRN     '

CLK_DEV:					;HEADER 'CLOCK'
	DD	FD_DSK_DEV
	DW	8008H				;	(CHR.CLOCK)
	DW	STRATEGY
	DW	CLK_INT
	DB	'CLOCK   '

FD_DSK_DEV:					;HEADER 'FLOPPY DISK'
	DD	HD_DSK_DEV
	DW	0000H				; IBM COMPATIBLE DISK
	DW	STRATEGY
	DW	FD_DSK_INT
	DB	2				; FD UNIT NO.
	DB	7 DUP(0)
;
HD_DSK_DEV:					; HEADER 'HARD DISK'
	DD	RAM_DSK_DEV
;----------------------------------------------------------------05/23/1984----
	DW	0000H				; IBM COMPATIBLE DISK
;------------------------------------------------------------------------------
	DW	STRATEGY
	DW	HD_DSK_INT
	DB	2				; HD UNIT NO.
	DB	7 DUP(0)
;
RAM_DSK_DEV:					; HEADER 'RAM  DISK'
	DD	-1
	DW	2000H				; IBM NON COMPATIBLE DISK
	DW	STRATEGY
	DW	RAM_DSK_INT
	DB	1				; UNIT NO.
	DB	7 DUP(0)
;
;****************************************
;*					*
;*	CONFIGRATION TABLE		*
;*					*
;****************************************
CONF_TBL	DD	8 DUP (-1)	; RESEARVE
;
;************************************************
;*						*
;*	WORK AREA				*
;*						*
;************************************************
PTRSAV		DD	0			; PACKET POINT SAVE

;---------------------------------------------------INSERT JUN/02/84---
		EVEN
SPSAVE		DW	?
SSSAVE		DW	?

		DW	100 DUP (?)		; LOCAL STACK AREA
LOCAL_SP	LABEL	WORD
;----------------------------------------------------------------------
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	STRATEGY			*
;*							*
;*	FUNCTION	SAVE PACKET TABLE ADDRESS	*
;*							*
;*	INPUT		ES:BX = PACKET ADDRESS		*
;*							*
;*	OUTPUT		NONE				*
;*							*
;********************************************************
STRTUP	PROC	FAR
STRATEGY:
	MOV	WORD PTR CS:[PTRSAV],BX
	MOV	WORD PTR CS:[PTRSAV+2],ES
	RET
STRTUP	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	ENTRY				*
;*							*
;*			NORMAL_EXIT			*
;*			BUSY_EXIT			*
;*			CMDERR_EXIT			*
;*			ERROR_EXIT			*
;*							*
;*	FUNCTION	GET PARAMETER FROM PACKET TABLE	*
;*			TO REGISTER.			*
;*			BRANCH ANY MODULE BY DISPATCH	*
;*			TABLE.				*
;*			SET STATUS TO PACKET.		*
;*			RETURN TO DOS.			*
;*							*
;*	INPUT		SI:DISPATCH TABLE ADDRESS	*
;*							*
;*	OUTPUT		NONE				*
;*							*
;*	REMARK		SAVE SI REGISTER TO STACK	*
;*			BEFORE JUMPED			*
;*							*
;********************************************************
;
;COMMON ROUTINE FOR INTERRUPT
;
INTERRUPT	PROC	FAR
ENTRY		LABEL	NEAR
;---------------------------------------------------INSERT JUN/02/84---
	MOV	CS:[SSSAVE],SS
	MOV	CS:[SPSAVE],SP			; SAVE STACK
	PUSH	CS
	POP	SS
	MOV	SP,OFFSET LOCAL_SP
;----------------------------------------------------------------------
	PUSH	AX				;SAVE ALL REGISTERS
	PUSH	CX
	PUSH	DX
	PUSH	DI
	PUSH	BP
	PUSH	DS
	PUSH	ES
	PUSH	BX
	LDS	BX,CS:[PTRSAV]			;RETRIEVE POINTER (DS:BX)
	MOV	AL,[BX.UNIT]			;GET UNIT
	MOV	AH,[BX.MEDIA]			;GET MEDIA
	MOV	CX,[BX.COUNT]			;GET BYTE/SECTOR COUNT
	MOV	DX,[BX.START]			;GET LOGICAL SECTOR
	XCHG	AX,DI				;SAVE AX
	MOV	AL,[BX.CMD]			;GET COMMAND
	XOR	AH,AH
	ADD	SI,AX
	ADD	SI,AX
	CMP	AL,12
	JA	CMDERR_EXIT
	XCHG	AX,DI				;RESTORE AX
	LES	DI,[BX.TRANS]			;GET I/O BUFFER ADDRESS (ES:DI)
	PUSH	CS
	POP	DS				;DS <- CS
	JMP	[SI]				;PERFORM I/O PACKET COMMAND
	PAGE
;
;*	BUSY END
;
BUSY_EXIT:
	MOV	AH,00000011B			;SET BUSY & DONE BITS
	JMP	SHORT COMMON_EXIT

;
;*	COMMAND ERROR END
;
CMDERR_EXIT:
	MOV	AL,3				;SET UNKNOWN COMMAND ERROR

;
;*	ANY ERROR END
;
ERROR_EXIT:
	MOV	AH,10000001B			;SET ERROR & DONE BITS
	JMP	SHORT COMMON_EXIT

;
;*	READY/NORMAL END
;
NORMAL_EXIT:
	MOV	AH,00000001B			;SET DONE BIT
;
;*	EXIT POINT
;
COMMON_EXIT:
	LDS	BX,CS:[PTRSAV]
	MOV	[BX.STATUS],AX
	POP	BX
	POP	ES
	POP	DS
	POP	BP
	POP	DI
	POP	DX
	POP	CX
	POP	AX
;----------------------------------------------------INSERT JUN/02/84--
	MOV	SS,CS:[SSSAVE]
	MOV	SP,CS:[SPSAVE]
;----------------------------------------------------------------------
	POP	SI
	RET
INTERRUPT	ENDP

CODE	ENDS
	END
