****	CAPS -- Capitalize Character
**
**	Function:
**		Capitalize the ASCII character in D1.b if it is a
**		lower-case alphabetic (a-z); otherwise return unchanged.
**		Only the lower 7 bits are considered.  The most
**		significant bit is cleared.
**	Inputs:  D1.b == character to capitalize
**	Outputs: D1.b == capitalized character
**	Registers affected:  D1.b
**	Routines called: -none-
**	Special error conditions: -none-
*
	.globl	caps
	.text
caps:
	andi.b	#$7f,d1		* mask off sign bit
	cmpi.b	#'a',d1
	blt	capsx		* not a-z
	cmpi.b	#'z',d1
	bgt	capsx		* not a-z
	andi.b	#$5f,d1		* a-z ==> A-Z
*
capsx:	rts
	.end
