****	OPTSCN -- options scanner
**
**	Function:
**		Scan command line for options and set flags in option table
**	Inputs:	D0.l == pointer to command line (assumed capitalized)
**		D1.l == pointer to options table
**		D2.l == pointer to input FCB (0 indicates none)
**		D3.l == pointer to output FCB (0 indicates none)
**	Outputs: D0.l == pointer to end of parsed command line (+1)
**	Registers affected: D0.l, ( options table )
**	Routines called:  OPTSET, MAKEFCB
**	Special error conditions: D1.l=0 implies error in options.
**			Error msg printed to CON: if:
**				o bad delimiter on line
**				o bad file name
**				o input re-direct not allowed
**				o output re-direct not allowed
*
**			last mod: 14feb85 jmk /make ptr into longword/
*
*
	.globl	optscn
	.globl	optset
	.globl	makefcb
	.text
optscn:
	move.l	a0,-(a7)
	move.l	d1,-(a7)
	move.l	d0,a0		* ptr to line
*
optsc1:	move.b	(a0)+,d0
	cmpi.b	#0,d0
	beq	optscx		* end of line
	cmpi.b	#' ',d0
	beq	optsc1		* ignore blanks
	cmpi.b	#'-',d0
	beq	optsco		* option flag
	cmpi.b	#'$',d0
	beq	optsco		* alternate option flag
	cmpi.b	#'*',d0		* test for wildcard
	beq	optsc2		* treat as A-Z (filespec)
	cmpi.b	#'<',d0
	beq	optinr		* input re-direct
	cmpi.b	#'>',d0
	beq	optotr		* output re-direct
	cmpi.b	#'A',d0
	blt	opterm		* bad character
	cmpi.b	#'Z',d0
	bgt	opterm		* bad character
*
**	it's a file name
*
optsc2:	move.l	d2,d1		* file FCB
	beq	optfne		* hey, not legal
	move.l	a0,d0
	subq.l	#1,d0		* pointer to beginning of name
	jsr	makefcb		* make file name into FCB
	move.l	d0,a0
	tst.l	d1
	bne	optsc1		* no problem
optfne:	move.l	#bdfnm,d1
	bra	opter1
*
*
optinr:	move.l	d3,d1		* ptr to input fcb
	beq	optie		* hey, not legal
	move.l	a0,d0
	jsr	makefcb
	move.l	d0,a0
	tst.l	d1
	bne	optsc1		* no problem
optie:	move.l	#bdinf,d1
	bra	opter1
*
*
optotr:	move.l	d4,d1		* prt to output fcb
	beq	optoe		* hey, not legal
	move.l	a0,d0
	jsr	makefcb
	move.l	d0,a0
	tst.l	d1
	bne	optsc1		* no problem
optoe:	move.l	#bdotf,d1
	bra	opter1
*
*
optsco:	move.l	a0,d0		* option pointer
	move.l	(a7),d1		* table pointer
	jsr	optset
	move.l	d0,a0
	tst.l	d1
	beq	opterr		* if bad option
	bra	optsc1
*
*
opterm:	subq.l	#1,a0		* point to bad character
opterr:				* A0.L points to bad option
	move.b	(a0),optbd
	move.l	#optdm,d1
opter1:	moveq	#9,d0
	trap	#2		* print error msg
	clr.l	(a7)		* return error
*
optscx:	move.l	(a7)+,d1
	move.l	a0,d0		* pointer to end of line
	move.l	(a7)+,a0
	rts
*
*
	.data
cr:	.equ	13
lf:	.equ	10
*
optdm:	.dc.b	'   Illegal option [x]',cr,lf,'$'
optbd:	.equ	optdm+19
*
bdfnm:	.dc.b	'  Bad file spec.',cr,lf,'$'
bdinf:	.dc.b	'  Illegal input re-direct',cr,lf,'$'
bdotf:	.dc.b	'  Illegal output re-diredt',cr,lf,'$'
*
*
	.end
