/* -*-c,save-*- */
/*
 * poker.c - poker program
 * Robert Heller. Created: Sun Mar 9, 1986 19:27:33.69
 * Last Mod: 
 * 
 * (c) Copyright 1986 by Robert Heller
 *     All Rights Reserved
 * 
 * 
 */
#include <stdio.h>
#include "phrase.h"

#define LOCAL static

/* #define DEBUG /* debugging */

#ifdef DEBUG
#define LOCAL /* static */
#endif

LOCAL float alpha(l)
register float l;
{
    register float t,r;
    float sqrt(),square();

    t = 1.0 + 2.0 * l;
    r = -(t + 1.0) + sqrt(square(t)+6.0*t+1.0);
    return(r/(2.0*t));
    }
LOCAL float beta(l)
register float l;
{
    register float t,r;
    float sqrt(),square();

    t = 1.0 + 2.0 * l;
    r = -square(t) + 2.0 * t + 1.0 + (t - 1.0) * 
	 sqrt(square(t) + 6.0 * t + 1.0);
    return(r/(2.0 * square(t)));
    }
LOCAL float square(n)
register float n;
{
    return(n * n);
    }
LOCAL float ALPHA,BETA,A,B,C,D,R;
LOCAL float abcdr(l)
register float l;
{
    register float theta,phi,tau,ttr;

    ALPHA = alpha(l);
    BETA = beta(l);
    phi = l / (1.0 + 2.0 * l);
    theta = 1.0 - phi;
    tau = 1.0 + 2.0 * l;
    R = l / (1.0 + l);
    ttr = tau * theta / R;
    A = -1.0 + 2.0 * phi + ALPHA + ttr * (4.0 * phi + 2.0 * ALPHA);
    A = A / (tau * theta + ALPHA + ttr * (2.0 * ALPHA + 1.0));
    B = 4.0 * phi + 2.0 * ALPHA - (2.0 * ALPHA + 1.0) * A;
    C = 2.0 * phi + ALPHA - A * ALPHA;
    D = R * (1.0 + ALPHA) - R * ALPHA;
    }
LOCAL float L;
LOCAL int POT,HIM;
LOCAL bet()
{
    register int result;
    register long int temp;
    register float t2;

    temp = POT;
    t2 = (FLOAT) temp;
    t2 *= L;
    temp = (long int) t2;
    result = (int) temp;
    if (result > HIM) result = HIM;
    return(result);
    }
main()
{
    int l1,ante,mante;
    char scratch[512],hx[6],hy[6];
    float pokev();
    register int status,_bet;
    register float x,y,raise,call;

    que_init(); card_ini(); pok_ini();
    printf("Welcome to Cold-hand Poker\n\n");
    if (quest("Would you like to know the rules/(yes)1|(YES)1|(no)0|(NO)0") ==
	1) instr();
    srand(gettime());
    HIM = (rand() % 100) + 20;
    printf("We'll start you off with %d chips\n",HIM);
NEWP:
    quest("Bet limit (% of pot)/0(10...1000)",&l1);
    L = ((float) l1) / 100.0;
    abcdr(L);
    mante = (int) (((1.0 / L) / 2.0) + .9999999);
    ante = 999;
START:
    if (mante > HIM) goto CANT_ANTE;
    if (ante > HIM) {
	sprintf(scratch,"What's the ante/0(%d...%d)",mante,HIM);
	quest(scratch,&ante);
	}
    POT = ante * 2;
    HIM -= ante;
    printf("With a %d chip ante the pot has %d chips\n",ante,POT);
    rhand(5,hx,TRUE);
    x = pokev(hx);
    rhand(5,hy,FALSE);
    y = pokev(hy);
    display(hx,scratch);
    printf("You are dealt %s\n",scratch);

    raise = (1.0 - A) * ALPHA;
    call = (1.0 - D);
    if (quest("Would you like to bet (B) or check (-)/(B)0|(b)0|(-)1") == 0)
	goto HE_BETS;
HE_CHECKS:
    letmesee(scratch);
    prblk(scratch);
    if ( ((1.0 - C) * R) <= y && y < C) {
I_CHECK:
	printf("I'll check too\n");
	goto COMPARE;
	}
I_BET:
    _bet = bet();
    if (_bet == 0) goto CANT_BET;
    POT += _bet;
    printf("I guess I'll bet %d chips\n",_bet);
    printf("The pot now has %d chips\n",POT);
    status = quest("How about you, call(C) or fold(F)/(C)0|(c)0|(F)1|(f)1");
    if (status == 1) goto I_WIN;
HE_CALLS:
    POT += _bet;
    HIM -= _bet;
    printf("The pot now has %d chips\n",POT);
    goto COMPARE;
HE_BETS:
    _bet = bet();
    if (_bet == 0) goto CANT_BET;
    POT += _bet;
    HIM -= _bet;
    printf("You bet %d chips\n",_bet);
    printf("The pot now has %d chips\n",POT);
    letmesee(scratch);
    prblk(scratch);
    if (y > (1.0 - raise)) goto I_RAISE;
    if (y > (1.0 - call)) goto I_CALL;
    if (y < (R * raise)) goto I_RAISE; else goto I_FOLD;
I_RAISE:
    printf("I'll see your %d chips\n",_bet);
    POT += _bet;
    _bet = bet();
    if (_bet == 0) goto CANT_BET;
    printf("and raise you %d chips\n",_bet);
    POT += _bet;
    printf("The pot now has %d chips\n",POT);
    switch(quest("You must now raise(R), call(C), or fold(F)/(R)0|(r)0|(C)1|(c)1|(F)2|(f)2")) {
	case 0: goto HE_RAISES;
	case 1: goto HE_CALLS;
	case 2: goto I_WIN;
	}
HE_RAISES:
    printf("You call my %d chips and\n",_bet);
    HIM -= _bet;
    POT += _bet;
    call = raise * BETA;
    raise = raise * ALPHA * ALPHA;
    goto HE_BETS;
I_CALL:
    printf("OK, I call\n");
    POT += _bet;
    goto COMPARE;
CANT_BET:
    printf("Since you have no money left we have to stop here\n");
COMPARE:
    display(hy,scratch);
    printf("Let's see, I have %s\n",scratch);
    if (x > y) goto HE_WINS;
I_WIN:
    printf("I guess I take all %d chips in the pot\n",POT);
    insult(scratch);
    prblk(scratch);
    goto SUMMARY;
I_FOLD:
    printf("I fold\n");
HE_WINS:
    HIM += POT;
    printf("You win the %d chips in the pot\n",POT);
    praise(scratch);
    prblk(scratch);
SUMMARY:
    printf("You now have %d chips\n",HIM);
    if (HIM == 0) {
	printf("So long\n");
	exit();
	}
    status = 
quest("Same game (S), new parameters (N) or quite while you are ahead (Q)/(s)0|(S)0|(N)1|(n)1|(q)2|(Q)2");
    if (status == 0) goto START;
    else if (status == 2) goto HE_QUITS;
    else goto NEWP;
CANT_ANTE:
    printf("You don't have enough chips to ante up.\n");
HE_QUITS:
    printf("Ok, you have %d chips, which are not redeamable...\n",HIM);
    if (HIM > 0) priou(HIM);
    }
LOCAL prblk(s)
register char *s;
{
    register int len;

    len = 0;
    while (*s != '\0') {
	if (*s <= ' ' && len > 60) {
	    putchar('\n');
	    while (*s > '\0' && *s <= ' ') s++;
	    len = 0;
	    }
	if (*s != '\0') {
	    putchar(*s);
	    len++;
	    s++;
	    }
	}
    if (len > 0) putchar('\n');
    }
LOCAL instr()
{
    printf("\n    Cold Hand Poker\n\n");
    printf("    In Cold Hand Poker you and the dealer (the computer) ante\n");
    printf("up and are each dealt 5 cards.  You and the dealer then bet\n");
    printf("on your cards.  You get to bet first.  You can check (bet\n");
    printf("nothing), if you don't think your hand is worth betting on.\n");
    printf("The dealer can then meet your bet (call), fold (give up) or\n");
    printf("raise (meet your bet and bet more).  If the dealer raises,\n");
    printf("you can call (meet the dealer's bet), raise (meet the\n");
    printf("dealer's bet and bet more) or fold (give up).  After the\n");
    printf("betting is over, the hands are compared (unless either\n");
    printf("you or the dealer folds), and the one with the better\n");
    printf("hand gets the pot.  If you fold, the dealer gets the\n");
    printf("pot and if the dealer folds, you get the pot.\n\n");
    printf("     After each hand you can play again with the same\n");
    printf("parameters, play with new parameters or quit while you\n");
    printf("are ahead.  The game will also end when you run out of\n");
    printf("chips.\n\n");
    quest("Press RETURN to continue/(ARB)");
    printf("\n     Parameters:\n\n");
    printf("     There are two parameters controlling play: the bet\n");
    printf("limit and the ante.  The bet limit is the percentage of\n");
    printf("pot to bet each round and the ante is the starting bet\n");
    printf("needed to enter the game.\n\n");
    printf("          GOOD LUCK!!!\007\007\007\007\n\n");
    }
priou(chips)
register int chips;
{
    FILE *fopen();
    register FILE *printer;
    register int i,len;
    char amt[10];
    register char *p;

    printer = fopen("LST:","w");
    fprintf(printer,"\033\034");
    for (i=0;i<20;i++) fprintf(printer,"\n\n");
    len = 20;
    for (i=1;i<10;i++) fputc(' ',printer);
    fputc(0x00eb,printer);
    for (i=1;i<50;i++) fputc(0x00e7,printer);
    fputc(0x00ec,printer);
    fputc('\n',printer);
    for (i=1;i<10;i++) fputc(' ',printer);
    fputc(0x00e9,printer);
    for (i=1;i<50;i++) fputc(' ',printer);
    fputc(0x00ea,printer);
    fputc('\n',printer); len++;
    for (i=1;i<10;i++) fputc(' ',printer);
    fputc(0x00e9,printer);
    for (i=1;i<50;i++) fputc(' ',printer);
    fputc(0x00ea,printer);
    fputc('\n',printer);
    for (i=1;i<10;i++) fputc(' ',printer);
    fputc(0x00e9,printer);
    for (i=1;i<50;i++) fputc(' ',printer);
    fputc(0x00ea,printer);
    fputc('\n',printer); len++;
    for (i=1;i<10;i++) fputc(' ',printer);
    fputc(0x00e9,printer);
    fprintf(printer,"=================Cold-Hand Poker=================");
    fputc(0x00ea,printer);
    fputc('\n',printer);
    for (i=1;i<10;i++) fputc(' ',printer);
    fputc(0x00e9,printer);
    for (i=1;i<50;i++) fputc(' ',printer);
    fputc(0x00ea,printer);
    fputc('\n',printer); len++;
    for (i=1;i<10;i++) fputc(' ',printer);
    fputc(0x00e9,printer);
    for (i=1;i<10;i++) fputc(' ',printer);
    sprintf(amt,"%9d",chips);
    p = amt;
    while (*p == ' ') *p++ = '*';
    fprintf(printer,"I.O.U in amount %schips",amt);
    for (i=1;i<11;i++) fputc(' ',printer);
    fputc(0x00ea,printer);
    fputc('\n',printer);
    for (i=1;i<10;i++) fputc(' ',printer);
    fputc(0x00e9,printer);
    for (i=1;i<50;i++) fputc(' ',printer);
    fputc(0x00ea,printer);
    fputc('\n',printer); len++;
    for (i=1;i<10;i++) fputc(' ',printer);
    fputc(0x00e9,printer);
    fprintf(printer,"=================Cold-Hand Poker=================");
    fputc(0x00ea,printer);
    fputc('\n',printer);
    for (i=1;i<10;i++) fputc(' ',printer);
    fputc(0x00e9,printer);
    for (i=1;i<50;i++) fputc(' ',printer);
    fputc(0x00ea,printer);
    fputc('\n',printer); len++;
    for (i=1;i<10;i++) fputc(' ',printer);
    fputc(0x00e9,printer);
    for (i=1;i<50;i++) fputc(' ',printer);
    fputc(0x00ea,printer);
    fputc('\n',printer);
    for (i=1;i<10;i++) fputc(' ',printer);
    fputc(0x00ed,printer);
    for (i=1;i<50;i++) fputc(0x00e8,printer);
    fputc(0x00ee,printer);
    fputc('\n',printer); len++;
    for (i=len;i<66;i++) fprintf(printer,"\n\n");
    fprintf(printer,"\033\066");
    fclose(printer);
    }
                                                                                                               