#include <string.h>
#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	reset_shell_mode

#ifdef PDCDEBUG
char *rcsid_reset_sh = "$Header: C:\CURSES\portable\RCS\reset_sh.c 2.1 1993/06/18 20:20:58 MH Rel MH $";
#endif

#ifndef UNIX


/*man-start*********************************************************************

  reset_shell_mode()	- restore terminal mode

  X/Open Description:
 	Restore the terminal to "program" (in curses) or "shell" (out
 	of curses) state.  These are done automatically by endwin()
 	and doupdate() after an endwin(), so they would normally not
 	be called before these functions.

  PDCurses Description:
 	Under the Flexos platform, PDCurses operates in 16-bit mode.
 	Normally, the Flexos shell operates in 8-bit mode.

  X/Open Return Value:
 	The reset_shell_mode() routine returns OK on success otherwise ERR
 	is returned.

  Portability:
 	PDCurses	int reset_shell_mode( void );
 	X/Open Dec '88	int reset_shell_mode( void );
 	SysV Curses	int reset_shell_mode( void );
 	BSD Curses	int reset_shell_mode( void );

**man-end**********************************************************************/

int	reset_shell_mode(void)
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("reset_shell_mode() - called\n");
#endif

	if	(c_sh_tty.been_set == TRUE)
	{

		memcpy(&_cursvar, &c_sh_tty.saved, sizeof(SCREEN));

		mvcur(0, 0, c_sh_tty.saved.cursrow, c_sh_tty.saved.curscol);
		if (PDC_get_ctrl_break() != c_sh_tty.saved.orgcbr)
			PDC_set_ctrl_break(c_sh_tty.saved.orgcbr);
		if (c_sh_tty.saved.raw_out)
			raw();
		if (c_sh_tty.saved.visible_cursor)
			curson();
		_cursvar.font = PDC_get_font();
		PDC_set_font(c_sh_tty.saved.font);
		if (!PDC_scrn_modes_equal (PDC_get_scrn_mode(),  c_sh_tty.saved.scrnmode))
			PDC_set_scrn_mode(c_sh_tty.saved.scrnmode);
		PDC_set_rows(c_sh_tty.saved.lines);
	}
#ifdef	FLEXOS
	_flexos_8bitmode();
#endif
	return( OK );
}
#endif
