/* gcompile.c */

/*
    Copyright (C) 1996 Chuck Kann  & Michael Bliss Feldman
			     ckann@seas.gwu.edu mfeldman@seas.gwu.edu
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.    


    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* modified May 1996 by Feldman; simplified for djgpp version 2 */
/* compile with gcc -o gcompile.exe gcompile.c                  */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <io.h>
	

int
Run_Compile(char *Program_Name)
{
    int Name_Length;
    char Execute_Command[300];

    Name_Length = strlen(Program_Name);
    if ((strcmp(&Program_Name[Name_Length-3], "adb") != 0) &&
        (strcmp(&Program_Name[Name_Length-3], "ads") != 0))
    {
	printf(
         "Program %s is not an \".ads\" or \".adb\" file, not compiled\n",
         Program_Name);
	return 0;
    }
        
    if (access(Program_Name, 0) != 0)
    {
	printf("File %s does not exist\n", Program_Name);
	return 0;
    }

    printf("Compiling %s\n", Program_Name);
    Program_Name[Name_Length-4] = '\0';

    if (strcmp(&Program_Name[Name_Length-3], "adb") == 0)
        sprintf(Execute_Command,"gcc -c -gnatl -g -gnato %s.%s > %s.lsb", 
            Program_Name, &Program_Name[Name_Length-3], Program_Name);
    else
        sprintf(Execute_Command,"gcc -c -gnatl -g -gnato %s.%s > %s.lss", 
            Program_Name, &Program_Name[Name_Length-3], Program_Name);

    system(Execute_Command);
    return 1;
}

void main(int argc, char *argv[])
{
    char Program_Name[60];
    int i;
    int minimum_args = 1;

    if (argc <= minimum_args)
    {
        printf("Enter the name of the file to be compiled\n");
        gets(Program_Name);
        Run_Compile(Program_Name);
    }
    else
    {
        for (i=minimum_args; i<argc; ++i)
        {
            Run_Compile(argv[i]);
        }
    }
}
