
--------------------------------------------------------------------------
--			The file "list.body"				--
--------------------------------------------------------------------------
with Easy_IO, UNCHECKED_DEALLOCATION;
package body Demo2 is
procedure Dispose_of_List_Element is new UNCHECKED_DEALLOCATION(NODE,LIST);
procedure Insert (Data_Item:in Integer; My_List:in out LIST) is
	current, new_one : LIST;
begin
	new_one := NEW NODE;		-- declare a new NODE
	new_one.data_value := Data_Item;	-- insert value into NODE
	new_one.next_pointer := NULL;		-- set NODE pointer to NULL

	if My_List = NULL then		-- are we inserting into an empty list
		My_List := new_one;		-- if yes, trivial 
	else
		current := My_List;	-- not empty list, must find end
		while current.next_pointer /= NULL loop	-- loop until at end
			current := current.next_pointer;
		end loop;
		current.next_pointer := new_one;	-- insert NODE at end
	end if;
end Insert;
procedure Remove (Data_Item:in Integer; My_List:in out LIST; Success:out Boolean) is
	current, previous : LIST;
begin
	Success := FALSE; current := My_List; previous := NULL;
	if current.data_value = Data_Item then		-- is it the first item
		My_List := current.next_pointer;
		Dispose_of_List_Element(current);
		Success := TRUE;
		return;
	else
		while current /= NULL loop		-- loop thru items
			if current.data_value = Data_Item then	-- found it
				previous.next_pointer := current.next_pointer;
				Dispose_of_List_Element(current);
				Success := TRUE;
				return;
			else				-- check next item
				previous := current;
				current := current.next_pointer;
			end if;
		end loop;
	end if;
end Remove;
procedure Print (My_List:in LIST) is
	current : LIST;
begin
	current := My_List;	-- start at beginning of list
	if current = NULL then		-- print nice message for empty lists
		Easy_IO.put_line("The list is empty.");
	else
		Easy_IO.put("The list is : ");
		while current /= NULL loop	-- loop thru list
			Easy_IO.put(current.data_value);	-- print value
			current := current.next_pointer;	-- increment
		end loop;
		Easy_IO.new_line;		-- print trailing newline
	end if;
	null;
end Print;
function Find (Data_Item: Integer; My_List:LIST) return Boolean is
begin
	return TRUE;
end Find;
end Demo2;
