------------------------------------------------------------------------------
--  File:            testfile.adb
--  Description:     Test maximal number of simultaneously opened files
--  Date/version:    2.II.1997
--  Author:          Gautier.deMontmollin@Maths.UniNe.CH
------------------------------------------------------------------------------
With Text_IO; Use Text_IO;

procedure Test_File is
  package IIO is new Integer_IO(integer); use IIO;

  t: array(1..255) of File_type;   -- max: FILES=255 (in config.sys)
  n: String(1..3);
  imax: natural:= 0;
  bourrage: boolean:= false;

  procedure Creation(i:natural) is
    begin
      Put(To=> n, Item=> i); 
      for k in n'range loop if n(k)=' ' then n(k):='0'; end if; end loop;
      Create( t(i), Name=> "file_"& n &".xxx" );
      Put(' ' & n);
    exception
      when others => bourrage:= true;
    end;

  begin
    Put_Line("This program tries to open simultaneously as many files as possible.");
    Put_Line("Compiled with GNAT/DOS it should be about FILES-6, i.e. up to 249");
    New_Line;
    Put("[ type return ]"); Skip_Line;
    Put_Line("Opening files: ");
    for i in t'range loop
      Creation(i);
      exit when bourrage;
      Put( t(i), i,4);
      Put( t(i), " /printed after creation of this file");
      imax:= i;
    end loop;
    for i in 1..imax loop Put( t(i), " /printed after all file creations");  end loop;
    for i in 1..imax loop Close( t(i) );  end loop;
  end;
