-----------------------------------------------------------------------
--
--  File:        words.ads
--  Description: HANGMAN word guessing
--  Rev:         0.2
--  Date:        03/01/97
--  Author:      Jerry van Dijk
--  Mail:        jerry@jvdsys.nextjk.stuyts.nl
--
--  Copyright (c) Jerry van Dijk, 1997
--  Forelstraat 211
--  2037 KV  HAARLEM
--  THE NETHERLANDS
--  tel int + 31 23 540 1052
--
--  Permission granted to use for any purpose, provided this copyright
--  remains attached and unmodified.
--
--  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
--  IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
--  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
--
-----------------------------------------------------------------------
package Words is

   Number_Of_Words : constant Positive := 40;
   Max_Word_Length : constant Positive := 11;

   subtype Index is Positive range 1 .. Number_Of_Words;

   type Word is private;

   Number_Words_Used : Natural := 0;

   procedure Show (W : in Word);
   function Pick_A_Word return Word;
   procedure Used_Words (W : in Word);
   procedure Forced_Word_Guessed (W : in out Word);
   function Is_Word_Guessed (W : in Word) return Boolean;
   procedure Set_Guessed (W : in out Word; C : in Character);
   function Is_In_Word (W : in Word; C : in Character) return Boolean;

private

   type Guessed_Chars is array (1 .. Max_Word_Length) of Boolean;

   Default_Guessed_Chars : constant Guessed_Chars := (others => False);

   type Word is
      record
         Value   : String (1 .. Max_Word_Length);
         Length  : Positive;
         Guessed : Guessed_Chars;
      end record;

   type List_Of_Words is array (Index) of Word;

   Word_List : constant List_Of_Words := (
      ("SEPARATE   ",  8, Default_Guessed_Chars),
      ("ALLIGATOR  ",  9, Default_Guessed_Chars),
      ("PARTITION  ",  9, Default_Guessed_Chars),
      ("CONFORMANCE", 11, Default_Guessed_Chars),
      ("PRAGMA     ",  6, Default_Guessed_Chars),
      ("UNBIASED   ",  8, Default_Guessed_Chars),
      ("ACCURACY   ",  8, Default_Guessed_Chars),
      ("BROADCAST  ",  9, Default_Guessed_Chars),
      ("COMPLEX    ",  7, Default_Guessed_Chars),
      ("DIAERESIS  ",  9, Default_Guessed_Chars),
      ("ENDIAN     ",  6, Default_Guessed_Chars),
      ("FREEZING   ",  8, Default_Guessed_Chars),
      ("GLOBAL     ",  6, Default_Guessed_Chars),
      ("HANDLER    ",  7, Default_Guessed_Chars),
      ("IMPLICIT   ",  8, Default_Guessed_Chars),
      ("COBOL      ",  5, Default_Guessed_Chars),
      ("KEYBOARD   ",  8, Default_Guessed_Chars),
      ("LAYOUT     ",  6, Default_Guessed_Chars),
      ("MIDWEEK    ",  7, Default_Guessed_Chars),
      ("NORMATIVE  ",  9, Default_Guessed_Chars),
      ("OCCURANCE  ",  9, Default_Guessed_Chars),
      ("PICTURE    ",  7, Default_Guessed_Chars),
      ("QUESTION   ",  8, Default_Guessed_Chars),
      ("RELEASE    ",  7, Default_Guessed_Chars),
      ("SEQUENTIAL ", 10, Default_Guessed_Chars),
      ("TOLERANCE  ",  9, Default_Guessed_Chars),
      ("UNIVERSAL  ",  9, Default_Guessed_Chars),
      ("VISIBLE    ",  7, Default_Guessed_Chars),
      ("WITHIN     ",  6, Default_Guessed_Chars),
      ("OPERAND    ",  7, Default_Guessed_Chars),
      ("PRIMITIVE  ",  9, Default_Guessed_Chars),
      ("LITERAL    ",  7, Default_Guessed_Chars),
      ("SUBTYPE    ",  7, Default_Guessed_Chars),
      ("NULL       ",  4, Default_Guessed_Chars),
      ("ALIAS      ",  5, Default_Guessed_Chars),
      ("ELABORATE  ",  9, Default_Guessed_Chars),
      ("DESIGNATE  ",  9, Default_Guessed_Chars),
      ("ASTERISK   ",  8, Default_Guessed_Chars),
      ("VALUE      ",  5, Default_Guessed_Chars),
      ("SYSTEM     ",  6, Default_Guessed_Chars)
   );

end Words;
