WITH Ada.Text_IO;
WITH Ada.Float_Text_IO;
PROCEDURE Area_And_Circum IS
 
  -- Finds and displays the area and circumference of a circle  
 
   SUBTYPE NonNegFloat IS Float RANGE 0.0 .. Float'Last;

   Pi : CONSTANT NonNegFloat := 3.14159;
 
   Radius        : NonNegFloat;  -- input  - radius of a circle
   Area          : NonNegFloat;  -- output - area of a circle
   Circumference : NonNegFloat;  -- output - circumference of a circle
 
BEGIN -- Area_And_Circum   
 
  -- Read the circle radius   
  Ada.Text_IO.Put (Item => "Enter radius > ");                                
  Ada.Float_Text_IO.Get (Item => Radius);  
 
  -- Find the area   
  Area := Pi * Radius ** 2;
 
  -- Find the circumference   
  Circumference := 2.0 * Pi * Radius;
 
  -- Display the Area and Circumference 
  Ada.Text_IO.Put (Item => "The area is ");
  Ada.Float_Text_IO.Put (Item => Area, Fore => 1, Aft => 2, Exp => 0);
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put (Item => "The circumference is ");
  Ada.Float_Text_IO.Put (Item => Circumference, Fore => 1, Aft => 2, Exp => 0);
  Ada.Text_IO.New_Line;
 
END Area_And_Circum;
