WITH Ada.Text_IO;
PROCEDURE General_Access_Types IS
------------------------------------------------------------------
--| Illustrates general access types
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: September 1995                                     
------------------------------------------------------------------

  TYPE StringPointer IS ACCESS String;
  -- ALL makes StringPointer a "general access type" as opposed to
  -- a "pool-specific access type." StringPointer values 
  -- can designate declared variables and constants,
  -- as well as dynamically allocated (NEW) values
  
  Prompt1: ALIASED String := "Enter a command >";
  Prompt2: ALIASED String := "Thank you.";
  Prompt3: ALIASED String := "Invalid; try again.";
  Prompt4: ALIASED String := "Bye now.";
  -- ALIASED means 
  --   "able to be designated by a general access value"

  PromptTable: ARRAY (1..4) OF StringPointer :=
    (Prompt1'Access, Prompt2'Access, 
     Prompt3'Access, Prompt4'Access);
  -- We fill the array with access values: for example,
  -- Prompt1'Access returns an access value designating Prompt1
    
BEGIN -- General_Access_Types
  
  -- display all the prompts in the table 
  FOR Which IN PromptTable'Range LOOP
    Ada.Text_IO.Put(Item => PromptTable(Which).ALL); -- dereference
    Ada.Text_IO.New_Line;
  END LOOP;
  
END General_Access_Types;
  
