WITH Ada.Text_IO;
WITH Ada.Float_Text_IO;
WITH Currency.IO;
PACKAGE BODY Payroll IS
------------------------------------------------------------------
--| Body of Payroll package
--| Author: Michael B. Feldman, The George Washington University
--| Last Modified: September 1995
------------------------------------------------------------------

  PACKAGE BODY Constructors IS
   
    -- constructors for the three new types
    
    FUNCTION  MakeProfessional (Name  : String;
                           Gender     : Genders; 
                           BirthDate  : Date;
                           StartDate  : Date; 
                           ID         : IDType;
                           MonthSalary: Quantity) 
                           RETURN Professional IS
    BEGIN
      RETURN  (Personnel.Constructors.MakeEmployee(
        Name             => Name,
        Gender           => Gender,
        BirthDate        => Birthdate,
        StartDate        => StartDate,
        ID               => ID) 
        WITH MonthSalary => MonthSalary);
    END MakeProfessional;
      
    FUNCTION MakeSales (Name      : String;
                        Gender    : Genders; 
                        BirthDate : Date;
                        StartDate : Date; 
                        ID        : IDType;
                        WeekSalary: Quantity;
                        CommRate  : CommissionPercentage) 
                        RETURN Sales IS
    BEGIN
      RETURN (Personnel.Constructors.MakeEmployee
        (Name           => Name,
        Gender          => Gender,
        BirthDate       => Birthdate,
        StartDate       => StartDate,
        ID              => ID) 
        WITH WeekSalary => WeekSalary, CommRate => CommRate);
    END MakeSales;

    FUNCTION MakeClerical (Name      : String;
                           Gender    : Genders; 
                           BirthDate : Date;
                           StartDate : Date; 
                           ID        : IDType;
                           HourlyWage: Quantity) 
                           RETURN Clerical IS
    BEGIN
      RETURN  (Personnel.Constructors.MakeEmployee
        (Name           => Name,
        Gender          => Gender,
        BirthDate       => Birthdate,
        StartDate       => StartDate,
        ID              => ID) 
        WITH HourlyWage => HourlyWage); 
    END MakeClerical;
    
  END Constructors;

  PROCEDURE Put(Item: Professional) IS
  BEGIN
    Put(Item => Employee(Item));
    Ada.Text_IO.New_Line;

    Ada.Text_IO.Put(Item => "Category: Professional");
    Ada.Text_IO.New_Line;
    Ada.Text_IO.Put(Item => "Monthly Salary: ");
    Currency.IO.Put(Item => Item.MonthSalary);    
    Ada.Text_IO.New_Line;
  END Put;

  PROCEDURE Put(Item: Sales) IS
  BEGIN
    Put(Item => Employee(Item));
    Ada.Text_IO.New_Line;

    Ada.Text_IO.Put(Item => "Category: Sales");
    Ada.Text_IO.New_Line;
    Ada.Text_IO.Put(Item => "Weekly Salary: ");
    Currency.IO.Put(Item => Item.WeekSalary);    
    Ada.Text_IO.New_Line;
    Ada.Text_IO.Put(Item => "Commission Rate: ");
    Ada.Float_Text_IO.Put(Item => Item.CommRate, Fore=>1,Aft=>2,Exp=>0);
    Ada.Text_IO.New_Line;
  END Put;

  PROCEDURE Put(Item: Clerical) IS
  BEGIN
    Put(Item => Employee(Item));
    Ada.Text_IO.New_Line;

    Ada.Text_IO.Put(Item => "Category: Clerical");
    Ada.Text_IO.New_Line;
    Ada.Text_IO.Put(Item => "Hourly Wage: ");
    Currency.IO.Put(Item => Item.HourlyWage);    
    Ada.Text_IO.New_Line;
  END Put;

END Payroll; 
