WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
WITH Dates.IO;
PACKAGE BODY Personnel IS
------------------------------------------------------------------
--| Body of Personnel package 
--| Author: Michael B. Feldman, The George Washington University
--| Last Modified: September 1995
------------------------------------------------------------------

  PACKAGE BODY Constructors IS
    
    FUNCTION  MakeEmployee(Name     : String;
                           Gender   : Genders; 
                           BirthDate: Date;
                           StartDate: Date; 
                           ID       : IDType) RETURN Employee IS
    BEGIN
      -- note how the Persons constructor is used, with an
      -- aggregate for the Person fields and an
      -- extension aggregate to add in the extra fields.
      RETURN (Persons.Constructors.MakePerson(
        Name           => Name, 
        Gender         => Gender, 
        BirthDate      => BirthDate) 
        WITH 
          StartDate => StartDate, 
          ID => ID);
    END MakeEmployee;
    
  END Constructors;

  FUNCTION StartOf (Whom: Employee) RETURN Date IS
  BEGIN
    RETURN Whom.StartDate;
  END StartOf;
  
  FUNCTION IDOf (Whom: Employee) RETURN IDType IS
  BEGIN
    RETURN Whom.ID;
  END IDOf;

  PROCEDURE Put(Item: Employee) IS
  BEGIN 
    -- Note that we can convert Employee to Person and
    -- call Persons.Put for the common fields
    Persons.Put(Item => Persons.Person(Item));
    
    Ada.Text_IO.Put(Item => "ID Number: ");
    Ada.Integer_Text_IO.Put(Item => Positive(Item.ID), Width => 1);
    Ada.Text_IO.New_Line;

    Ada.Text_IO.Put(Item => "Start Date: ");
    Dates.IO.Put(Item => Item.StartDate, Format => Dates.IO.Full);
    Ada.Text_IO.New_Line;
  END Put;

END Personnel;
