WITH Ada.Text_IO;
WITH Boolean_IO;
PROCEDURE Show_DeMorgan IS
------------------------------------------------------------------
--| Demonstrates the validity of DeMorgan's Laws, and also Boolean_IO
--| a Boolean flag is also used to control the input loop
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  X         : Boolean;
  Y         : Boolean;
  MoreInput : Boolean;

BEGIN -- Show_DeMorgan

  MoreInput := True;
  WHILE MoreInput LOOP

    Ada.Text_IO.Put(Item => "Please enter True or False value for X > ");
    Boolean_IO.Get (Item => X);
    Ada.Text_IO.Put(Item => "Please enter True or False value for Y > ");
    Boolean_IO.Get (Item => Y);

    Ada.Text_IO.Put("NOT(X OR Y)         = ");
    Boolean_IO.Put(Item => NOT(X OR Y), Width => 1);
    Ada.Text_IO.New_Line;

    Ada.Text_IO.Put("(NOT X) AND (NOT Y) = ");
    Boolean_IO.Put(Item => (NOT X) AND (NOT Y), Width => 1);
    Ada.Text_IO.New_Line;
    Ada.Text_IO.New_Line;

    Ada.Text_IO.Put("NOT(X AND Y)        = ");
    Boolean_IO.Put(Item => NOT(X AND Y), Width => 1);
    Ada.Text_IO.New_Line;

    Ada.Text_IO.Put("(NOT X) OR (NOT Y)  = ");
    Boolean_IO.Put(Item => (NOT X) OR (NOT Y), Width => 1);
    Ada.Text_IO.New_Line;
    Ada.Text_IO.New_Line;

    Ada.Text_IO.Put
      (Item=>"Do you wish to try another combination (True/False)? ");
    Boolean_IO.Get (Item => MoreInput);

  END LOOP;

END Show_DeMorgan;
