WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
WITH Useful_Functions;
PROCEDURE Sum_and_Factorial IS
------------------------------------------------------------------
--| Prompts the user for an integer N from 1 to 10 
--| and displays the sum and factorial of all integers from
--| 1 to N. Sum and Factorial are gotten from Useful_Functions.  .
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  SUBTYPE OneToTen IS Positive RANGE 1..10;

  MaxNum:       OneToTen;   -- input - a value from one to ten  
  SumToCount:   Positive;   -- output - sum of integers from one to Count
  ProdToCount:  Positive;   -- output - product of integers from one to Count
 
BEGIN -- Sum_and_Factorial   

  Ada.Text_IO.Put (Item => "Please enter an integer from 1 to 10 > ");
  Ada.Integer_Text_IO.Get (Item => MaxNum);
  Ada.Text_IO.New_Line;

  Ada.Text_IO.Put(Item => "  N    Sum    Factorial");
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item => "  ----------------------");
  Ada.Text_IO.New_Line;

  FOR Count IN 1..MaxNum LOOP
    SumToCount   := Useful_Functions.Sum (N => Count);
    ProdToCount  := Useful_Functions.Factorial (N => Count);

    Ada.Integer_Text_IO.Put (Item => Count, Width => 3);
    Ada.Integer_Text_IO.Put (Item => SumToCount, Width => 7);
    Ada.Integer_Text_IO.Put (Item => ProdToCount, Width => 9);
    Ada.Text_IO.New_Line;
  END LOOP;

END Sum_and_Factorial;
