WITH Ada.Text_IO;
WITH Screen;
PROCEDURE Four_Pieces IS
------------------------------------------------------------------
--|                                                              
--| This program divides the screen into four pieces using
--| horizontal and vertical lines. Screen operations are used 
--| to position the cursor.
--|                                                              
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: October 1995                                     
--|                                                              
------------------------------------------------------------------

BEGIN -- Four_Pieces

  Screen.ClearScreen;
  
  FOR Count IN Screen.Height LOOP
    Screen.MoveCursor (To => (Row => Count, Column => 41));
    Ada.Text_IO.Put (Item => '|');
    Screen.MoveCursor (To => 
      (Row => (Screen.ScreenHeight - Count) + 1, Column => 42));
    Ada.Text_IO.Put (Item => '|');
  END LOOP;
  
  FOR Count IN Screen.Width LOOP
    Screen.MoveCursor (To => (Row => 12, Column => Count));
    Ada.Text_IO.Put (Item => '-');
    Screen.MoveCursor (To => 
      (Row => 13, Column => (Screen.ScreenWidth - Count) + 1));
    Ada.Text_IO.Put (Item => '-');
  END LOOP;

  Screen.MoveCursor (To => (Row => 24, Column => 1));

END Four_Pieces;
