WITH Ada.Text_IO;
PACKAGE Rationals.IO IS
------------------------------------------------------------------
--|                                                              
--| Specification of the input/output child package for Rationals
--|                                                              
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
--|                                                              
------------------------------------------------------------------

  PROCEDURE Get (Item : OUT Rational);
  PROCEDURE Get (File: IN Ada.Text_IO.File_Type; Item : OUT Rational);
  -- Pre : File is open
  -- Post: The first integer number read is the numerator of Item;
  --       the second integer number is the denominator of Item.
  --       A "/" between the two numbers is optional.
  --       The Rational constructor "/" is called 
  --       to produce a rational in reduced form.

  PROCEDURE Put (Item : IN Rational);
  PROCEDURE Put (File: IN Ada.Text_IO.File_Type; Item : IN Rational);
  -- Pre : Item is defined; File is open
  -- Post: displays or writes the numerator and denominator of Item.
 
END Rationals.IO;
