WITH Ada.Text_IO; 
WITH CPUClock; USE CPUClock;
PACKAGE BODY Reporter IS
------------------------------------------------------------------------
--| Body of Reporter - a simple screen protector
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------

  PROTECTED BODY ScreenManager IS

    PROCEDURE Put(Message: IN String) IS
    BEGIN -- Put
      Ada.Text_IO.Put("T =" & Integer'Image(Integer(CPUTime)) 
                       & " " & Message);
      Ada.Text_IO.New_Line;
    END Put;

  END ScreenManager;

BEGIN -- Reporter

  -- These two lines are executed once, when the package is elaborated.
  ResetCPUTime;
  Ada.Text_IO.New_Line; -- gets output going

END Reporter;
