WITH Ada.Text_IO;
GENERIC
  WITH PROCEDURE Get
    (File: IN Ada.Text_IO.File_Type; Item: OUT Element) IS <>;
  WITH PROCEDURE Put
    (File: IN Ada.Text_IO.File_Type; Item: IN Element) IS <>;
PACKAGE Tables_Generic.Backup IS
------------------------------------------------------------------------
--| Generic Child Package for Save and Restore of a Table
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------

  PROCEDURE Save (T: IN TableType; FileName: IN String);
  -- Pre:  T and FileName are defined
  -- Post: The contents of T are written to the given file

  PROCEDURE Restore (T: OUT TableType; FileName: IN String);
  -- Pre:  T and FileName are defined
  -- Post: T is restored from the given file

END Tables_Generic.Backup;
