PACKAGE Types IS
------------------------------------------------------------------------
--| Types package for the bank simulation. This contains only public
--| declarations, and therefore needs no package body.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------

   -- These 2 constants can be altered to change
    --  the behavior of the simulation
    SUBTYPE TellerRange IS Character RANGE 'A'..'C';
    NumberOfCustomers : CONSTANT Integer := 5;

    -- These 2 ranges can be altered to change
    --  the behavior of the simulation
    SUBTYPE TransactionTimeRange IS Integer RANGE 1 .. 7;
    SUBTYPE TimeBetweenVisitsRange IS Integer RANGE 1 .. 11;

    -- Global types
    SUBTYPE Money IS Integer RANGE 0 .. Integer'LAST;
    TYPE Status IS (OK, InsufficientFunds, BadCustId);
    SUBTYPE CustId IS Integer RANGE 0 .. NumberOfCustomers;

END Types;
