/*
  HELP ENGINE PARA GWADA

  Mdulo ADAHCONV.C
  Geraao do arquivo de help GWADA.HLP

  Trabalho de conclusao
  Bracharelado em Informtica

  Ulrich Peters
  Rafael Presotto
  Jerry Dressler
*/

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <..\source\gwadahlp.h>
char moinho[5] = "|/\\";

int read_number(FILE *arquivo)
{
 char i=0,nbuf[8]="";
 int ok=1;
 while (ok)
 {
  fread(&nbuf[i],1,1,arquivo);
  if (nbuf[i] == '\n')
   ok = 0;
  else
   i++;
 }
 nbuf[--i] = '\0';
 return(atoi(nbuf));
}

void grava_nodos(FILE *original)
{
 FILE *help;
 char buffer[1025], string[18];
 long size, atual;
 int i=0, tam_cab, offset_cab;
 help = fopen("GWADA.HLP","wb");
 puts("\r\nEscrevendo GWADA.HLP...");

 /* Grava o cabealho do arquivo de help,
    0x1A, que  marcador de final de arquivo,
    e 0x00 para terminar o string corretamente */
 sprintf(string,"%s%c%c",header,0x1A,0x00);
 tam_cab = strlen(string);
 fwrite(string,tam_cab,1,help);

 /* Determina o nmero de nodos da lista */
 nodo_atual = raiz;
 while (nodo_atual != NULL)
 {
  nodo_atual = nodo_atual->prox;
  i++;
 }
 fwrite(&i,2,1,help); /* Grava nmero de nodos da lista */
 tam_cab += 3;

 /* Grava os nodos - j atualizando o offset */
 offset_cab = tam_cab + i * 12; /* cada grupo de dados 
				   formado por 12 bytes */
 nodo_atual = raiz;
 while (nodo_atual != NULL)
 {
  fwrite(&nodo_atual->number,2,1,help);
  fwrite(&nodo_atual->lines,2,1,help);
  fwrite(&nodo_atual->size,4,1,help);
  nodo_atual->offset += offset_cab;	/* somar tamanho do cabealho !! */
  fwrite(&nodo_atual->offset,4,1,help);
  nodo_antes = nodo_atual;
  nodo_atual = nodo_atual->prox;
 }

 /* Copiar agora o arquivo de help original */
 fseek(original, 0L, SEEK_END);
 size = ftell(original);
 rewind(original);
 atual = 0;
 i = 0;
 while (atual+1024 <= size)
 {
  fread(&buffer,1024,1,original);
  fwrite(&buffer,1024,1,help);
  atual += 1024;
  printf("%c %d%",moinho[i],100-100*(size-atual)/size);
  gotoxy(1,wherey());
  i++;
  if (i>3) i=0;
 }
 i = (int)(size-atual);
 fread(&buffer,i,1,original);
 fwrite(&buffer,i,1,help);
 fclose(help);
}

void ler_arquivo(FILE *arquivo)
{
 char caractere, antes;
 char texto[81];
 long size=0;
 int helps=0, lines=0;
 int desvio;
 int count;
 texto[80] = '\0';

 fread(&caractere,1,1,arquivo);
 if (caractere != ':')
 {
  puts("Arquivo deve comear com ':'");
  exit(0);
 }

 while (! feof(arquivo))
 {
  nodo_atual = malloc(sizeof(struct tree));
  if (nodo_atual == NULL)
  {
   puts("Memria insuficiente.");
   exit(0);
  }
  nodo_atual->number = read_number(arquivo);
  nodo_atual->offset = ftell(arquivo) - 1;
  nodo_atual->prox = NULL;

  antes = caractere;
  nodo_atual->lines = 1;

  /* procurar pelo comeco do proximo help */
  while (! ((antes == '\n')&&(caractere == ':')) ) /* return = \r\n */
  {
   antes = caractere;
   fread(&caractere,1,1,arquivo);
   if (caractere == '\n') nodo_atual->lines++;

   if (caractere == '\\')
   {
    fread(&caractere,1,1,arquivo);
    if (caractere == 'v')
    {
     /* comeou um desvio ?*/
     desvio = 1;
     while (desvio)
     {
      fread(&caractere,1,1,arquivo);
      while ((caractere > 47) && (caractere < 58))
       fread(&caractere,1,1,arquivo);
      if (caractere == '.' )
      {
       printf("\nHelp %d tem desvio que termina sem iniciar antes de\n",nodo_atual->number);
       fread(&texto,80,1,arquivo);
       printf("%c... %s ...%c",34,texto,34);
       exit(1);
      }
      while (caractere != '\\')
      {
       if (caractere == '\n')
       {
	printf("\nHelp %d tem desvio nao-terminado no final da linha antes de\n",nodo_atual->number);
	fread(&texto,80,1,arquivo);
	printf("%c... %s ...%c",34,texto,34);
	exit(1);
       }
       fread(&caractere,1,1,arquivo);
      }
      fread(&caractere,1,1,arquivo);
      if (caractere == 'v')
      {
       /* terminou o texto do desvio - buscar nmero */
       count = 0;
       while ((caractere != '.')&&(count<6))
       {
	fread(&caractere,1,1,arquivo);
	count++;
       }
       if (count == 6)
       {
	printf("\nHelp %d falta '.' no final de help antes de\n",nodo_atual->number);
	fread(&texto,80,1,arquivo);
	printf("%c... %s ...%c",34,texto,34);
	exit(1);
       }
      }
      desvio = 0;
     }
    }
   }

   if (feof(arquivo)) break;
  }
  nodo_atual->size = (size_t)(ftell(arquivo) - nodo_atual->offset - 1);
  nodo_atual->lines -= 1;

  if (raiz == NULL)
   raiz = nodo_atual;
  else
   nodo_antes->prox = nodo_atual;
  nodo_antes = nodo_atual;

  helps++;
  lines += nodo_atual->lines;
  size += nodo_atual->size;
  printf("%d helps, %d linhas, %lu bytes",helps,lines,size);
  gotoxy(1,wherey());
 }
}

void main(int argc, char *argv[])
{
 FILE *arq;
 nodo_antes = NULL;
 if ((arq = fopen(argv[1],"rb")) == NULL)
 {
  printf("Arquivo %s nao localizado.",argv[1]);
  exit(0);
 }
 else
 {
  puts("Lendo help...");
  ler_arquivo(arq);
  grava_nodos(arq);
  fclose (arq);
 }
}
