/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

#include <jlib.h>
#include <vga.h>
#include <vgamouse.h>

#define M_HEIGHT 16
#define M_WIDTH  10

extern vga_modeinfo *__jlib_modeinfo;
static void getbox( int x, int y, int w, int h, UBYTE *bp);

static UBYTE __jlib_mouse_data[] =
{
   255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   
   255, 15,  255, 0,   0,   0,   0,   0,   0,   0,    
   255, 15,  15,  255, 0,   0,   0,   0,   0,   0,   
   255, 15,  15,  15,  255, 0,   0,   0,   0,   0,  
   255, 15,  15,  15,  15,  255, 0,   0,   0,   0, 
   255, 15,  15,  15,  15,  15,  255, 0,   0,   0,   
   255, 15,  15,  15,  15,  15,  15,  255, 0,   0,   
   255, 15,  15,  15,  15,  15,  15,  15,  255, 0,   
   255, 15,  15,  15,  15,  15,  15,  15,  15,  255, 
   255, 15,  15,  15,  15,  15,  255, 255, 255, 0,  
   255, 15,  15,  255, 15,  15,  255, 0,   0,   0,  
   255, 15,  255, 0,   255, 15,  15,  255, 0,   0, 
   0,   255, 0,   0,   255, 15,  15,  255, 0,   0, 
   0,   0,   0,   0,   0,   255, 15,  15,  255, 0, 
   0,   0,   0,   0,   0,   255, 15,  15,  255, 0, 
   0,   0,   0,   0,   0,   0,   255, 255, 0,   0, 
};

static int __jlib_mouse_x;
static int __jlib_mouse_y;
static int __jlib_mouse_button;

buffer_rec *__jlib_ms_sv;
buffer_rec *__jlib_ms_blit;
buffer_rec  __jlib_ptr;

static UBYTE __jlib_mouse_showing;
static UBYTE __jlib_mouse_initted=0;

void draw_mouse (void);
void save_mouse (void);
void restore_mouse (void);
void mouse_handle (int button, int dx, int dy);


/*+--------------------------------------------------------------------------+ */
/*|check for the presence of a mouse.                                        | */
/*+--------------------------------------------------------------------------+ */
int mouse_present (void)
{
   __jlib_mouse_initted=mouse_init("/dev/mouse",MOUSE_MICROSOFT,MOUSE_DEFAULTSAMPLERATE);
   
   if(__jlib_mouse_initted==0){
        __jlib_mouse_initted=1;
	mouse_setxrange (0, SCREEN_MAX_X);
	mouse_setyrange (0, SCREEN_MAX_Y);
	mouse_setwrap (MOUSE_NOWRAP);

	__jlib_mouse_x = 100;
	__jlib_mouse_y = 100;
	__jlib_mouse_showing = 0;	/* off */
	mouse_setposition (100, 100);

	mouse_seteventhandler (mouse_handle);

        __jlib_ms_sv=buff_init(M_WIDTH,M_HEIGHT);
        __jlib_ms_blit=buff_init(M_WIDTH,M_HEIGHT);
        B_X_SIZE(&__jlib_ptr)=M_WIDTH;
        B_Y_SIZE(&__jlib_ptr)=M_HEIGHT;
        B_BUFF_PTR(&__jlib_ptr)=__jlib_mouse_data;
        
        mouse_show_pointer();
                      
	return MOUSE_PRESENT;
   }
   else{
        __jlib_mouse_initted=0;
	return MOUSE_ABSENT;
   }
}


/*+--------------------------------------------------------------------------+ */
/*|show the pointer                                                          | */
/*+--------------------------------------------------------------------------+ */
void mouse_show_pointer (void)
{
   if(!__jlib_mouse_initted){
      return;
   }
   
   mouse_update();

   if(!__jlib_mouse_showing){
	__jlib_mouse_showing = 1;
	save_mouse ();
	draw_mouse ();
   }
   mouse_update();
}


/*+--------------------------------------------------------------------------+ */
/*|hide the pointer                                                          | */
/*+--------------------------------------------------------------------------+ */
void mouse_hide_pointer (void)
{
   if(!__jlib_mouse_initted){
      return;
   }
      mouse_update();

   if(__jlib_mouse_showing != 0){
	__jlib_mouse_showing = 0;
	restore_mouse ();
   }
}

/*+--------------------------------------------------------------------------+ */
/*|read pointer coordinates                                                  | */
/*+--------------------------------------------------------------------------+ */
void mouse_get_status (int *x_pos, int *y_pos, int *b_status)
{
   if(!__jlib_mouse_initted){
      return;
   }
   
   mouse_update();

   *x_pos = __jlib_mouse_x;
   *y_pos = __jlib_mouse_y;
   *b_status = __jlib_mouse_button;
}


/*+--------------------------------------------------------------------------+ */
/*|change pointer coordinates.                                               | */
/*+--------------------------------------------------------------------------+ */
void mouse_set_status (int x, int y)
{
   if(!__jlib_mouse_initted){
      return;
   }

   if (__jlib_mouse_showing != 0){
	restore_mouse();
	__jlib_mouse_x = x;
	__jlib_mouse_y = y;
	mouse_setposition (x, y);
	save_mouse();
	draw_mouse();
   }
   else{
	__jlib_mouse_x = x;
	__jlib_mouse_y = y;
	mouse_setposition(x, y);
   }

   mouse_update();
}


/*+--------------------------------------------------------------------------+ */
/*|shut down the mouse.                                                      | */
/*+--------------------------------------------------------------------------+ */
void mouse_closedown (void)
{
 if(!__jlib_mouse_initted){
    return;
 }

 mouse_hide_pointer();
 mouse_close();

 __jlib_mouse_initted=0;
}


/*+--------------------------------------------------------------------------+ */
/*|mouse handler.                                                            | */
/*+--------------------------------------------------------------------------+ */
void mouse_handle (int button, int dx, int dy)
{
   if(__jlib_mouse_showing){
	restore_mouse ();
   }

   __jlib_mouse_button = button;

   /* update coords, ensuring they don't get off the screen */
   if((__jlib_mouse_x + dx) > SCREEN_MAX_X){
	__jlib_mouse_x = SCREEN_MAX_X;
   }
   else{
	if((__jlib_mouse_x + dx) < 0){
	     __jlib_mouse_x = 0;
	}
	else{
	     __jlib_mouse_x += dx;
	}
   }

   if((__jlib_mouse_y + dy) > SCREEN_MAX_Y){
	__jlib_mouse_y = SCREEN_MAX_Y;
   }
   else{
	if((__jlib_mouse_y + dy) < 0){
	    __jlib_mouse_y = 0;
        }
	else{
	    __jlib_mouse_y += dy;
	}
   }


   if(__jlib_mouse_showing != 0){
	save_mouse();		
	draw_mouse();
   }
}


#define X_LEFT   (xpos)
#define X_RIGHT  (xpos+M_WIDTH)
#define Y_TOP    (ypos)
#define Y_BOTTOM (ypos+M_HEIGHT)


void draw_mouse (void)
{
 buff_stencil_buff_toNC(__jlib_ms_blit,0,0,&__jlib_ptr,0,0,M_WIDTH-1,M_HEIGHT-1);
 screen_blit_buff_to(__jlib_mouse_x,__jlib_mouse_y,__jlib_ms_blit,0,0,M_WIDTH-1,M_HEIGHT-1);
}


void save_mouse (void)
{
   int xpos = __jlib_mouse_x;
   int ypos = __jlib_mouse_y;
   int endx,endy;
   
   if (X_RIGHT > SCREEN_MAX_X){
	/* some portion of the right is obscured */
        endx = SCREEN_WIDTH;
   }
   else{
          endx=X_RIGHT;
   }
   if (Y_BOTTOM > SCREEN_MAX_Y){
	/* some portion of the bottom is obscured */
        endy = SCREEN_HEIGHT;
   }
   else{
          endy=Y_BOTTOM;
   }
 
   getbox(xpos,ypos,endx-xpos,endy-ypos,B_BUFF_PTR(__jlib_ms_sv));   

   FAST_SHORT_COPY(B_BUFF_PTR(__jlib_ms_sv),B_BUFF_PTR(__jlib_ms_blit),M_WIDTH*M_HEIGHT);
}


void restore_mouse (void)
{
 screen_blit_buff_to(__jlib_mouse_x,__jlib_mouse_y,__jlib_ms_sv,0,0,M_WIDTH-1,M_HEIGHT-1);
}


static void getbox( int x, int y, int w, int h, UBYTE *bp) {
	int vp;
	int page;
	int i;
	vp=y*__jlib_modeinfo->linewidth+x;

	page = vp >> 16;
	vp &= 0xffff;
	vga_setpage(page);
	for (i = 0; i < h; i++) {
		if (vp + w > 0x10000)
			if (vp >= 0x10000) {
				page++;
				vga_setpage(page);
				vp &= 0xffff;
			}
			else {	/* page break within line */
				memcpy(bp, vga_getgraphmem() + vp, 0x10000 - vp);
				page++;
				vga_setpage(page);
				memcpy(bp + 0x10000 - vp, vga_getgraphmem(),
					(vp + w) & 0xffff);
				vp = (vp + __jlib_modeinfo->linewidth) & 0xffff;
				bp += M_WIDTH;
				continue;
			}
		memcpy(bp, vga_getgraphmem() + vp, w);
		bp += M_WIDTH;
		vp += __jlib_modeinfo->linewidth;
	}
}
