/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */
/*
 * X Version Copyright (C) 1995 Mike Manley
 * 
 * Based on SVGA code by Jonathan Paul Griffiths
 */

#include <stdio.h>
#include <stdlib.h>
#include <jlib.h>

#define PALSIZE 256

/*+------------------------------------------------------------------------+*/
/*|Set a color on screen                                                   |*/
/*+------------------------------------------------------------------------+*/
JINLINE void screen_put_pal(UBYTE col, UBYTE red, UBYTE green, UBYTE blue)
{
	XColor jxcol;

        /* Set an entry in the X Colormap */
	jxcol.pixel = col;
	jxcol.red = (red << 8) | red;
	jxcol.green = (green << 8) | green;
	jxcol.blue = (blue << 8) | blue;
	jxcol.flags = DoRed | DoGreen | DoBlue;
	/* and store it to the colormap */
	XStoreColor(jxdisplay, jxcolormap, &jxcol);
	/* Do we need to flush the display ? I think we do! */
	XFlush(jxdisplay);
}


/*+------------------------------------------------------------------------+*/
/*|Set all the colors from the given palette.                              |*/
/*+------------------------------------------------------------------------+*/
void screen_block_set_pal(UBYTE *pal)
{
 int i;
 XColor jxcol;
  
 for(i=0;i<PALSIZE;i++) {
	/* Set up an XColor */
	jxcol.pixel = i;
	jxcol.red = ((*pal) << 8) | (*pal);
	++pal;
	jxcol.green = ((*pal) << 8) | (*pal);
	++pal;
	jxcol.blue = ((*pal) << 8) | (*pal);
	++pal;
	jxcol.flags = DoRed | DoGreen | DoBlue;
	/* and store it to the colormap */
	XStoreColor(jxdisplay, jxcolormap, &jxcol);
 }
	
 /* Do we need to flush the display ? I think we do! */
 XFlush(jxdisplay);
}
