ifndef __FLOAT_H__
__FLOAT_H__ equ 0

FLT_RADIX          equ     2
FLT_ROUNDS         equ     1
FLT_GUARD          equ     1
FLT_NORMALIZE      equ     1

DBL_DIG            equ     15
FLT_DIG            equ     6
LDBL_DIG           equ     19

DBL_MANT_DIG       equ     53
FLT_MANT_DIG       equ     24
LDBL_MANT_DIG      equ     64

DBL_EPSILON        equ     2.2204460492503131E-16
FLT_EPSILON        equ     1.19209290E-07F
LDBL_EPSILON       equ     1.084202172485504E-19

; smallest positive IEEE normal numbers 
DBL_MIN            equ     2.2250738585072014E-308
FLT_MIN            equ     1.17549435E-38F
LDBL_MIN           equ     _tiny_ldble

DBL_MAX            equ     _huge_dble
FLT_MAX            equ     _huge_flt
LDBL_MAX           equ     _huge_ldble

DBL_MAX_EXP        equ     +1024
FLT_MAX_EXP        equ     +128
LDBL_MAX_EXP       equ     +16384

DBL_MAX_10_EXP     equ     +308
FLT_MAX_10_EXP     equ     +38
LDBL_MAX_10_EXP    equ     +4932

DBL_MIN_10_EXP     equ     -307
FLT_MIN_10_EXP     equ     -37
LDBL_MIN_10_EXP    equ     -4931

DBL_MIN_EXP        equ     -1021
FLT_MIN_EXP        equ     -125
LDBL_MIN_EXP       equ     -16381

externdef _huge_flt:REAL4;
externdef _huge_dble:REAL8;
externdef _huge_ldble:REAL10;
externdef _tiny_ldble:REAL10;

_clear87 proto
_control87 proto,:word,:word
_fpreset proto
_status87 proto

; 8087/80287 Status Word format   

SW_INVALID    equ  0x0001  ; Invalid operation                
SW_DENORMAL   equ  0x0002  ; Denormalized operand             
SW_ZERODIVIDE equ  0x0004  ; Zero divide                      
SW_OVERFLOW   equ  0x0008  ; Overflow                                 
SW_UNDERFLOW  equ  0x0010  ; Underflow                            
SW_INEXACT    equ  0x0020  ; Precision (Inexact result)

; 8087/80287 Control Word format 

MCW_EM             equ     0x003f  ; interrupt Exception Masks
    EM_INVALID     equ     0x0001  ;   invalid                    
    EM_DENORMAL    equ     0x0002  ;   denormal                   
    EM_ZERODIVIDE  equ     0x0004  ;   zero divide                
    EM_OVERFLOW    equ     0x0008  ;   overflow                   
    EM_UNDERFLOW   equ     0x0010  ;   underflow                  
    EM_INEXACT     equ     0x0020  ;   inexact (precision)        
                   
MCW_IC             equ     0x1000  ;   Infinity Control     
    IC_AFFINE      equ     0x1000  ;   affine               
    IC_PROJECTIVE  equ     0x0000  ;   projective           
                   
MCW_RC             equ     0x0c00  ; Rounding Control           
    RC_CHOP        equ     0x0c00  ;   chop                     
    RC_UP          equ     0x0800  ;   up                       
    RC_DOWN        equ     0x0400  ;   down                     
    RC_NEAR        equ     0x0000  ;   near                     

MCW_PC             equ     0x0300  ; Precision Control    
    PC_24          equ     0x0000  ;    24 bits                   
    PC_53          equ     0x0200  ;    53 bits                   
    PC_64          equ     0x0300  ;    64 bits                   

; 8087/80287 Initial Control Word 
; use affine infinity, mask underflow and precision exceptions 

CW_DEFAULT   equ   _default87
externdef  _default87:word;

 
;       SIGFPE signal error types (for integer & float exceptions). 

FPE_INTOVFLOW   equ        126     ; 80x86 Interrupt on overflow  
FPE_INTDIV0     equ        127     ; 80x86 Integer divide by zero 

FPE_INVALID     equ        129     ; 80x87 invalid operation      
FPE_ZERODIVIDE  equ        131     ; 80x87 divide by zero             
FPE_OVERFLOW    equ        132     ; 80x87 arithmetic overflow    
FPE_UNDERFLOW   equ        133     ; 80x87 arithmetic underflow   
FPE_INEXACT     equ        134     ; 80x87 precision loss         
FPE_STACKFAULT  equ        135     ; 80x87 stack overflow             
FPE_EXPLICITGEN equ        140     ; When SIGFPE is raise()'d         
FPE_DENORMAL    equ        150     ; 80x87 denormal exception  (QLIB only)
FPE_NOFPU       equ        151     ; 80x87 There is not 80x87! (QLIB only)
FPE_UNKNOWN     equ        152     ; Unknown exception         (QLIB only)

;                        SIGSEGV signal error types.

SEGV_BOUND       equ       10      ; A BOUND violation (SIGSEGV)  
SEGV_PAGEFAULT   equ       12      ; QLIB only : Page Fault
SEGV_EXPLICITGEN equ       11      ; When SIGSEGV is raise()'d    

 
;                        SIGILL signal error types.

ILL_EXECUTION    equ       20      ; Illegal operation exception  
ILL_EXPLICITGEN  equ       21      ; When SIGILL is raise()'d         

endif
