;this code is to test 2 sets of code to see which is faster
;place code in timer.inc, compile and run it...

; NEW : v1.02
;  - uses a PAGE aligned segment for code/data
; NEW : v1.01
;  - fixed many inaccuracy problems
;  - MSR1 and MSR2 were reversed (see \src\qlib\profiler.asm)

_defloops equ 10000
  ;no of times to do case1,case2 each time
  ;change this to a comfortable speed for your CPU
  ;I have a P-200-MMX
_type1 equ pf_AGI
_type2 equ pf_misaligned
_sizeofcache equ (16*1024)

;Now utilizes QProfiler (within QLIB) which supports:
;  - IRQ1 High Speed (high precision)
;  - Pentium cycle clock (perfect precision under DOS) (opcode 0fh,31h)
;  - Pentium MSR monitoring (detect AGIs, etc.)

;NOTE : this program sets timer#0 to as fast as possible so this program
;       traps IRQ1 and does not let it go to DOS, so your time
;       will simply freeze when you use this program (instead of zooming
;       into the next millinium)

_QLIB_ALIGN_ equ <PAGE>   ;this will allow align 256
include src\qlib.inc
include stdio.inc
include conio.inc
include alloc.inc
include dpmi.inc
include process.inc
include mem.inc
include profiler.inc
include string.inc

.data
align 256
_pi profiler_info <>

align 256
_ccc dd ? ;clear cache code
_loops dd _defloops

.code
align 256
include _temp_.pro    ;this file is generated by make.bat

.code
align 256
_m1 proc
  case1
  ret
_m1 endp
align 256
_m2 proc
  case2
  ret
_m2 endp

align 256
_ctc proc  ;Clear all caches
  call [_ccc]
  mov esi,_ccc
  mov ecx,_sizeofcache
  rep lodsb
  ret
_ctc endp

align 256
_call_macro proc _macro:dword,_loc:dword
  call _ctc
  mov ecx,_loops
  callp profiler_start,offset _pi
_l1:
  push ecx
  mov eax,-1
  xor ebx,ebx
  xor edx,edx
  xor ecx,ecx
  xor esi,esi
  xor edi,edi
  align 256
  initstate
jmp $+2         ;Discharge pipelines to avoid inaccuracies
jmp $+2
jmp $+2
  align 256
  call [_macro]
  pop ecx
  dec ecx
  jnz _l1
  callp profiler_stop,offset _pi
  callp gotoxy,1,_loc
  callp profiler_print,offset _pi
  ret
_call_macro endp

align 256
main proc

  .if _argc == 2
    mov eax,_argv
    mov eax,[eax+4]
    callp str2num,eax,10
    .if eax==0
      inc eax
    .elseif eax>100000
      mov eax,100000
    .endif
    mov _loops,eax
  .endif

  callp malloc,_sizeofcache   ;clear Cache code
  .if eax == NULL
    callp printf,"Not enough RAM"
    callp exit,0
  .endif
  mov _ccc,eax
  mov bptr[eax+_sizeofcache-1],0c3h     ;RET code
  callp memset,_ccc,90h,_sizeofcache-1  ;NOP codes

  call profiler_init
  .if eax == 1
    ;MSRs available
    mov _pi.idx1,_type1
    mov _pi.idx2,_type2
  .endif

  call clrscr

  callp printf,"Profiler v1.02\n"
  callp printf,"Pentium cycle clock is"
  .if _cpu<5
    callp printf," not"
  .endif
  callp printf," available.\n"
  callp printf,"Pentium MSRs are"
  .if _cpu<5 || _cpl
    callp printf," not"
  .endif
  callp printf," available.\n"
  callp printf,"Smaller numbers indicate faster execution.\n"
  callp printf,"Number of interations = %d\n",_loops

align 256
top:

align 256
  callp _call_macro,offset _m1,7

align 256
  callp _call_macro,offset _m2,14

  call kbhit
  cmp al,0
  jz top

  call getch

  call profiler_uninit

  callp gotoxy,1,16
  ret
main endp

_endseg

end

