;This macro is used by all the get/put funcs
; (helps prevent errors from block copies)

; EXIT : ECX = _v_bypp

;_fast - means xl = xl * _v_bypp  (ie: xlb)
;_noshift - means do not * _v_bypp for edi and dadd  (which is ESI/SADD)

g_setup macro _mul:REQ,_sadd:REQ,_dadd:REQ,_esi:REQ,_edi:REQ,_fast,_noshift,_noshifts
  mov eax,y1
  imul _mul
  mov ebx,eax
  mov eax,x1
  imul _v_bypp
  add eax,ebx
  mov saddr,eax
  xor _esi,_esi
  xor _edi,_edi
  mov eax,x2
  sub eax,x1
  inc eax
  mov xl,eax
  mov eax,y2
  sub eax,y1
  inc eax
  mov yl,eax
  mov _dadd,0
  mov eax,_v_x
  sub eax,xl
  mov _sadd,eax

  mov eax,x1
  cmp eax,_v_win_x2
  jg niv

  mov ebx,x2
  cmp ebx,_v_win_x1
  jl niv

  mov ecx,y1
  cmp ecx,_v_win_y2
  jg niv

  mov edx,y2
  cmp edx,_v_win_y1
  jl niv

  ;;Image is with-in view
  ;;Start to calc things

  cmp ebx,_v_win_x2
  jbe @f
  sub ebx,_v_win_x2  ;;EBX = difference between x2 and _v_win_x2
  sub xl,ebx
  add _sadd,ebx
  add _dadd,ebx
@@:

  cmp edx,_v_win_y2
  jbe @f
  sub edx,_v_win_y2  ;;EDX = difference between y2 and _v_win_y2
  sub yl,edx
@@:

  cmp eax,_v_win_x1
  jge @f
  sub eax,_v_win_x1
  neg eax  ;;EAX = difference between x1 and _v_win_x1
  add _edi,eax
  add _esi,eax
  sub xl,eax
  add _sadd,eax
  add _dadd,eax
@@:

  cmp ecx,_v_win_y1
  jge @f
  sub ecx,_v_win_y1
  neg ecx  ;;ECX = difference between y1 and _v_win_y1
  sub yl,ecx
  ;;ecx*xl   +> _edi
  ;;ecx*_v_x +> _esi
  mov eax,xl
  mul ecx
  add _edi,eax
  mov eax,_v_x
  mul ecx
  add _esi,eax
@@:

  ifdif %_noshifts,%1     ;;for ModeX opt
  mov ecx,_v_bypp
  .if ecx > 1
    .if ecx == 2
      ifidn %_fast,%1
        shl xl,1
      endif
      ifdif %_noshift,%1
        shl _dadd,1
        shl _edi,1
      endif
      shl _sadd,1
      shl _esi,1
    .elseif ecx == 4
      ifidn %_fast,%1
        shl xl,2
      endif
      ifdif %_noshift,%1
        shl _dadd,2
        shl _edi,2
      endif
      shl _sadd,2
      shl _esi,2
    .else
      ifidn %_fast,%1
        mov eax,xl
        mul ecx
        mov xl,eax
      endif
      ifdif %_noshift,%1
        mov eax,_dadd
        mul ecx
        mov _dadd,eax
        mov eax,_edi
        mul ecx
        mov _edi,eax
      endif
      mov eax,_sadd
      mul ecx
      mov _sadd,eax
      mov eax,_esi
      mul ecx
      mov _esi,eax
    .endif
  .endif
  endif
endm
