; VIDEO Routines   Ver 1.40

; these PROCs are used for all grafix stuff like:setpal,mouse,gprintf,etc.

; Supports :
; - VGA 
; - VESA v1.2 and v2.0
; - modeX

; To be supported :
; - DirectX (if possible from DOS?)

;Detection phase order:
; - VGA
; - modeX
; - Vesa 2.0 (LFB)
; - directX  (not supported yet)
; - Vesa 1.2 (Banking)

include src\qlib.inc
include dos.inc
include video.inc
include src\video.inc
include vesa.inc
include string.inc
include stdlib.inc
include stdio.inc
include conio.inc
include fcntl.inc

.data
;info for current mode
banking db 0  ;using Vesa Banking mode

;info for getmode() last successful mode info
getmode db 0
getmode_x dw 0
getmode_y dw 0
getmode_bpp db 0
getmode_banking db 0
getmode_bpsl dw 0
getmode_linear dd 0
getmode_800_ dd 0

include vsync.inc
include gfxmac.inc

include vesa.asm
include modex.asm
include mouse.asm

include gfxmac.inc  ;Grafix macros
include gsetup.inc  ;More Grafix macros
include gfx1.asm    ;some more grafix funcs
include gfx2.asm    ;even more grafix funcs (mouse only)
include copy.asm
include copyblk.asm  ;NEW : v2.11 Beta #1
include copybuf.asm  ;NEW : v2.11 Beta #1

.code
restore_video proc private
  mov ax,3
  int 10h
  ret
restore_video endp

mouse_stop proc private
  .if mouse_con
    call mouse_off
  .endif
  ret
mouse_stop endp

align 4
g_getmode proc,x:word,y:word,bpp:byte
  pushad

; NOTE : ..._getmode() funcs must set getmode_bpsl everything else
; will be handled in g_setmode()

  ;try VGA 1st
  .if x==320 && y==200 && bpp==8
    mov eax,G_VGA
    mov getmode_bpsl,320   ;FIX : v2.06 b#3 : I removed this in Beta #2, Duh!!!
    jmp ok
  .endif
  ;try VESA
  call vesa_init
  .if eax!=ERROR
    callp vesa_getmode,x,y,bpp
    .if eax!=ERROR
      .if !eax
        mov getmode_banking,1
      .else
        mov getmode_banking,0
      .endif
      mov eax,G_VESA
      jmp ok
    .endif
  .endif
  ;try modeX
  .if bpp!=8
bad:
    popad
    mov eax,ERROR
    ret
  .endif
  callp modex_getmode,x,y
  .if eax==ERROR
    jmp bad
  .endif
  mov eax,G_MODEX
ok:
  mov [esp].callstruct._eax,eax  ;save EAX for popad
  mov getmode,al
  mov ax,x
  mov getmode_x,ax
  mov ax,y
  mov getmode_y,ax
  mov al,bpp
  mov getmode_bpp,al
  popad
  ret
g_getmode endp

vga_uninit proc private
  call mouse_stop
  call restore_video
  mov _qlib_video_cleanup,NULLPROC
  ret
vga_uninit endp

align 4
g_setmode proc
  pushad
  .if !getmode
bad:
    popad
    mov eax,ERROR
    ret
  .endif

  call _qlib_video_cleanup

  .if getmode==G_VGA
    mov _v_linear,0a0000h
    mov ax,13h
    int 10h
    mov _v_curmode,G_VGA
    mov _qlib_video_cleanup,vga_uninit
    call set_copy
    call set_vars
    popad
    xor eax,eax
    ret
  .endif
  .if getmode==G_VESA
    call vesa_setmode
    mov _v_curmode,G_VESA
    mov al,getmode_banking
    mov banking,al
    mov eax,getmode_linear
    mov _v_linear,eax
    mov eax,getmode_800_
    mov _800_,eax
    call set_vars
    ; ******************************************************
    ; Set logical scan lines = physical lines (for speed)
    ; ******************************************************
    xor bl,bl
    mov ecx,_v_x
    call vesa_func06
    test ah,ah
    jnz @f  ;not successful?
    ;BX = new bpsl
    movzx ebx,bx
    mov _v_bpsl,ebx
    mov eax,_v_xb
    sub eax,ebx
    mov _v_xbpsl,eax
@@:
    call set_copy
    popad
    xor eax,eax
    ret
  .endif
  .if getmode==G_MODEX
    mov _v_linear,0a0000h
    call modex_setmode
    mov _v_curmode,G_MODEX
    call set_copy
    call set_vars
    popad
    xor eax,eax
    ret
  .endif
  jmp bad
g_setmode endp

g_alloc proc
  ;This will alloc a buffer for use with g_setbuf()
  ;This must be called AFTER g_setmode() or t_setmode() is called.
  mov eax,_v_xb
  mul _v_y
  callp calloc,eax,1
  ret
g_alloc endp

set_copy proc private
  ;This func is re-called if anything changes the video setup (like vesa_func06())
  ;Must preserve all regs (including EAX!)
  .if (_v_curmode==G_TEXT) || (_v_curmode==G_VGA)
    mov _v_acctype,G__LINEAR
    ret
  .endif
  .if _v_curmode==G_VESA
    .if banking
      .if _v_xbpsl
        mov _v_acctype,G__VESAX
        ret
      .endif
      mov _v_acctype,G__VESA
      ret
    .endif
    .if _v_xbpsl
      mov _v_acctype,G__LINEARX
      ret
    .endif
    mov _v_acctype,G__LINEAR
    ret
  .endif
  mov _v_acctype,G__MODEX   ;must be modeX
  ret
set_copy endp

set_vars proc private
  xor eax,eax
  mov ax,getmode_x
  xor ebx,ebx
  mov bx,getmode_y
  xor ecx,ecx
  mov cl,getmode_bpp

  mov _v_win_x1,0
  mov _v_win_y1,0
  mov _v_x,eax
  mov _v_win_x2,eax
  dec _v_win_x2
  mov _v_y,ebx
  mov _v_win_y2,ebx
  dec _v_win_y2
  mov _v_bpp,ecx
  .if ecx<=8
    mov _v_bypp,1
  .elseif ecx<=16
    mov _v_bypp,2
  .elseif ecx<=24
    mov _v_bypp,3
  .else
    mov _v_bypp,4
  .endif
  mul _v_bypp
  mov _v_xb,eax  ;X*bypp
  ;if _v_xb!=bytesperscanline then g_copy must do things differently
  xor ebx,ebx
  mov bx,getmode_bpsl
  mov _v_bpsl,ebx
  sub ebx,eax
  mov _v_xbpsl,ebx    ;differece to add to edi after each scan line
  ret
set_vars endp

_v_save proc
  xor ecx,ecx
  .if (_v_curmode==G_VESA) && banking
    mov cl,vesa_current_bank
    mov vesa_current_bank,-1   ;FIX : v2.11 Beta #1 : ensure we switch bank the 1st time
  .elseif _v_curmode==G_MODEX
    mov cl,modex_plane_rd
    mov ch,modex_plane_wr
  .endif
  ret
_v_save endp

_v_restore proc
  .if (_v_curmode==G_VESA) && banking
    mov vesa_current_bank,-1   ;FIX : v2.11 Beta #1 : ensure we switch bank the 1st time
    callp vesa_setbank,cl
  .elseif _v_curmode==G_MODEX
    mov ah,cl
    mov al,4
    mov dx,vga_GC_INDEX
    mov modex_plane_rd,ah
    out dx,ax  ;must restore plane #
    mov ah,ch
    mov al,2
    mov dx,vga_SC_INDEX
    mov modex_plane_wr,ah
    out dx,ax  ;must restore plane #
  .endif
  ret
_v_restore endp

_endseg

end

