/******************************************************************************
* Module    :   Regular Expression String Matching --- Defines, typedefs and
*               function prototypes.
*
* Author    :   John Stevens
******************************************************************************/

#if ! defined(REGULAR_EXPRESSION_HEADER_FILE)
#define     REGULAR_EXPRESSION_HEADER_FILE

#include    "sets.h"

/*  Define the maximum number of sub-expressions supported. */
#define MAX_SUB_EXPRS   20

/*  Flags for case sensitivity in string compares.  */
typedef enum    {
    CASE_SENSITIVE,
    IGN_CASE
} CASE_CMP;

/*  Type of regular expression node in expression tree. */
typedef enum    {
    NODE_TYPE_NOT_SET,
    OP_ENUM,                /*  Enumeration operator.       */
    OP_OR,                  /*  Alternation operator.       */
    OP_AND,                 /*  Catenation operator.        */
    OP_L_PAREN,             /*  Parentheses.                */
    OP_R_PAREN,             /*  Right parentheses.          */
    END_OR,                 /*  End alternation.            */
    END_ENUM,               /*  End enumeration.            */
    DATA_LEFT_ANCHOR,       /*  Anchor left side.           */
    DATA_RIGHT_ANCHOR,      /*  Anchor right side.          */
    DATA_ANY,               /*  Any single character.       */
    DATA_SPAN,              /*  Match any character.        */
    DATA_STRING,            /*  String data node.           */
    DATA_SET                /*  Set data node.              */
} NODE_TYPE;

/*  Type definition for regular expression node in expression tree. */
typedef struct  reg_exp_st
{
    NODE_TYPE           NodeType;   /*  Node type, operator or data.    */
    struct  reg_exp_st  *Left;      /*  Expression tree pointers.       */
    struct  reg_exp_st  *Right;
    unsigned int        MinSpan;    /*  Minimum span.                   */
    unsigned int        MaxSpan;    /*  Maximum span.                   */
    unsigned int        SubExprNo;  /*  Sub-expression number.          */
    union
    {
        char        *MatchStr;      /*  String to match against.        */
        SET_TYPE    *CSet;          /*  Character set to match against. */
    } data;
} REG_EXP_NODE;

/*  Function prototypes.    */
extern  REG_EXP_NODE    *ReCompile(char *);
extern  int             ReMatch(char            *Str,
                                CASE_CMP        Case,
                                REG_EXP_NODE    *ReExpr,
                                char            ***SubStrs);
extern  REG_EXP_NODE    *FreeReExpr(REG_EXP_NODE    *ReExpr);

#endif
