/*                        Sprite & Scrolling Engine                         */
/*        Copyright (c) Genesoft 1995-1996.  All rights reserved.           */

#include<stdio.h>
#include<conio.h>
#include<malloc.h>
#include<stdlib.h>

#include"sse.h"
#include"ssecapt.h"

#define REVISION        "1"
#define LINE_LENGTH     328

/************************************     Buffer Sizes    */

#define MAX_FRAMES      128
#define MAX_PCX_SIZE    1024 * 768
#define MAX_SPRITE_DATA MAX_FRAMES * 4096


int main( int argc, char * argv[] )
{
   char *inbuffer, *outbuffer, *out;
   sseSpriteHeader * sh;
   HiddenSpriteInfo * hsi;
   int filecount, framecount;
   imgInfo inputimg;
   FILE * fp;

   void SetupSpriteHeader( sseSpriteHeader * hdr );
   int ReadWholePCX( char * dest, imgInfo * img, char * filename );
   int CaptureAllFrames( char * outbuffer, char ** CP, imgInfo * pic, sseSpriteHeader * hdr, HiddenSpriteInfo * hp );

   if( argc < 3 )
   {
      printf( "\nUsage: CAPT-SSP <input-pcx-names>... <output-ssp-name>\n\n" );
      return EXIT_FAILURE;
   }

   printf("\n CAPT-SSP Utility  Version %s  Revision %s\n\n",SSE_VERSION,REVISION);
   
   inbuffer = malloc( MAX_PCX_SIZE );
   outbuffer = malloc( MAX_SPRITE_DATA );
   sh = (sseSpriteHeader*) malloc( sizeof( sseSpriteHeader ) + (MAX_FRAMES-1) *
      sizeof(sseSpriteGraphicInfo) );
   hsi = (HiddenSpriteInfo*) malloc( MAX_FRAMES * sizeof( HiddenSpriteInfo ));
   if( !inbuffer || !outbuffer || !sh || ! hsi )
   {
      printf( "Memory allocation failed!\n" );
      printf( "  Solution: Free more EMS/XMS or reduce CAPT-SSP buffer sizes.\n\n" );
      return EXIT_FAILURE;
   }

   captSetupSSPHeader( sh, hsi, LINE_LENGTH );

   filecount = 1;
   framecount = 0;
   out = outbuffer;
   while( filecount < argc - 1 )
   {
      if( ReadWholePCX( inbuffer, &inputimg, argv[filecount] ) ) return EXIT_FAILURE;

       printf( "File \"%s\" resolution %d x %d  -Working-",argv[filecount],
         inputimg.Width, inputimg.Height );

      if( CaptureAllFrames( outbuffer, &out, &inputimg, sh, hsi ) ) return EXIT_FAILURE;

      printf( "\b\b\b\b\b\b\b\b\bFrames Captured: %d\n", sh->NumFrames-framecount );

      framecount = sh->NumFrames;
      filecount++;
   }

   printf( "Writing file \"%s\".\n", argv[filecount] );

   if(!( fp = fopen( argv[filecount], "wb" )))
   {
      printf("Error opening file!\n");
      return EXIT_FAILURE;
   }
   fwrite( sh, sizeof( sseSpriteHeader ) + (sh->NumFrames-1) * 
      sizeof( sseSpriteGraphicInfo ), 1, fp );
   fwrite( hsi, sizeof( HiddenSpriteInfo ) * sh->NumFrames, 1, fp );
   fwrite( outbuffer, out-outbuffer, 1, fp );
   fclose( fp );
   
   if( filecount > 2 )
      printf("\n Total: %d frames captured.\n\n", sh->NumFrames );

   return EXIT_SUCCESS;

}


int ReadWholePCX( char * dest, imgInfo * img, char * filename )
{ 
   FILE * fp;
   pcxHeader ph;

   if( !( fp = fopen( filename, "rb" )) )
   {
      printf( "Error opening PCX file \"%s\"!\n\n", filename );
      return 1;
   }
   pcxGetHeader( & ph, fp );

   if( ph.BitsPerPixel != 8 )
   {
      printf( "PCX file \"%s\" is not in 256 colors!\n\n", filename );
      fclose( fp );
      return 1;
   }

   if( ph.Width * ph.Height > MAX_PCX_SIZE )
   {
      printf( "Cannot handle PCX file \"%s\"!\n", filename );
      printf( "  Solution: Increase CAPT-SSP \"MAX_PCX_SIZE\" value.\n\n" );
      return 1;
   }
   
   pcxDecodeToBuffer( dest, ph.Width, ph.Height, fp );
   fclose( fp );

   img->Width = ph.Width;
   img->Height = ph.Height;
   img->BytesPerRow = ph.Width;
   img->Data = dest;

   return 0;
}


int CaptureAllFrames( char * outbuffer, char ** CP, imgInfo * pic, sseSpriteHeader * sprhdr, HiddenSpriteInfo * hsi )
{
   char BackColor, TagColor, * in, * out;
   int w;
   imgInfo * img;
   sseSpriteGraphicInfo * si;

   out = *CP;

   BackColor = *(pic->Data);
   in = pic->Data;
   w = pic->Width;

   si = sprhdr->Frame + sprhdr->NumFrames;
   hsi += sprhdr->NumFrames;

   while( *in == BackColor )
   {
      in++;
      if( !(--w) )
      {
         w = pic->Width;
         in += pic->BytesPerRow - pic->Width;
         if( in >= pic->Data + pic->BytesPerRow * pic->Height ) break;
      }
   }
   TagColor = *in;

   if( in >= pic->Data + pic->BytesPerRow * pic->Height ) return 0;

   while( 1 )
   {
      img = imgFindNext( pic, in, TagColor );

      if( img->Width == 0 ) break;
      in = img->Data + img->Width;  // Set up for next image

      if( out + img->Width * img->Height * 10 > outbuffer + MAX_SPRITE_DATA )
      {
         printf( "\nOut of sprite data memory!\n" );
         printf( "  Solution: Increase CAPT-SSP \"MAX_SPRITE_DATA\" value.\n\n");
         return 1;
      }
      if( sprhdr->NumFrames >= MAX_FRAMES )
      {
         printf( "\nCannot handle more than %d frames!\n",MAX_FRAMES );
         printf( "  Solution: Increase CAPT-SSP \"MAX_FRAMES\" value.\n\n");
         return 1;
      }

      if( captSetupSpriteGraphicInfo( si, hsi, img, 0, 0, BackColor ) )
      {
         printf( "\nCannot capture blank frames!\n\n" );
         return 1;
      }

      out = captSSPFrame( si, outbuffer, out, img, BackColor, LINE_LENGTH );
      out = captEraseFrame( si, outbuffer, out, img, BackColor, LINE_LENGTH );

      si++;
      hsi++;
      sprhdr->NumFrames++;
   }

   *CP = out;
   return 0;
}
