/*

	eb4.hpp
	8-10-91
	Electronic Book: header for eb4.cpp

	Copyright 1991
	John W. Small
	All rights reserved

	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072 USA

	John Small
	Voice: (703) 759-3838
	CIS: 73757,2233

*/

#ifndef EB4_HPP
#define EB4_HPP


#ifndef FLEXLIST_CPP
#include <flexlist.hpp>
#endif

#ifndef EB1_HPP
#include <eb1.hpp>
#endif

#ifndef EB2_HPP
#include <eb2.hpp>
#endif

#ifndef EB3_HPP
#include <eb3.hpp>
#endif


/*

	The Arguments class is a FlexList for vectorizing
	a string of arguments.  It is used in the spawn
	call of HyperView::view().

*/

class Arguments : FlexList  {
	char buf[MAX_ARG_LEN];
	char ** V;
public:
	Arguments(const char * A);
	unsigned argc()  { return (V? Nodes() : 0); }
	char * argv0()  {  return (V? V[0] : (char *)0); }
	char ** argv()  { return V; }
	~Arguments() { delete V; }
};
typedef Arguments *ArgumentS;
#define ArgumentS0 ((ArgumentS)0)



/*

	The HyperView is the user inteface to EB's hypertext
	engine.

*/

class HyperView  {
	HyperStack hstk;
	HyperContexT HC;
	HyperServer hser;
	PickTOC TOC;
	PickIDX IDX;
	void help();
public:
	HyperView() : hstk(), hser()
	{
		HC = HyperContexT0;
		TOC = PickTOC0;
		IDX = PickIDX0;
	}
	int view(const char * hyperFname =
		(char *)0, const char * topic = (char *)0,
		int l = 5, int t = 5,
		int r = 75, int b = 20);
	int viewFullScreen(
		const char * hyperFname = (char *) 0,
		const char * topic = (char *) 0)
		{ return view(hyperFname,topic,0); }
	~HyperView();
};



#endif

