-----------------------------------------------------------------
VOUCH  version  1.1.  Copyright (c) 1993, 1994  Awais M. Hussain.
-----------------------------------------------------------------

The description of NIST Digital signature standard (DSS) may be found
in [1], [2] (or see [3] for a short description). The secure hash
standard is contained in [4]. (Partial descriptions may also be found
in recent articles in pop computer magazines.)

The DSS requires operations on numbers as long as 512-1024 bits. The
basic construct used to represent such numbers is the LN
(long-number) which is an "array of long unsigned". The type
definitions used are:

 typedef unsigned lenLN ;        /* length of the LN (in 32-bit words) */
 typedef long unsigned  *ptrLN ; /* pointer to the LN */

Thus for example, a LN (Lpp,pp) is declared as:

  int bLen = 24 ; /* longest expected length in bytes of a LN */
  lenLN Lpp;
  ptrLN pp ;

and used as:

  pp = (ptrLN) malloc( bLen ) ; /* allocate space for the LN (Lpp,pp) */
  pp[0] = 0xFFFF7777 ;
  pp[1] = 0xABCDE986 ;
  pp[2] = 0x54321 ;
  Lpp = 3 ;  /* length of the LN space in use */

Thus the LN (Lpp,pp) in hex is "0x54321ABCDE986FFFF7777". Since it
uses three 32-bit words, the length (Lpp) is specified as 3. Note
that pp[0] represents the LSW (least significant word) whereas
pp[Lpp-1] is the MSW. The length of a LN must be specified correctly;
there should be no leading zero-words. Thus 

  pp[0] = 0x12345678 ;
  pp[1] = 0 ;
  Lpp=2 ;    /* It should be Lpp=1 */

is INCORRECT.

=============================================================
Terminology used in <*.man> files:
-----------
I : denotes input parameter passed to a function.
O : denotes output result passed back by the function.
I/O: denotes a parameter which is changed by the function.

For example:

   void foo( int xi, int *xo, int *xio )
   {
      *xo = xi * xi ;
      (*xio) += xi ;
   }

   I: xi 
   O: xo
   I/O: xio

The designations {I,O,I/O} depend on the role given to the parameters
in the context of the function, which is not necessarily evident by
the C-declaration rules. Notice that we disregard the fact that "xo"
is actually a pointer, and write "xo" for "*xo".
=============================================================

==============================================
Files Description:
----------------------------------------------
<VCH.EXE>
Main VOUCH program.

vch.c : main VOUCH program file.

vch.h : header file.
-----------------------------------------------
Support program files.

blnr.c, blnrasm.asm :  basic LN arithmetic routines.

gfmr.c : Galois field modular arithmetic high-level routines (use
         <blnr.c> routines).

rndm.c : for generation of random LNs.

vio.c : some console I/O routines needed by <vch.c>.

vfio.c : some generic file I/O routines.

sfio.c : some special file (non-generic) I/O routines.

hasher.c, hash.asm : implements routines for the NIST hash standard [4].

feal.c : routines for encryption/decryption. Implements the Fast
         Encipherment Algorithm FEAL-64/X [5].

timer.c : routines for timing events.

hlp.c : displays contextual help messages.

fb1.c : a single in-line assembly-routine.

t86.asm : determines the processor type (86/286/386).

---------------------------------------------------------
<PubKey.exe>
For generation of public key parameters 'p', 'q', 'g'. 

pubkey.c : Main program file.

pubkey.h : header file.

-----------------------------------------------------------
<RmLn.exe>
Removes specified number of top lines of a file.

rmln.c : Main program file.

---------------------------------------------------------
Six-bit encoding. <a2b.exe>, <b2a.exe>

a2b.c : Main program. Six-bit encode. Convert a file to "text"
        suitable for transmission via e-mail systems.  

b2a.c : Main program. Six-bit decode. Reverse of <a2b.c>.

----------------------------------------------------------
Security Tool. <vstc.exe>, <vstd.exe>.

vstc.c : Main program. Security tool (for capping). Calls other
         executable programs.

vstd.c : Main program. Security tool (for de-capping). Calls other
         programs.

vst.h : header file.

vstl.c : support routines.

-----------------------------------------------------------
              ______    ____________
              VCH.C :   Program Flow
              
For the command line options, see <usrGuide.vch> (Section IV and
Appendix D).

1. First of all a check makes sure that the processor is 80386 or
higher by calling test8086().

2. If no arguments are given on the command line, the program
displays the short identification message.

3. All the arguments are converted to lowercase.

4. If the first argument is "/?", a help screen is displayed.

5. VOUCH command line expects a single option (/x) followed by an
appropriate parameters list. According to the option, the variable
"option" is assigned a numeric value for future use (/sgn=10,
/sig=11, /fsgn=20, /fsig=21, /vsgn=30, /vsig=31, /h=40, /c=50, /d=60,
/k=70, /r=80, /p=90, /i=100, /?=110). If the option is not legal, the
program exits. For each legal option, a check is made to see that the
required number of parameters have been specified; if not a call to
exit_hlp() for contextual help is made and the program exits.

6. The DOS environment variable VCH contains the name of the
VOUCH-directory (See <usrGuide.vch> Section III.) This string is
assigned to "cDir". Next various variables, which hold the names of
files used by VOUCH, are initialized. If the file "init.vch" does not
exist, it is created by prompting the user for a 32-character string.
The log-file "vch.log" is opened for recording.

7. According to the value of variable "option", appropriate actions
are taken by the switch-statement:

option=100:  Individualize :   Vch /i
By this time, the individualization string has already
been taken care of, so nothing is done; the program simply exits.

option=70: Generate new keys :   Vch /k
The user is asked to confirm if he wants to go ahead with the
generation of new keys (private key (LxSec,xSec) and public-key
parameter (LyPub,yPub)). The user is then asked to enter a 8-32
character password which is used to encrypt the private-key before
storing the key in file <myPrivat.key>. If the user presses <return>
on the password prompt, the private-key will be stored in clear
(unencrypted).  A call to init() initializes; reserves space for
various LNs and sets the flag "init_ed=1." A call to readPrime()
reads in the parameters 'p', 'q', 'g' of the public-key in (Lpp,pp),
(Lqq,qq), and (Lgg,gg), respectively. Also the parameter "Nres,"
which is used in <gfmr.c> for modular calculations (modulo (Lpp,pp)),
is set to Lpp.  The random number generation module is initialized by
calling init_rndm().  For generating the new keys, the function
genKeys() is finally called. If the file <r_sign.vch> containing
pre-computed r-signatures exists, it is deleted since the generaton
of new keys make the pre-computed r-signatures invalid. 

option = 10, 11, 20, 21:  sign message or hash :
   Vch /sgn   <message>	<signed_message>  [password]
   Vch /sig   <hash>  <signature>  [password]
   Vch /fsgn  <message>  <signed_message>  [password]
   Vch /fsig  <hash>   <signature>  [password]

The input-filename is assigned to the variable "inFile" whereas the
output-filename is assigned to variable "outFile." If the password is
not specified on the command-line it is asked for by a call to
getPswd(). If the specified input and output filenames are the same,
the program exits. A check is made to see that the input file does
exist. In preparation for the calculations, a call is made to init().
The private-key is read from <myPrivat.key> and decrypted by the
function read_prvKey(). If the fast-sign option was specified, a
check is made to see that the file <r_sign.vch> does exist. For /sgn,
/fsgn options, the hash number for the input file is computed in
(Lmhash, mhash) by calling hash(). For options /sig, /fsig, the hash
LN is read from the input file. For options /sgn, /sig, the
r-signature component is computed in (LrSign, rSign) by calling
rSignature(). This routine also computes the k^{-1} random LN, needed
in the DSS procedure, in (LkSec,kSec). For /fsgn, /fsig options, a
call to read_rFile() reads the LNs (LkSec,kSec) and (LrSign,rSign)
from the file <r_sign.vch>; the LN (LkSec,kSec) is decrypted after
reading. Next the s-signature component is computed in (LsSign,
sSign) by calling sSignature(). It is ensured that the computed LN
(s-signature) is non-zero. The output file is created with a
id-header-line followd by two lines containing the r- and s-signature
components, followed by the contents of the input file.


option=30, 31: verify signed message or signature :
   Vch /vsgn  <signed_message>   <signer's_public_key>
   Vch /vsig  <signature>   <signer's_public_key>

The variable "fPubKey" is filled with the public-key
filename of the person whose signature need to be verified. If the
extension (.key) is not specified on the command line, it is appended
to the filename string. A check is made to see that the input file
does exist. A call to init() and readPrime() follows. The Y-parameter
of the public-key is read from "fPubKey." The siganture components
are read in from the input file. For option=/vsgn, the hash LN of the
input file (excluding the first three lines) is computed; for
option=/vsig, the hash LN is read from the input file. A call to
verify() determines if the signature verify. If the signature does not
verify, the DOS-exit-code equals 111.

option=80: pre-compute r-signature components :
           Vch /r   number  [password]
If the "number" specified as the number of desired r-signature
components is invalid, the program exits. Gets the password from the
command line or by prompting the user. The usual initializations are
made. The public and private keys are read. A check is made to see
that the relation yPub = gg^(xSec) mod pp holds. (The relation is
obviously true if the parameter values are correct.) This guards
against the entry of an incorrect password. The r-signature
components are computed by calls to rSignature() and written to
<r_sign.vch> via calls to write_rFile(). When the total number of
r-signatures in <r_sign.vch> equals the number specified or the user
interrupts by hitting Cntl-D, the program exits.

option=90: set/change password & check integrity of key-files :
           Vch /p
First the current password is asked for. If the user hits
<return>, the string-variable pswd is set to "".  The validity of the
password is determined by checking if the relation [yPub =
gg^(xSec) mod pp] holds. A failure to verify signify incorrect
password or corruption of public/private key files. Next other
relations that should be true are checked to detect possible
corruption of key files, namely (1) qq divides pp-1 (2) gg^qq mod pp =
1. If the relations are satisfied, the new password is asked for. The
private-key is encrypted with the new password and saved on disk. The
LNs (LkSec,kSec) in file <r_sign.vch>, if there, are also encrypted
with the new password.

option=40:  hash message :
Vch /h     <message>   <hash>   [<signature>]
Space for hash LN (Lmhash, mhash) is allocated. The hash
LN of the input file is calculated by a call to hash(). If errors
occur, deallocation of LN memory is done before exit. Notice that
call to init() is not made. The hash LN is written in the output file
preceeded by the id header. If the signature file is specified on the
command line or the *.sig file corresponding to input filename
exists, the hash LN in the signature-file is compared for equality
with the computed hash LN. This is an essential step in verifying a
signature file.

option=50:  Encrypt file :
Vch /c     <plain>  <cipher>  <receiver's_public_key>
The public-key filename of the recipient is assigned to
the variable "fPubKey." If the length of p-parameter of public key is
less than 128 bits, the program exits, since the encryption routine
requires a 128-bit encrypting-key.  A call to encrypt() encrypts the
input file and writes the cipher in the output file. The cipher is
preceeded by the id header and a LN needed by the recipient to find
the encrypting-key (see <usrGuide.vch>, Appendix F).

option=60:  decrypt file :
Vch /d     <cipher>  <plain>  [password]
The password is gotten. The public key of the user
(recipient) is read.  The private key is read. A call to decrypt()
converts the ciphertext back into plaintext. The encryption-key is
found using the LN in the input file and the private-key (see
<usrGuide.vch>, Appendix F).


8. If the routine init() was called, and the program reaches this far,
the function exit_proc() is called before terminating.

-------------------------------------------------------------------

              _________________________
              PUBKEY.C :   Program Flow

For the command line options, see <PubKey.vch>.

1. First of all a check makes sure that the processor is 80386 or
higher by calling test8086().

2. If proper number of arguments are not given on the command line,
the program displays a help screen.
 
3. PubKey.exe command-line expects a single option (/x) followed by an
appropriate parameters list. According to the option, the variable
"option" is assigned a numeric value for future use (/q=1,
/p=2, /g=3). The filename specified on the command line is copied
into the variable "fname."

4. If the file "init.vch" does not exist, it is created by prompting
the user for a 32-character string.

5. option=1: generate 'q'-parameter of public-key : 
             PubKey /q  <filename> [Length in 32_bit words] : 
If the length of the q-parameter is not specified on the command
line, a default value of Lqq=5 (160 bits) is used. A call to init()
allocates memory for some LNs. The function gen_q() is called to
generate the prime LN (Lqq,qq). The generated LN is written to a file
named by "fname," and the bell rings.

6. option=2: generate the 'p'-parameter of the public key :
             PubKey /p  <filename>  [Length in 32_bit words]  :
If the length of p-parameter is not specified on the command line, a
default value of Lpp=16 (512 bits) is used. After a call to init()
for allocating space for LNs, the 'q'-parameter is read from the
input-file in (Lqq,qq). If the q-length (Lqq) is greater or equal to
p-length (Lpp), the program exits. The p-parameter is generated by
calling gen_p(). Just to make sure, it is checked that 'q' does divide
(p-1). The existing input file is renamed <*.old>. The LNs (Lpp,pp)
and (Lqq,qq) are written to the file (with the original name) on two
separate lines (see <usrGuide.vch>, Appendix B for format). 

7. option=3: generate the 'g'-parameter of public key :
             PubKey /g  <filename>  :
If the input file does not exist, the program exits. The p-length is
read from the input-file in "pLen." After init(), the LNs (Lpp,pp),
(Lqq,qq) are read from the input file. A call to gen_g() generates
the 'g'-parameter. If gen_g() reports an error, the program exits.
The generated LN (Lgg,gg) is appended to the input file.
-------------------------------------------------------------------
                     _____________________
                     RmLn.c : Program Flow

Syntax:  rmln.exe  number_of_lines  <inFile>   <outFile>

1. If proper number of arguments are not specified on the command
line, a help screen is displayed. The second argument is copied into
input filename variable "fni" while the third argument is copied into
the "fno" filename variable. The number of top-lines to be removed
of the input file (the first argument) is copied into "nl". A call
to function strip() does the job, putting the topless file as "fno."

--------------------------------------------------------------------
                     ____________________
                     b2a.c : Program Flow

Syntax:      b2a.exe <inFile> <outFile>

If the proper number of arguments are not specified, a help screen is
displayed.  A call to bin2text() does the six-bit encoding (from
"binary" to "text") of the input file, writing the result to the
output file.

--------------------------------------------------------------------
                    ____________________
                    a2b.c : Program Flow

Syntax:        a2b.exe <inFile> <outFile>

If the proper number of arguments are not specified, a help screen is
displayed.  A call to text2bin() does the six-bit decoding (from
"text, back to "binary") of the input file, writing the result to the
output file.

-----------------------------------------------------------------------
                     _____________________
                     vstc.c : Program Flow

Syntax:   vSTc.exe  <inFile>  [vch_Path]

1. If the proper number of arguments is not specified, a help screen is
displayed. If the input file does not exist, the program exits. 

2. If the second argument is not specified, the default vch_path is
taken as "C:\VCH". 

3. The options-list is displayed and the user is asked to pick a
sequence of options. The options-sequence is read in the
string-variable "sequence." The indicies corresponding to the options
are filled in the array "sq[]". If the number of operations specified
by "sq[]" is more than six, the program exits (it is assumed that the
user does not know what she is doing!). If no option is specified the
program exits.

4. The time-stamp is put on the log-file <vch.log>. The
VOUCH-Directory name is also displayed.

5. The sequence of options are executed by repeatedly calling the
function brew(). The output-file for the previous operation becomes
the input file for the next operation. If brew() reports an error the
program exits. The function brew() calls the executables <vch.exe>
and <b2a.exe>.  After executing option=3 (hash & signature), the
program necessarily exits (since it does not make sense to continue).

6. The final output file is renamed to have the same filename as the
input-file but with an appropriately different extension. 
-------------------------------------------------------------------
                       _____________________
                       vstd.c : Program Flow

Syntax : vSTd.exe  <inFile>  [vch_path]

1. If the proper number of arguments are not specified, a help screen is
displayed. If the input file does not exist, the program exits. 

2. If the second argument is not specified, the default vch_path is
taken as "C:\VCH". 

3. The time-stamp is put on the log-file <vch.log>. The
VOUCH-Directory name is also displayed.

4. The input-file is processed repeatedly by the do-while construct.
A layer of operation performed earlier by <vstc.exe> is "reversed" in
each iteration. The output-file for the previous operation becomes
the input file for the next operation. A call to cap() determines the
type of the input-file and stores the type in variable "kind." The
cap() function works by examining the header of the file.
(kind=1 => six-bit encoded; kind=2 => encrypted; kind=3 =>
signed-message; kind=4 => signature (signed-hash); kind=5=>
hash number (verify it).) The "decapping" is done by calling the
executables <vch.exe>, <a2b.exe>, <rmLn.exe>.

5. The final output file is renamed to have the same filename as the
input-file but with an appropriately different extension. 
-------------------------------------------------------------------

------References---------------------------------------------------
[1] US National Institute of Standards and Technology (NIST), ``A
Digital Signature Standard,'' FIPS PUB XX, August 19, 1991.  Copies
available from NTIS, US Department of Commerce, Springfield, VA
22161.

[2] ACM, Communications of the ACM, July 1992.

[3] Appendix A, <usrGuide.vch> accompanying the VOUCH package.

[4] NIST, ``A Secure Hash Standard,'' FIPS PUB YY, Jan. 22, 1992.

[5]  S. Miyaguchi, S. Kurihara, K. Ohta, and H. Morita, 
     "Expansion of FEAL cipher,"  NTT Review, Vol. 2, No. 6, 
     Nov. 1990. (Also in CRYPTO '90 Proceedings. LNCS, 
     Springer-Verlag 1991.)

----------------------------------15 December 1994-----------------