/**<hasher.c>************************************************
*                       V O U C H                           *
*   VOUCH 1.1  Copyright (c) 1993, 1994  Awais M Hussain    *
*          revised April 1999				    *
*                   All rights reserved                     *
*************************************************************/
/* Consult <hasher.man> for documentation. */
#include "vch.h"
#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include <mem.h>
#include <string.h>

#define ROLN(n,x) (( (x) << n) | ((x) >> (32-n) ))

#define SLEN 2048
#define NBUFF 4096

int hash( int  rcv, char  *fname, lenLN  *Lmhash, ptrLN  mhash ) ;

static long unsigned hx[5] = { 0x67452301UL, 0xefcdab89UL, 0x98badcfeUL,
                                    0x10325476UL, 0xc3d2e1f0UL } ;

static const long unsigned
 K0 = 0x5a827999, K1 = 0x6ed9eba1,  K2 = 0x8f1bbcdc, K3 = 0xca62c1d6 ;
				    

static long unsigned Wbuff[80] ;

static long fs1, fs2 ; /* (fs2, fs1) = filelength in bits */

/**************************************************************/

int extran( unsigned *hC, char *fname )
{
  FILE *ff ;
  int r ;
  char *buff ;

  if ( (ff = fopen( fname, "rb" )) == (FILE*) NULL ) return(3) ;
  buff = (unsigned char*) malloc( SLEN ) ;
  *hC = 0 ;
  for (r=0; r<3; ++r ) {
    fgets( buff, SLEN, ff ) ;
    *hC += strlen(buff) ;
  }
  fclose(ff) ;
  free(buff) ;
  return(0) ;
}/*extran*/


int paddCount( int rcv, int hC, int *count, char *fname )
{
    int ff ;
    long fsize ;
    ptrLN h1, h2, h3 ;
    lenLN Lh1, Lh2, Lh3 ;
    
    if ( (ff = open( fname, O_RDONLY)) == -1 ) return(errno);
    fsize = filelength( ff ) ;
    close( ff ) ;
    if (rcv) fsize -= hC ;
    h1 = (ptrLN) malloc(12) ;
    h2 = (ptrLN) malloc(12) ;
    h3 = (ptrLN) malloc(12) ;
    Lh1 = 1 ;
    *h1 = fsize ;
    shiftL( 3, Lh1, h1, &Lh2, h2 ) ;  /* h2 = fsize * 8 (bits) */
    fs1 = *h2 ;
    fs2 = 0 ;
    if (Lh2==2)  fs2 = *(h2+1) ;
    Lh1 = 1 ; *h1 = 1 ;
    accum( Lh1, h1, &Lh2, h2 ) ; /* h2 = fsize*8+1 */
    Lh1 = 1 ; *h1 = 512 ;
    modR( Lh2, h2, Lh1, h1, &Lh3, h3 ) ;  /* h3 = (fsize*8+1) mod 512 */
    if ( *h3 <= 448 )
      *count = 448 - *h3 ; /* number of zeros to be padded */
    else  *count = 512 - *h3 + 448 ;
    free( h3 ) ; free( h2 ) ; free( h1 ) ;
    return 0 ;
}/*paddCount*/


void movrev( char *sx, char *dx, int nb )
{
  char  *dx1 = dx+1, *dx2=dx+2, *dx3=dx+3 ;
  int i, ix, nb4 ;

  nb4 = nb/4 ;
  for (i=0; i<nb4; ++i) {
    ix = i*4 ;
    *(dx3+ix) = *sx++ ;
    *(dx2+ix) = *sx++ ;
    *(dx1+ix) = *sx++ ;
    *(dx+ix) = *sx++ ;
  }
}/* movrev */

void hshBlk( long unsigned *hx, long unsigned *Wbuff )
{
  long unsigned  AAx = hx[0], BBx = hx[1], CCx = hx[2], DDx = hx[3],
                 EEx = hx[4], tx ;
  long unsigned  *w00 = Wbuff, *w02 = w00+2, *w08=w00+8, *w13=w00+13,
       		 *w16=w00+16, *w_end=w00+80 ;

  while ( w16<w_end ) {
#ifdef NIST_SHA_1
    *w16++ = ROLN(1, *w13++ ^ *w08++ ^ *w02++ ^ *w00++) ;
#else
    *w16++ = *w13++ ^ *w08++ ^ *w02++ ^ *w00++ ;
#endif  
  }
   w00 = Wbuff ; w_end = w00 + 20 ;
   while (w00<w_end) {
     tx = (BBx & CCx) | (~BBx & DDx)  ;
     tx += ROLN(5,AAx) + EEx + K0 + *w00++ ;
     EEx = DDx ; DDx = CCx ;
     CCx = ROLN(30,BBx) ;
     BBx = AAx ; AAx = tx ;
   }
   w_end = w00 + 20 ;
   while (w00<w_end) {
     tx = BBx ^ CCx ^ DDx ;
     tx += ROLN(5,AAx) + EEx + K1 + *w00++ ;
     EEx = DDx ; DDx = CCx ;
     CCx = ROLN(30,BBx) ;
     BBx = AAx ; AAx = tx ;
   }
   w_end = w00 + 20 ;
   while (w00<w_end) {
     tx = (BBx & CCx) | ( BBx & DDx) | ( CCx & DDx ) ;
     tx += ROLN(5,AAx) + EEx + K2 + *w00++ ;
     EEx = DDx ; DDx = CCx ;
     CCx = ROLN(30,BBx) ;
     BBx = AAx ; AAx = tx ;
   }       
   w_end = w00 + 20 ;
   while (w00<w_end) {
     tx = BBx ^ CCx ^ DDx ;
     tx += ROLN(5,AAx) + EEx + K3 + *w00++ ;
     EEx = DDx ; DDx = CCx ;
     CCx = ROLN(30,BBx) ;
     BBx = AAx ; AAx = tx ;
   }       
   hx[0] += AAx ; hx[1] += BBx ; hx[2] += CCx ;
   hx[3] += DDx ; hx[4] += EEx ;
}/*hshBlk*/


int hash( int  rcv, char  *fname, unsigned  *Lmhash, ptrLN  mhash )
{
  FILE *ff ;
  char *fbuff ;
  unsigned hC ;
  int j,jess, done, rcnt, cnt, padd, bpadd, lft, err ;

  if (rcv)
    if ( (err = extran( &hC, fname )) != 0 ) return( err )  ;
  if ( (err = paddCount( rcv,  hC, &padd, fname )) !=0 ) return( err ) ;
  if ( (ff = fopen( fname, "rb" )) == (FILE*) NULL ) return(2) ;
  fbuff = (char*) malloc( NBUFF ) ;
  if (rcv) {
    rcnt = fread( fbuff, 1, hC, ff ) ;
    if (rcnt<hC) { free(fbuff) ; fclose(ff) ; return(70) ; }
  }
  bpadd = (padd-7) / 8 ; done = 0 ;
  cnt = NBUFF ; rcnt = cnt ; jess = 0 ;
  while ((rcnt==cnt) && (!done)) {
    jess++ ;
    rcnt = fread( fbuff, 1, cnt, ff ) ;
    if (rcnt<cnt) done = 1 ;
    j = 0 ;
    while (j+64<=rcnt) {
      movrev( &fbuff[j], (char*) &Wbuff, 64 ) ;
      hshBlk( hx, Wbuff ) ; j += 64 ;
    }
  }
  fbuff[rcnt] = 0x80 ;
  lft = 63 - (rcnt-j) ;
  setmem( &fbuff[rcnt+1], lft, 0 ) ;
  movrev( &fbuff[j], (char*) &Wbuff, 64 ) ;
  if (bpadd == (lft-8)) {
    Wbuff[14] = fs2 ; Wbuff[15] = fs1 ;
    bpadd = 0 ;
    hshBlk( hx, Wbuff ) ;
  } else {
    bpadd -= lft ;
    hshBlk( hx, Wbuff ) ;
    setmem( &Wbuff, 64, 0 ) ;
    Wbuff[14] = fs2 ; Wbuff[15] = fs1 ;
    bpadd = 0 ;
    hshBlk( hx, Wbuff ) ;
  }
  *Lmhash = 5 ;
  for (j=0; j<5; ++j)
    *(mhash+j) = hx[4-j] ;
  fclose( ff ) ;
  free( fbuff ) ;
  while ( (*(mhash+*Lmhash-1)==0) && (*Lmhash>1) )  (*Lmhash)-- ;
  return(0) ;
}/* hash */



